/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.link;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.edge.EdgeViewFactory;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.OutlineLinkView;

public class EdgeLinkView
extends AConnectorView {
    private final EdgeView edgeView;

    public EdgeLinkView(ConnectorModel model, ModeController modeController, NodeView source, NodeView target) {
        super(model, source, target);
        Color color;
        MapView map = source.getMap();
        this.edgeView = map.getLayoutType() == MapViewLayout.OUTLINE ? new OutlineLinkView(source, target, map) : EdgeViewFactory.getInstance().getEdge(source, target, map);
        if (ConnectorModel.Shape.EDGE_LIKE.equals((Object)model.getShape())) {
            color = this.edgeView.getColor().darker();
        } else {
            LinkController linkController = LinkController.getController(modeController);
            color = linkController.getColor(this.connectorModel);
            int alpha = linkController.getAlpha(this.connectorModel);
            color = ColorUtils.alphaToColor(alpha, color);
            int width = linkController.getWidth(model);
            this.edgeView.setWidth(width);
        }
        this.edgeView.setColor(color);
    }

    @Override
    public boolean detectCollision(Point p, boolean selectedOnly) {
        NodeView target;
        NodeView source;
        if (!(!selectedOnly || (source = this.edgeView.getSource()) != null && source.isSelected() || (target = this.edgeView.getTarget()) != null && target.isSelected())) {
            return false;
        }
        return this.edgeView.detectCollision(p);
    }

    @Override
    public ConnectorModel getModel() {
        return this.connectorModel;
    }

    @Override
    public void increaseBounds(Rectangle innerBounds) {
    }

    @Override
    public void paint(Graphics graphics) {
        Point p2;
        Point p1;
        this.edgeView.paint((Graphics2D)graphics);
        if (ConnectorModel.Shape.EDGE_LIKE.equals((Object)this.connectorModel.getShape())) {
            return;
        }
        if (this.isSourceVisible() && !this.connectorModel.getStartArrow().equals((Object)ArrowType.NONE)) {
            p1 = this.edgeView.getStart();
            p2 = new Point(p1);
            p2.translate(5, 0);
            this.paintArrow(graphics, p2, p1);
        }
        if (this.isTargetVisible() && !this.connectorModel.getEndArrow().equals((Object)ArrowType.NONE)) {
            p1 = this.edgeView.getEnd();
            p2 = new Point(p1);
            p2.translate(5, 0);
            this.paintArrow(graphics, p2, p1);
        }
    }

    private void paintArrow(Graphics graphics, Point from, Point to) {
        this.paintArrow(from, to, (Graphics2D)graphics, this.getZoom() * 10.0);
    }
}

