/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard.mindmapmode;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ExampleFileFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.FixedHTMLWriter;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.MindMapNodesSelection;
import org.freeplane.features.clipboard.mindmapmode.CloneAction;
import org.freeplane.features.clipboard.mindmapmode.CutAction;
import org.freeplane.features.clipboard.mindmapmode.MoveAction;
import org.freeplane.features.clipboard.mindmapmode.PasteAction;
import org.freeplane.features.clipboard.mindmapmode.SelectedPasteAction;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.CloneEncryptedNodeException;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.SummaryGroupEdgeListAdder;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.view.swing.features.filepreview.ImageAdder;
import org.freeplane.view.swing.features.filepreview.ViewerController;

public class MClipboardController
extends ClipboardController {
    public static final String RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_NODES = "remind_use_rich_text_in_new_nodes";
    private static final Pattern HEADER_REGEX = Pattern.compile("h(\\d)", 2);
    private static final Pattern HREF_PATTERN = Pattern.compile("<html>\\s*<body>\\s*<a\\s+href=\"([^>]+)\">(.*)</a>\\s*</body>\\s*</html>");
    private static final String RESOURCE_UNFOLD_ON_PASTE = "unfold_on_paste";
    public static final String RESOURCES_CUT_NODES_WITHOUT_QUESTION = "cut_nodes_without_question";
    private List<NodeModel> newNodes;

    public static String firstLetterCapitalized(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
    }

    public MClipboardController() {
        this.createActions();
    }

    private String cleanHtml(String in) {
        in = in.replaceFirst("(?i)(?s)<head>.*</head>", "").replaceFirst("(?i)(?s)^.*<html[^>]*>", "<html>").replaceFirst("(?i)(?s)<body [^>]*>", "<body>").replaceAll("(?i)(?s)<script.*?>.*?</script>", "").replaceAll("(?i)(?s)</?tbody.*?>", "").replaceAll("(?i)(?s)<!--.*?-->", "").replaceAll("(?i)(?s)</?o[^>]*>", "");
        if (StringUtils.equals((String)ResourceController.getResourceController().getProperty("cut_out_pictures_when_pasting_html"), (String)"true")) {
            in = in.replaceAll("(?i)(?s)<img[^>]*>", "");
        }
        in = HtmlUtils.unescapeHTMLUnicodeEntity((String)in);
        return in;
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new CutAction());
        modeController.addAction((AFreeplaneAction)new PasteAction());
        modeController.addAction((AFreeplaneAction)new SelectedPasteAction());
        modeController.addAction((AFreeplaneAction)new CloneAction());
        modeController.addAction((AFreeplaneAction)new MoveAction());
    }

    public Transferable copy(IMapSelection selection) {
        List collection = selection.getSortedSelection(true);
        MindMapNodesSelection transferable = this.copy(new SummaryGroupEdgeListAdder(collection).addSummaryEdgeNodes(), false);
        transferable.setNodeObjects((Collection)collection, false);
        return transferable;
    }

    public Transferable copySingle(Collection<NodeModel> source) {
        MindMapNodesSelection transferable = (MindMapNodesSelection)super.copySingle(source);
        transferable.setNodeObjects(new ArrayList<NodeModel>(source), true);
        return transferable;
    }

    Transferable cut(List<NodeModel> collection) {
        Controller.getCurrentModeController().getMapController().sortNodesByDepth(collection);
        MindMapNodesSelection transferable = this.copy(new SummaryGroupEdgeListAdder(collection).addSummaryEdgeNodes(), true);
        ((MMapController)Controller.getCurrentModeController().getMapController()).deleteNodes(collection);
        this.setClipboardContents((Transferable)transferable);
        return transferable;
    }

    private IDataFlavorHandler getFlavorHandler(Transferable t) {
        if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
            try {
                String textFromClipboard = t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor).toString();
                return new MindMapNodesFlavorHandler(textFromClipboard);
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            try {
                List<File> fileList = this.castToFileList(t.getTransferData(MindMapNodesSelection.fileListFlavor));
                if (!this.shouldIgnoreFileListFlavor(fileList)) {
                    return new FileListFlavorHandler(fileList);
                }
            }
            catch (UnsupportedFlavorException fileList) {
            }
            catch (IOException fileList) {
                // empty catch block
            }
        }
        ResourceController resourceController = ResourceController.getResourceController();
        DataFlavor supportedHtmlFlavor = this.getSupportedHtmlFlavor(t);
        if (supportedHtmlFlavor != null) {
            try {
                MTextController textController;
                boolean richText;
                String textFromClipboard = t.getTransferData(supportedHtmlFlavor).toString();
                if (textFromClipboard.charAt(0) != '\ufffd' && t.isDataFlavorSupported(DataFlavor.stringFlavor) && (richText = (textController = (MTextController)TextController.getController()).useRichTextInEditor(RESOURCES_REMIND_USE_RICH_TEXT_IN_NEW_NODES))) {
                    boolean structuredHtmlImport = resourceController.getBooleanProperty("structured_html_import");
                    IDataFlavorHandler htmlFlavorHandler = structuredHtmlImport ? new StructuredHtmlFlavorHandler(textFromClipboard) : new DirectHtmlFlavorHandler(textFromClipboard);
                    return htmlFlavorHandler;
                }
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString();
                return new StringFlavorHandler(plainTextFromClipboard);
            }
            catch (UnsupportedFlavorException plainTextFromClipboard) {
            }
            catch (IOException plainTextFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image image = (Image)t.getTransferData(DataFlavor.imageFlavor);
                return new ImageFlavorHandler(image);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean shouldIgnoreFileListFlavor(List<File> fileList) {
        if (fileList.isEmpty()) {
            return true;
        }
        File file = fileList.get(0);
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return name.endsWith(".URL") || name.endsWith(".url");
    }

    private List<File> castToFileList(Object transferData) {
        return (List)transferData;
    }

    Collection<IDataFlavorHandler> getFlavorHandlers() {
        DataFlavor supportedHtmlFlavor;
        Transferable t = this.getClipboardContents();
        LinkedList<IDataFlavorHandler> handlerList = new LinkedList<IDataFlavorHandler>();
        if (t == null) {
            return handlerList;
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
            try {
                String textFromClipboard = t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor).toString();
                handlerList.add(new MindMapNodesFlavorHandler(textFromClipboard));
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if ((supportedHtmlFlavor = this.getSupportedHtmlFlavor(t)) != null) {
            try {
                String textFromClipboard = t.getTransferData(supportedHtmlFlavor).toString();
                if (textFromClipboard.charAt(0) != '\ufffd' && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    handlerList.add(new StructuredHtmlFlavorHandler(textFromClipboard));
                    handlerList.add(new DirectHtmlFlavorHandler(textFromClipboard));
                }
            }
            catch (UnsupportedFlavorException textFromClipboard) {
            }
            catch (IOException textFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String plainTextFromClipboard = t.getTransferData(DataFlavor.stringFlavor).toString();
                handlerList.add(new StringFlavorHandler(plainTextFromClipboard));
            }
            catch (UnsupportedFlavorException plainTextFromClipboard) {
            }
            catch (IOException plainTextFromClipboard) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
            try {
                List<File> fileList = this.castToFileList(t.getTransferData(MindMapNodesSelection.fileListFlavor));
                handlerList.add(new FileListFlavorHandler(fileList));
            }
            catch (UnsupportedFlavorException fileList) {
            }
            catch (IOException fileList) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                BufferedImage image = (BufferedImage)t.getTransferData(DataFlavor.imageFlavor);
                handlerList.add(new ImageFlavorHandler(image));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return handlerList;
    }

    private DataFlavor getSupportedHtmlFlavor(Transferable t) {
        for (DataFlavor dataFlavor : t.getTransferDataFlavors()) {
            if (!dataFlavor.getPrimaryType().equals(MindMapNodesSelection.htmlFlavor.getPrimaryType()) || !dataFlavor.getSubType().equals(MindMapNodesSelection.htmlFlavor.getSubType()) || !dataFlavor.getRepresentationClass().equals(MindMapNodesSelection.htmlFlavor.getRepresentationClass())) continue;
            return dataFlavor;
        }
        return null;
    }

    public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft) {
        this.paste(t, target, asSibling, isLeft, 0);
    }

    public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
        if (t == null) {
            return;
        }
        IDataFlavorHandler handler = this.getFlavorHandler(t);
        this.paste(t, handler, target, asSibling, isLeft, dropAction);
    }

    void paste(Transferable t, IDataFlavorHandler handler, NodeModel target, boolean asSibling, boolean isLeft) {
        this.paste(t, handler, target, asSibling, isLeft, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paste(Transferable t, IDataFlavorHandler handler, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
        if (handler == null) {
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (asSibling && !mapController.isWriteable(target.getParentNode()) || !asSibling && !mapController.isWriteable(target)) {
            String message = TextUtils.getText((String)"node_is_write_protected");
            UITools.errorMessage((Object)message);
            return;
        }
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            if (this.newNodes == null) {
                this.newNodes = new LinkedList<NodeModel>();
            }
            this.newNodes.clear();
            handler.paste(t, target, asSibling, isLeft, dropAction);
            ModeController modeController = Controller.getCurrentModeController();
            if (!asSibling && modeController.getMapController().isFolded(target) && ResourceController.getResourceController().getBooleanProperty(RESOURCE_UNFOLD_ON_PASTE)) {
                modeController.getMapController().setFoldedAndScroll(target, false);
            }
            for (NodeModel child : this.newNodes) {
                AttributeController.getController().performRegistrySubtreeAttributes(child);
            }
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    private void pasteStringWithoutRedisplay(TextFragment[] textFragments, NodeModel parent, boolean asSibling, boolean isLeft) {
        int insertionIndex;
        MapModel map = parent.getMap();
        if (asSibling) {
            NodeModel target = parent;
            parent = parent.getParentNode();
            NodeModel childNode = target;
            insertionIndex = parent.getIndex(childNode);
        } else {
            insertionIndex = parent.getChildCount();
        }
        ArrayList<NodeModel> parentNodes = new ArrayList<NodeModel>();
        ArrayList<Integer> parentNodesDepths = new ArrayList<Integer>();
        parentNodes.add(parent);
        parentNodesDepths.add(new Integer(-1));
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        block2: for (int i = 0; i < textFragments.length; ++i) {
            TextFragment textFragment = textFragments[i];
            String text = textFragment.text;
            String link = textFragment.link;
            URI uri = null;
            if (link != null) {
                try {
                    URI linkUri;
                    uri = linkUri = new URI(link);
                    File absoluteFile = UrlManager.getController().getAbsoluteFile(map, uri);
                    if (absoluteFile != null) {
                        File mapFile = map.getFile();
                        uri = LinkController.toLinkTypeDependantURI((File)mapFile, (File)absoluteFile);
                        if (link.equals(text)) {
                            text = uri.toString();
                        }
                    }
                }
                catch (Exception linkUri) {
                    // empty catch block
                }
            }
            NodeModel node = mapController.newNode(text, map);
            if (uri != null) {
                NodeLinks.createLinkExtension((NodeModel)node).setHyperLink(uri);
            }
            for (int j = parentNodes.size() - 1; j >= 0; --j) {
                if (textFragment.depth <= (Integer)parentNodesDepths.get(j)) continue;
                for (int k = j + 1; k < parentNodes.size(); ++k) {
                    NodeModel n = (NodeModel)parentNodes.get(k);
                    if (n.getParentNode() == null) {
                        mapController.insertNode(n, parent, insertionIndex++);
                    }
                    parentNodes.remove(k);
                    parentNodesDepths.remove(k);
                }
                NodeModel target = (NodeModel)parentNodes.get(j);
                node.setLeft(isLeft);
                if (target != parent) {
                    target.setFolded(true);
                    target.insert(node, target.getChildCount());
                }
                parentNodes.add(node);
                parentNodesDepths.add(new Integer(textFragment.depth));
                continue block2;
            }
        }
        for (int k = 0; k < parentNodes.size(); ++k) {
            NodeModel n = (NodeModel)parentNodes.get(k);
            if (map.getRootNode() == n || n.getParentNode() != null) continue;
            mapController.insertNode(n, parent, insertionIndex++);
        }
    }

    public void addClone(Transferable transferable, NodeModel target) {
        this.processTransferable(transferable, target, Operation.CLONE);
    }

    public void move(Transferable transferable, NodeModel target) {
        this.processTransferable(transferable, target, Operation.MOVE);
    }

    private void processTransferable(Transferable transferable, NodeModel target, Operation operation) {
        try {
            boolean asSingleNodes;
            Collection clonedNodes;
            if (operation == Operation.CLONE && transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeSingleObjectsFlavor)) {
                clonedNodes = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeSingleObjectsFlavor);
                asSingleNodes = true;
            } else if (transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
                clonedNodes = (Collection)transferable.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
                asSingleNodes = false;
            } else {
                return;
            }
            ArrayList<NodeModel> movedNodes = new ArrayList<NodeModel>(clonedNodes.size());
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            for (NodeModel clonedNode : clonedNodes) {
                if (clonedNode.getParentNode() == null || !clonedNode.getMap().equals(target.getMap())) {
                    return;
                }
                if (clonedNode.isRoot() || clonedNode.subtreeContainsCloneOf(target)) continue;
                switch (operation) {
                    case CLONE: {
                        try {
                            NodeModel clone = asSingleNodes ? clonedNode.cloneContent() : clonedNode.cloneTree();
                            mapController.addNewNode(clone, target, target.getChildCount(), target.isNewChildLeft());
                        }
                        catch (CloneEncryptedNodeException e) {
                            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_clone_encrypted_node"));
                        }
                        break;
                    }
                    case MOVE: {
                        movedNodes.add(clonedNode);
                    }
                }
            }
            switch (operation) {
                case MOVE: {
                    mapController.moveNodesAsChildren(movedNodes, target, target.isNewChildLeft(), true);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    private static enum Operation {
        CLONE,
        MOVE;

    }

    private class ImageFlavorHandler
    implements IDataFlavorHandler {
        private final Image image;

        public ImageFlavorHandler(Image img) {
            this.image = img;
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            ModeController modeController = Controller.getCurrentModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            File mindmapFile = target.getMap().getFile();
            if (mindmapFile == null) {
                UITools.errorMessage((Object)TextUtils.getRawText((String)"map_not_saved"));
                return;
            }
            String mmFileName = mindmapFile.getName();
            String fileNameTemplate = mmFileName.substring(0, mmFileName.lastIndexOf(46)) + "_";
            while (fileNameTemplate.length() < 3) {
                fileNameTemplate = fileNameTemplate + '_';
            }
            try {
                File dir = mindmapFile.getParentFile();
                File file = File.createTempFile(fileNameTemplate, ".png", dir);
                String imgfilepath = file.getAbsolutePath();
                File tempFile = file = new File(imgfilepath);
                JFileChooser fileChooser = new JFileChooser(file);
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("png");
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setFileFilter((FileFilter)filter);
                fileChooser.setSelectedFile(file);
                int returnVal = fileChooser.showSaveDialog(UITools.getCurrentRootComponent());
                if (returnVal != 0) {
                    tempFile.delete();
                    return;
                }
                file = fileChooser.getSelectedFile();
                if (tempFile.exists() && !file.getAbsoluteFile().equals(tempFile)) {
                    tempFile.delete();
                }
                if (file.isDirectory()) {
                    return;
                }
                if (!FileUtils.getExtension((String)file.getName()).equals("png")) {
                    file = new File(file.getPath() + '.' + "png");
                }
                NodeModel node = mapController.newNode(file.getName(), target.getMap());
                mapController.insertNode(node, target, asSibling, isLeft, isLeft);
                new ImageAdder(this.image, mapController, mindmapFile, file).attachImageToNode(node);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class TextFragment {
        int depth;
        String link;
        String text;

        public TextFragment(String text, String link, int depth) {
            this.text = text;
            this.depth = depth;
            this.link = link;
        }
    }

    private class StructuredHtmlFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public StructuredHtmlFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        private String addFragment(HTMLDocument doc, Element element, int depth, int start, int end, LinkedList<TextFragment> htmlFragments) throws BadLocationException, IOException {
            String paragraphText = doc.getText(start, end - start).trim();
            if (paragraphText.length() > 0) {
                StringWriter out = new StringWriter();
                new PasteHtmlWriter(out, element, doc, start, end - start).write();
                String string = out.toString();
                if (!string.equals("")) {
                    String link = LinkController.findLink((String)string);
                    TextFragment htmlFragment = new TextFragment(string, link, depth);
                    htmlFragments.add(htmlFragment);
                }
            }
            return paragraphText;
        }

        private Element getParentElement(HTMLDocument doc) {
            Element bodyElement;
            Element htmlRoot = doc.getDefaultRootElement();
            Element parentCandidate = bodyElement = htmlRoot.getElement(htmlRoot.getElementCount() - 1);
            do {
                if (parentCandidate.getElementCount() <= 1) continue;
                return parentCandidate;
            } while (!(parentCandidate = parentCandidate.getElement(0)).isLeaf() && !parentCandidate.getName().equalsIgnoreCase("p-implied"));
            return bodyElement;
        }

        private boolean isSeparateElement(Element current) {
            return !current.isLeaf();
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            this.pasteHtmlWithoutRedisplay(this.textFromClipboard, target, asSibling, isLeft);
        }

        private void pasteHtmlWithoutRedisplay(Object t, NodeModel parent, boolean asSibling, boolean isLeft) {
            String textFromClipboard = (String)t;
            textFromClipboard = MClipboardController.this.cleanHtml(textFromClipboard);
            TextFragment[] htmlFragments = this.split(textFromClipboard);
            MClipboardController.this.pasteStringWithoutRedisplay(htmlFragments, parent, asSibling, isLeft);
        }

        private void split(HTMLDocument doc, Element parent, LinkedList<TextFragment> htmlFragments, int depth) throws BadLocationException, IOException {
            int elementCount = parent.getElementCount();
            int headerDepth = 0;
            boolean headerFound = false;
            int start = -1;
            int end = -1;
            Element last = null;
            for (int i = 0; i < elementCount; ++i) {
                boolean separateElement;
                Element current = parent.getElement(i);
                String name = current.getName();
                Matcher matcher = HEADER_REGEX.matcher(name);
                if (matcher.matches()) {
                    try {
                        if (!headerFound) {
                            --depth;
                        }
                        int newHeaderDepth = Integer.parseInt(matcher.group(1));
                        depth += newHeaderDepth - headerDepth;
                        headerDepth = newHeaderDepth;
                        headerFound = true;
                    }
                    catch (NumberFormatException e) {
                        LogUtils.severe((Throwable)e);
                    }
                } else if (headerFound) {
                    headerFound = false;
                    ++depth;
                }
                if ((separateElement = this.isSeparateElement(current)) && current.getElementCount() != 0) {
                    start = -1;
                    last = null;
                    this.split(doc, current, htmlFragments, depth + 1);
                    continue;
                }
                if (separateElement && start != -1) {
                    this.addFragment(doc, last, depth, start, end, htmlFragments);
                }
                if (start == -1 || separateElement) {
                    start = current.getStartOffset();
                    last = current;
                }
                end = current.getEndOffset();
                if (!separateElement) continue;
                this.addFragment(doc, current, depth, start, end, htmlFragments);
            }
            if (start != -1) {
                this.addFragment(doc, last, depth, start, end, htmlFragments);
            }
        }

        private TextFragment[] split(String text) {
            LinkedList<TextFragment> htmlFragments = new LinkedList<TextFragment>();
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                kit.read(buf, (Document)doc, 0);
                Element parent = this.getParentElement(doc);
                this.split(doc, parent, htmlFragments, 0);
            }
            catch (IOException e) {
                LogUtils.severe((Throwable)e);
            }
            catch (BadLocationException e) {
                LogUtils.severe((Throwable)e);
            }
            return htmlFragments.toArray(new TextFragment[htmlFragments.size()]);
        }
    }

    private class StringFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public StringFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            TextFragment[] textFragments = this.split(this.textFromClipboard);
            MClipboardController.this.pasteStringWithoutRedisplay(textFragments, target, asSibling, isLeft);
        }

        private TextFragment[] split(String textFromClipboard) {
            LinkedList<TextFragment> textFragments = new LinkedList<TextFragment>();
            String[] textLines = textFromClipboard.split("\n");
            for (int i = 0; i < textLines.length; ++i) {
                int depth;
                String text = textLines[i];
                if ((text = text.replaceAll("\t", "        ")).matches(" *")) continue;
                for (depth = 0; depth < text.length() && text.charAt(depth) == ' '; ++depth) {
                }
                String visibleText = text.trim();
                String link = LinkController.findLink((String)text);
                if (visibleText.equals("")) continue;
                textFragments.add(new TextFragment(visibleText, link, depth));
            }
            return textFragments.toArray(new TextFragment[textFragments.size()]);
        }
    }

    private static class PasteHtmlWriter
    extends FixedHTMLWriter {
        private final Element element;

        public PasteHtmlWriter(Writer writer, Element element, HTMLDocument doc, int pos, int len) {
            super(writer, doc, pos, len);
            this.element = this.getStandAloneElement(element);
        }

        protected ElementIterator getElementIterator() {
            return new ElementIterator(this.element);
        }

        private Element getStandAloneElement(Element element) {
            String name = element.getName();
            if (name.equals("ul") || name.equals("ol") || name.equals("table") || name.equals("html")) {
                return element;
            }
            return this.getStandAloneElement(element.getParentElement());
        }

        public void write() throws IOException, BadLocationException {
            if (this.element.getName().equals("html")) {
                super.write();
                return;
            }
            this.write("<html>");
            super.write();
            this.write("</html>");
        }
    }

    private class MindMapNodesFlavorHandler
    implements IDataFlavorHandler {
        private final String textFromClipboard;

        public MindMapNodesFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            if (this.textFromClipboard != null) {
                this.paste(this.textFromClipboard, target, asSibling, isLeft);
            }
        }

        private void paste(String text, NodeModel target, boolean asSibling, boolean isLeft) {
            String[] textLines = text.split("<nodeseparator>");
            MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
            MapReader mapReader = mapController.getMapReader();
            MapReader.NodeTreeCreator nodeTreeCreator = mapReader.nodeTreeCreator(target.getMap());
            nodeTreeCreator.setHint((Object)MapWriter.Hint.MODE, (Object)MapWriter.Mode.CLIPBOARD);
            for (int i = 0; i < textLines.length; ++i) {
                try {
                    NodeModel newModel = nodeTreeCreator.create((Reader)new StringReader(textLines[i]));
                    newModel.removeExtension(FreeNode.class);
                    boolean wasLeft = newModel.isLeft();
                    mapController.insertNode(newModel, target, asSibling, isLeft, wasLeft != isLeft);
                    continue;
                }
                catch (XMLException e) {
                    LogUtils.severe((String)"error on paste", (Throwable)e);
                }
            }
            nodeTreeCreator.finish(target);
        }
    }

    static interface IDataFlavorHandler {
        public void paste(Transferable var1, NodeModel var2, boolean var3, boolean var4, int var5);
    }

    private class FileListFlavorHandler
    implements IDataFlavorHandler {
        final List<File> fileList;

        public FileListFlavorHandler(List<File> fileList) {
            this.fileList = fileList;
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            boolean pasteImages = dropAction == 1;
            ViewerController viewerController = (ViewerController)Controller.getCurrentModeController().getExtension(ViewerController.class);
            for (File file : this.fileList) {
                if (pasteImages && viewerController.paste(file, target, ViewerController.PasteMode.valueOf((boolean)asSibling), isLeft)) continue;
                MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
                NodeModel node = mapController.newNode(file.getName(), target.getMap());
                ((MLinkController)LinkController.getController()).setLinkTypeDependantLink(node, file);
                mapController.insertNode(node, target, asSibling, isLeft, isLeft);
            }
        }
    }

    private class DirectHtmlFlavorHandler
    implements IDataFlavorHandler {
        private String textFromClipboard;

        public DirectHtmlFlavorHandler(String textFromClipboard) {
            this.textFromClipboard = textFromClipboard;
        }

        void paste(NodeModel target) {
            String body;
            this.textFromClipboard = MClipboardController.this.cleanHtml(this.textFromClipboard);
            NodeModel node = Controller.getCurrentModeController().getMapController().newNode((Object)this.textFromClipboard, Controller.getCurrentController().getMap());
            String text = this.textFromClipboard;
            Matcher m = HREF_PATTERN.matcher(text);
            if (m.matches() && !(body = m.group(2)).matches(".*<\\s*a.*")) {
                String href = m.group(1);
                ((MLinkController)LinkController.getController()).setLinkTypeDependantLink(node, href);
            }
            ((MMapController)Controller.getCurrentModeController().getMapController()).insertNode(node, target);
        }

        @Override
        public void paste(Transferable t, NodeModel target, boolean asSibling, boolean isLeft, int dropAction) {
            this.paste(target);
        }
    }
}

