/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt.mindmapmode;

import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.encrypt.EncryptionController;
import org.freeplane.features.encrypt.PasswordStrategy;
import org.freeplane.features.encrypt.mindmapmode.EncryptedMap;
import org.freeplane.features.encrypt.mindmapmode.RemoveEncryption;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class MEncryptionController
extends EncryptionController {
    public MEncryptionController(ModeController modeController) {
        super(modeController);
    }

    public static void install(MEncryptionController encryptionController) {
        EncryptionController.install((EncryptionController)encryptionController);
        ModeController modeController = Controller.getCurrentModeController();
        RemoveEncryption removeEncryptionAction = new RemoveEncryption(encryptionController);
        modeController.addAction((AFreeplaneAction)removeEncryptionAction);
        EncryptedMap encryptedMapAction = new EncryptedMap();
        modeController.addAction((AFreeplaneAction)encryptedMapAction);
    }

    public void removeEncryption(final NodeModel node, PasswordStrategy passwordStrategy) {
        final EncryptionModel encryptedMindMapNode = EncryptionModel.getModel((NodeModel)node);
        if (encryptedMindMapNode == null) {
            return;
        }
        if (!encryptedMindMapNode.isAccessible()) {
            this.toggleCryptState(node, passwordStrategy);
        }
        if (!encryptedMindMapNode.isAccessible()) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                node.removeExtension((IExtension)encryptedMindMapNode);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "removeEncryption";
            }

            public void undo() {
                node.addExtension((IExtension)encryptedMindMapNode);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }
}

