/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.XsltPipeReaderFactory;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class XmlImporter {
    private final String xsltResource;

    public XmlImporter(String xsltResource) {
        this.xsltResource = xsltResource;
    }

    public void importXml(File file) throws XMLParseException, MalformedURLException, IOException, URISyntaxException, XMLException {
        File directory = file.getParentFile();
        File outputFile = new File(directory, file.getName() + ".mm");
        this.importXml(file, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importXml(File inputFile, File outputFile) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException, XMLException, MalformedURLException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inputFile);
            this.importXml(in, outputFile);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        FileUtils.silentlyClose((Closeable[])new Closeable[]{in});
    }

    public void importXml(InputStream in, File outputFile) throws IOException, FileNotFoundException, XMLParseException, URISyntaxException, XMLException, MalformedURLException {
        URL mapUrl = Compat.fileToUrl((File)outputFile);
        if (outputFile.exists()) {
            if (Controller.getCurrentController().getMapViewManager().tryToChangeToMapView(mapUrl)) {
                return;
            }
            int overwriteMap = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText((String)"map_already_exists"), "Freeplane", 0);
            if (overwriteMap != 0) {
                return;
            }
        }
        this.newMap(in, outputFile);
    }

    private void newMap(InputStream in, File outputFile) throws IOException, XMLException, MalformedURLException {
        Reader reader = new XsltPipeReaderFactory(this.xsltResource).getReader(in);
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        MMapModel map = new MMapModel();
        modeController.getMapController().getMapReader().createNodeTreeFromXml((MapModel)map, reader, MapWriter.Mode.FILE);
        URL mapUrl = Compat.fileToUrl((File)outputFile);
        map.setURL(mapUrl);
        map.setSaved(false);
        mapController.fireMapCreated((MapModel)map);
        mapController.newMapView((MapModel)map);
    }
}

