/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class XsltExportEngine
implements IExportEngine {
    private final File xsltFile;

    public XsltExportEngine(File xsltFile) {
        this.xsltFile = xsltFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.xsltFile == null ? 0 : this.xsltFile.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XsltExportEngine other = (XsltExportEngine)obj;
        return !(this.xsltFile == null ? other.xsltFile != null : !this.xsltFile.getName().equals(other.xsltFile.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(MapModel map, File toFile) {
        StreamSource xsltSource = new StreamSource(this.xsltFile);
        StreamSource xmlSource = this.getMapXml(map);
        FileOutputStream outputStream = null;
        XsltExportPolicy xsltExportPolicy = new XsltExportPolicy();
        try {
            Policy.setPolicy(xsltExportPolicy);
            outputStream = new FileOutputStream(toFile);
            StreamResult result = new StreamResult(outputStream);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            UITools.errorMessage((Object)TextUtils.getText((String)"export_failed"));
            LogUtils.warn((Throwable)e);
        }
        finally {
            xsltExportPolicy.remove();
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                LogUtils.severe((Throwable)e);
            }
        }
    }

    private StreamSource getMapXml(MapModel map) {
        StringWriter writer = new StringWriter();
        ModeController modeController = Controller.getCurrentModeController();
        try {
            modeController.getMapController().getFilteredXml(map, (Writer)writer, MapWriter.Mode.EXPORT, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringReader stringReader = new StringReader(writer.getBuffer().toString());
        return new StreamSource(stringReader);
    }

    static class XsltExportPolicy
    extends Policy {
        static FilePermission allFileReadPermission = new FilePermission("<<ALL FILES>>", "read,readlink");
        final Policy alternativePolicy;

        public XsltExportPolicy() {
            this(Policy.getPolicy());
        }

        public XsltExportPolicy(Policy alternativePolicy) {
            this.alternativePolicy = alternativePolicy;
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            return this.alternativePolicy.implies(domain, permission) || allFileReadPermission.implies(permission);
        }

        public void remove() {
            if (Policy.getPolicy() != this) {
                throw new IllegalStateException();
            }
            Policy.setPolicy(this.alternativePolicy);
        }
    }
}

