/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.filemode;

import java.io.File;
import java.util.List;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

class FNodeModel
extends NodeModel {
    private final File file;

    public FNodeModel(File file, MapModel map) {
        super(map);
        this.file = file;
        String[] children = file.list();
        this.setFolded(children != null && children.length > 0);
    }

    public List<NodeModel> getChildren() {
        if (!this.getChildrenInternal().isEmpty()) {
            return super.getChildren();
        }
        try {
            String[] files = this.file.list();
            if (files != null) {
                String path = this.file.getPath();
                for (int i = 0; i < files.length; ++i) {
                    File childFile = new File(path, files[i]);
                    if (childFile.isHidden()) continue;
                    FNodeModel fileNodeModel = new FNodeModel(childFile, this.getMap());
                    NodeLinks.createLinkExtension((NodeModel)fileNodeModel).setHyperLink(childFile.toURI());
                    fileNodeModel.setLeft(this.isNewChildLeft());
                    this.getChildrenInternal().add(this.getChildCount(), fileNodeModel);
                    fileNodeModel.setParent(this);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return super.getChildren();
    }

    public File getFile() {
        return this.file;
    }

    public Object getUserObject() {
        String name = this.file.getName();
        if (name.equals("")) {
            name = "Root";
        }
        return name;
    }

    public boolean hasChildren() {
        return !this.file.isFile() && !this.getChildren().isEmpty();
    }

    public boolean isLeaf() {
        return this.file.isFile();
    }

    public String toString() {
        return this.getText();
    }
}

