/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.util.regex.Pattern;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;

class NoteDialogStarter {
    private static final Pattern HTML_HEAD = Pattern.compile("\\s*<head>.*</head>", 32);
    private EditNodeBase mCurrentEditDialog = null;

    NoteDialogStarter() {
    }

    void editNoteInDialog(final NodeModel nodeModel) {
        Controller controller = Controller.getCurrentController();
        this.stopEditing();
        Controller.getCurrentModeController().setBlocked(true);
        String text = NoteModel.getNoteText((NodeModel)nodeModel);
        if (text == null) {
            text = "";
        }
        EditNodeBase.IEditControl editControl = new EditNodeBase.IEditControl(){

            @Override
            public void cancel() {
                Controller.getCurrentModeController().setBlocked(false);
                NoteDialogStarter.this.mCurrentEditDialog = null;
            }

            @Override
            public void ok(String newText) {
                NoteDialogStarter.this.setHtmlText(nodeModel, newText);
                this.cancel();
            }

            @Override
            public void split(String newText, int position) {
            }

            @Override
            public boolean canSplit() {
                return false;
            }

            @Override
            public EditNodeBase.EditedComponent getEditType() {
                return EditNodeBase.EditedComponent.NOTE;
            }
        };
        IEditBaseCreator textFieldCreator = (IEditBaseCreator)Controller.getCurrentController().getMapViewManager();
        this.mCurrentEditDialog = textFieldCreator.createEditor(nodeModel, editControl, text, true);
        RootPaneContainer frame = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(controller.getMapViewManager().getMapViewComponent()));
        this.mCurrentEditDialog.show(frame);
    }

    private void setHtmlText(NodeModel node, String newText) {
        String body = HTML_HEAD.matcher(newText).replaceFirst("");
        MNoteController noteController = (MNoteController)MNoteController.getController();
        String trimmed = body.replaceFirst("\\s+$", "");
        if (HtmlUtils.isEmpty((String)trimmed)) {
            noteController.setNoteText(node, null);
        } else {
            noteController.setNoteText(node, trimmed);
        }
    }

    private void stopEditing() {
        if (this.mCurrentEditDialog != null) {
            this.mCurrentEditDialog.closeEdit();
            this.mCurrentEditDialog = null;
        }
    }
}

