/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.mindmapmode.AManageConditionalStylesAction;

public class ManageNodeConditionalStylesAction
extends AManageConditionalStylesAction {
    public static final String NAME = "ManageNodeConditionalStylesAction";
    private static final long serialVersionUID = 1L;

    public ManageNodeConditionalStylesAction() {
        super(NAME);
    }

    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        ConditionalStyleModel conditionalStyleModel = this.getConditionalStyleModel();
        Component pane = this.createConditionalStylePane(map, conditionalStyleModel);
        ModeController modeController = Controller.getCurrentModeController();
        modeController.startTransaction();
        try {
            int confirmed = JOptionPane.showConfirmDialog(controller.getMapViewManager().getMapViewComponent(), pane, TextUtils.getText((String)TextUtils.removeMnemonic((String)"ManageNodeConditionalStylesAction.text")), 2, -1);
            if (0 == confirmed) {
                modeController.commit();
                IMapSelection selection = controller.getSelection();
                NodeModel selected = selection.getSelected();
                modeController.getMapController().nodeChanged(selected, NodeModel.UNKNOWN_PROPERTY, null, null);
                for (NodeModel otherSelectedNode : selection.getSelection()) {
                    if (selected == otherSelectedNode) continue;
                    otherSelectedNode.putExtension((IExtension)conditionalStyleModel.clone());
                    modeController.getMapController().nodeChanged(otherSelectedNode, NodeModel.UNKNOWN_PROPERTY, null, null);
                }
            } else {
                modeController.rollback();
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            modeController.rollback();
        }
    }

    @Override
    public ConditionalStyleModel getConditionalStyleModel() {
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        ConditionalStyleModel conditionalStyleModel = (ConditionalStyleModel)node.getExtension(ConditionalStyleModel.class);
        if (conditionalStyleModel == null) {
            conditionalStyleModel = new ConditionalStyleModel();
            node.addExtension((IExtension)conditionalStyleModel);
        }
        return conditionalStyleModel;
    }
}

