/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class EventBuffer
implements KeyEventDispatcher,
FocusListener {
    ArrayList<KeyEvent> events = new ArrayList(100);
    private Component textComponent;
    boolean isActive = false;
    private InputEvent firstEvent;
    private KeyEvent dispatchedEvent = null;

    public boolean isActive() {
        return this.isActive;
    }

    EventBuffer() {
    }

    public Component getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(Component c) {
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this);
        }
        this.textComponent = c;
        if (this.textComponent != null) {
            this.textComponent.addFocusListener(this);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ke) {
        if (ke.equals(this.dispatchedEvent)) {
            return false;
        }
        if (this.textComponent != null) {
            KeyEvent newEvent = new KeyEvent(this.textComponent, ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            this.events.add(newEvent);
        } else {
            this.events.add(ke);
        }
        if (ke.getKeyCode() == 27 && ke.getID() == 402) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(EventBuffer.this);
                }
            });
        }
        ke.consume();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent e) {
        try {
            this.textComponent.removeFocusListener(this);
            for (int i = 0; i < this.events.size(); ++i) {
                KeyEvent ke = this.events.get(i);
                this.dispatchedEvent = ke.getComponent().equals(this.textComponent) ? ke : new KeyEvent(this.textComponent, ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
                e.getComponent().dispatchEvent(this.dispatchedEvent);
                this.dispatchedEvent = null;
            }
        }
        finally {
            this.deactivate();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.isActive = true;
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.isActive = false;
        if (this.textComponent != null) {
            this.textComponent.removeFocusListener(this);
        }
        this.textComponent = null;
        this.events.clear();
        this.firstEvent = null;
        this.dispatchedEvent = null;
    }

    public void activate(InputEvent e) {
        this.activate();
        if (e instanceof KeyEvent) {
            this.dispatchKeyEvent((KeyEvent)e);
        } else if (e instanceof MouseEvent) {
            this.setFirstEvent(e);
        }
    }

    public void setFirstEvent(InputEvent e) {
        this.firstEvent = e;
    }

    public KeyEvent getFirstEvent() {
        if (this.firstEvent instanceof KeyEvent) {
            return (KeyEvent)this.firstEvent;
        }
        if (this.events.size() == 0) {
            return null;
        }
        return this.events.get(0);
    }

    public MouseEvent getMouseEvent() {
        if (this.firstEvent instanceof MouseEvent) {
            return (MouseEvent)this.firstEvent;
        }
        return null;
    }
}

