/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.channels.FileLock;
import java.util.Timer;
import java.util.TimerTask;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.SysUtils;

public class LockManager
extends TimerTask {
    static final String LOCK_EXPIRATION_TIME = "lock_expiration_time_in_minutes";
    private File lockedSemaphoreFile = null;
    private String lockingUserOfOldLock = null;
    private final long lockSafetyPeriod = ResourceController.getResourceController().getIntProperty("lock_expiration_time_in_minutes") * 60 * 1000;
    private Timer lockTimer = null;
    private final long lockUpdatePeriod = Math.round((double)this.lockSafetyPeriod * 0.8);

    private File getSemaphoreFile(File mapFile) {
        return new File(mapFile.getParent() + System.getProperty("file.separator") + "$~" + mapFile.getName() + "~");
    }

    public synchronized String popLockingUserOfOldLock() {
        String toReturn = this.lockingUserOfOldLock;
        this.lockingUserOfOldLock = null;
        return toReturn;
    }

    public synchronized void releaseLock() {
        if (this.lockedSemaphoreFile != null) {
            this.lockedSemaphoreFile.delete();
            this.lockedSemaphoreFile = null;
        }
    }

    public synchronized void releaseTimer() {
        if (this.lockTimer != null) {
            this.lockTimer.cancel();
            this.lockTimer = null;
        }
    }

    @Override
    public synchronized void run() {
        if (this.lockedSemaphoreFile == null) {
            LogUtils.severe((String)"unexpected: lockedSemaphoreFile is null upon lock update");
            return;
        }
        try {
            FileUtils.setHidden((File)this.lockedSemaphoreFile, (boolean)false, (boolean)true);
            this.writeSemaphoreFile(this.lockedSemaphoreFile);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String tryToLock(File file) throws Exception {
        File semaphoreFile;
        block11: {
            semaphoreFile = this.getSemaphoreFile(file);
            if (semaphoreFile.equals(this.lockedSemaphoreFile)) {
                return null;
            }
            try (BufferedReader semaphoreReader = null;){
                semaphoreReader = new BufferedReader(new FileReader(semaphoreFile));
                String lockingUser = semaphoreReader.readLine();
                String lockTime = semaphoreReader.readLine();
                if (this.isLockExpired(lockTime)) {
                    this.lockingUserOfOldLock = lockingUser;
                    semaphoreFile.delete();
                    break block11;
                }
                String string = lockingUser;
                return string;
            }
        }
        this.writeSemaphoreFile(semaphoreFile);
        if (this.lockTimer == null && this.lockUpdatePeriod > 0L) {
            this.lockTimer = SysUtils.createTimer((String)this.getClass().getSimpleName());
            this.lockTimer.schedule((TimerTask)this, this.lockUpdatePeriod, this.lockUpdatePeriod);
        }
        this.releaseLock();
        this.lockedSemaphoreFile = semaphoreFile;
        return null;
    }

    private boolean isLockExpired(String lockTimeString) {
        long lockTime = new Long(lockTimeString);
        long timeDifference = System.currentTimeMillis() - lockTime;
        return lockTimeString == null || this.lockSafetyPeriod > 0L && timeDifference > this.lockSafetyPeriod;
    }

    private void writeSemaphoreFile(File inSemaphoreFile) throws Exception {
        FileOutputStream semaphoreOutputStream;
        try {
            semaphoreOutputStream = new FileOutputStream(inSemaphoreFile);
        }
        catch (FileNotFoundException e) {
            if (this.lockTimer != null) {
                this.lockTimer.cancel();
            }
            return;
        }
        FileLock lock = null;
        try {
            lock = semaphoreOutputStream.getChannel().tryLock();
            if (lock == null) {
                semaphoreOutputStream.close();
                LogUtils.severe((String)"Locking failed.");
                throw new Exception();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        semaphoreOutputStream.write(System.getProperty("user.name").getBytes());
        semaphoreOutputStream.write(10);
        semaphoreOutputStream.write(String.valueOf(System.currentTimeMillis()).getBytes());
        FileUtils.setHidden((File)inSemaphoreFile, (boolean)true, (boolean)false);
        if (lock != null) {
            lock.release();
        }
        semaphoreOutputStream.close();
        semaphoreOutputStream = null;
    }
}

