/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.freeplane.core.util.FileUtils;
import org.freeplane.main.application.ApplicationResourceController;

public class UserPropertiesUpdater {
    private static final String ORG_FREEPLANE_OLD_USERFPDIR = "org.freeplane.old_userfpdir";

    void importOldProperties() {
        File userPreferencesFile = ApplicationResourceController.getUserPreferencesFile();
        if (userPreferencesFile.exists()) {
            return;
        }
        this.copyUserFilesFromPreviousVersionTo(userPreferencesFile.getParentFile());
        if (userPreferencesFile.exists()) {
            this.removeVersionSpecificProperties(userPreferencesFile);
            return;
        }
    }

    private void copyUserFilesFromPreviousVersionTo(File targetDirectory) {
        File parentDirectory = targetDirectory.getParentFile();
        String previousDirName = "1.3.x";
        String old_userfpdir = System.getProperty(ORG_FREEPLANE_OLD_USERFPDIR);
        File sourceDirectory = this.isDefined(old_userfpdir) ? new File(old_userfpdir, "1.3.x") : new File(parentDirectory, "1.3.x");
        if (sourceDirectory.exists() && !sourceDirectory.getAbsolutePath().equals(targetDirectory.getAbsolutePath())) {
            try {
                parentDirectory.mkdirs();
                org.apache.commons.io.FileUtils.copyDirectory((File)sourceDirectory, (File)targetDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    private boolean isDefined(String old_userfpdir) {
        return old_userfpdir != null;
    }

    private void removeVersionSpecificProperties(File userPreferencesFile) {
        try {
            Properties userProp = this.loadProperties(userPreferencesFile);
            for (String name : new String[]{"lastOpened_1.0.20", "openedNow_1.0.20", "openedNow_1.3.04", "browse_url_storage", "single_backup_directory_path", "standard_template"}) {
                userProp.remove(name);
            }
            this.saveProperties(userProp, userPreferencesFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadProperties(File userPreferencesFile) throws IOException {
        FileInputStream inputStream = null;
        Properties userProp = new Properties();
        try {
            inputStream = new FileInputStream(userPreferencesFile);
            userProp.load(inputStream);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        FileUtils.silentlyClose((Closeable[])new Closeable[]{inputStream});
        return userProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperties(Properties userProp, File userPreferencesFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(userPreferencesFile);
            userProp.store(outputStream, null);
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose((Closeable[])new Closeable[]{outputStream});
            throw throwable;
        }
        FileUtils.silentlyClose((Closeable[])new Closeable[]{outputStream});
    }
}

