/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.mindmapmode.HttpVersionClient;

class UpdateCheckAction
extends AFreeplaneAction {
    private static boolean autorunEnabled = true;
    private static Timer autorunTimer = null;
    private static final int CHECK_TIME = 30000;
    private static final String CHECK_UPDATES_AUTOMATICALLY = "check_updates_automatically";
    private static final String LAST_UPDATE_CHECK_TIME = "last_update_check_time";
    private static final String LAST_UPDATE_VERSION = "last_update_verson";
    private static final long serialVersionUID = 1L;
    private static final int ONE_DAY = 86400000;
    private static final String UPDATE_BUTTON_LOCATION = "main_toolbar_update";
    private static final String WEB_UPDATE_LOCATION_KEY = "webUpdateLocation";
    protected Entry entry;
    private ActionListener openUrlListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Controller.getCurrentController().getViewController().openDocument(new URL(((JButton)e.getSource()).getActionCommand()));
            }
            catch (MalformedURLException ex) {
                UITools.errorMessage((Object)(TextUtils.getText((String)"url_error") + "\n" + ex));
            }
            catch (Exception ex) {
                UITools.errorMessage((Object)ex);
            }
        }
    };

    public UpdateCheckAction() {
        super("UpdateCheckAction");
        final Controller controller = Controller.getCurrentController();
        controller.getMapViewManager().addMapViewChangeListener(new IMapViewChangeListener(){

            public void afterViewChange(Component oldView, Component newView) {
                if (newView == null) {
                    return;
                }
                controller.getViewController().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removeMe();
                    }
                });
                UpdateCheckAction.this.setTimer();
            }

            public void afterViewClose(Component oldView) {
            }

            public void afterViewCreated(Component mapView) {
            }

            public void beforeViewChange(Component oldView, Component newView) {
            }

            private void removeMe() {
                controller.getMapViewManager().removeMapViewChangeListener((IMapViewChangeListener)this);
            }
        });
        controller.getModeController().addUiBuilder(PhaseProcessor.Phase.ACTIONS, UPDATE_BUTTON_LOCATION, new EntryVisitor(){

            public void visit(Entry target) {
                UpdateCheckAction.this.entry = target;
                new EntryAccessor().setAction(target, (AFreeplaneAction)UpdateCheckAction.this);
            }

            public boolean shouldSkipChildren(Entry entry) {
                return false;
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        final boolean autoRun = e.getSource().equals(autorunTimer);
        if (autorunTimer != null) {
            autorunTimer.stop();
            autorunTimer = null;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateCheckAction.this.checkForUpdates(autoRun);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }, "checkForUpdates").start();
    }

    private void addUpdateButton(FreeplaneVersion lastVersion) {
        if (this.entry != null) {
            Controller controller = Controller.getCurrentController();
            Component component = (Component)new EntryAccessor().getComponent(this.entry);
            if (component != null) {
                Dimension preferredSize = component.getPreferredSize();
                if (lastVersion == null || lastVersion.compareTo(FreeplaneVersion.getVersion()) <= 0) {
                    ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, "");
                    component.setPreferredSize(new Dimension(0, preferredSize.height));
                    component.setVisible(false);
                } else {
                    ResourceController.getResourceController().setProperty(LAST_UPDATE_VERSION, lastVersion.toString());
                    String updateAvailable = TextUtils.format((String)"new_version_available", (Object[])new Object[]{lastVersion.toString()});
                    controller.getViewController().out(updateAvailable);
                    this.putValue("ShortDescription", updateAvailable);
                    this.putValue("LongDescription", updateAvailable);
                    component.setPreferredSize(new Dimension(preferredSize.height, preferredSize.height));
                    component.setVisible(true);
                }
            }
        }
    }

    private void checkForUpdates(final boolean autoRun) {
        boolean connectSuccessfull;
        String history;
        FreeplaneVersion lastVersion;
        Date now = new Date();
        ResourceController.getResourceController().setProperty(LAST_UPDATE_CHECK_TIME, Long.toString(now.getTime()));
        Locale defaultLocale = Locale.getDefault();
        String language = defaultLocale.getLanguage();
        String DEFAULT_LANGUAGE = "en";
        String translatedWebUpdate = this.getWebUpdateUrl(language);
        final FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        HttpVersionClient translatedVersionClient = new HttpVersionClient(translatedWebUpdate, localVersion);
        FreeplaneVersion lastTranslatedVersion = translatedVersionClient.getRemoteVersion();
        if (lastTranslatedVersion == null) {
            lastTranslatedVersion = localVersion;
        }
        if (!language.equals("en")) {
            String defaultWebUpdate = this.getWebUpdateUrl("en");
            HttpVersionClient defaultVersionClient = new HttpVersionClient(defaultWebUpdate, lastTranslatedVersion);
            lastVersion = defaultVersionClient.getRemoteVersion();
            history = defaultVersionClient.getHistory() + translatedVersionClient.getHistory();
            connectSuccessfull = defaultVersionClient.isSuccessful();
        } else {
            lastVersion = lastTranslatedVersion;
            history = translatedVersionClient.getHistory();
            connectSuccessfull = translatedVersionClient.isSuccessful();
        }
        this.checkForAddonsUpdates();
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateCheckAction.this.addUpdateButton(lastVersion);
                if (autoRun) {
                    return;
                }
                UpdateCheckAction.this.showUpdateDialog(connectSuccessfull, localVersion, lastVersion, history);
            }
        });
    }

    private void checkForAddonsUpdates() {
        List installedAddOns = AddOnsController.getController().getInstalledAddOns();
        LogUtils.info((String)("checking for updates of " + installedAddOns.size() + " add-ons"));
        for (AddOnProperties addOnProperties : installedAddOns) {
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            URL updateUrl = addOnProperties.getUpdateUrl();
            if (updateUrl == null) continue;
            String addOnUpdateRequest = updateUrl + "?v=" + addOnLocalVersion.toString();
            HttpVersionClient versionClient = new HttpVersionClient(addOnUpdateRequest, addOnLocalVersion);
            FreeplaneVersion latestVersion = versionClient.getRemoteVersion();
            boolean connectSuccesfull = versionClient.isSuccessful();
            if (!connectSuccesfull) continue;
            addOnProperties.setLatestVersion(latestVersion.toString());
            if (versionClient.getRemoteVersionDownloadUrl() != null) {
                addOnProperties.setLatestVersionDownloadUrl(versionClient.getRemoteVersionDownloadUrl());
            }
            if (versionClient.getRemoteVersionChangelogUrl() == null) continue;
            addOnProperties.setLatestVersionChangelogUrl(versionClient.getRemoteVersionChangelogUrl());
        }
    }

    private String getWebUpdateUrl(String language) {
        String webUpdateUrl = ResourceController.getResourceController().getProperty(WEB_UPDATE_LOCATION_KEY);
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        StringBuilder sb = new StringBuilder(webUpdateUrl);
        String type = localVersion.getType();
        if (!type.equals("")) {
            sb.append(type);
            sb.append('/');
        }
        sb.append("history_");
        sb.append(language);
        sb.append(".txt");
        return sb.toString();
    }

    private FreeplaneVersion getKnownNewVersion() {
        FreeplaneVersion localVersion = FreeplaneVersion.getVersion();
        String property = ResourceController.getResourceController().getProperty(LAST_UPDATE_VERSION);
        if (property.equals("")) {
            return null;
        }
        FreeplaneVersion lastVersion = FreeplaneVersion.getVersion((String)property);
        if (lastVersion.compareTo(localVersion) <= 0) {
            lastVersion = null;
        }
        return lastVersion;
    }

    private void setTimer() {
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY);
        if (!autorunEnabled) {
            return;
        }
        autorunEnabled = false;
        Date now = new Date();
        long nextCheckMillis = ResourceController.getResourceController().getLongProperty(LAST_UPDATE_CHECK_TIME, 0) + 86400000L;
        Date nextCheckDate = new Date(nextCheckMillis);
        if (now.before(nextCheckDate)) {
            FreeplaneVersion knownNewVersion = this.getKnownNewVersion();
            this.addUpdateButton(knownNewVersion);
            return;
        }
        autorunTimer = new Timer(30000, (ActionListener)((Object)this));
        autorunTimer.setRepeats(false);
        autorunTimer.start();
    }

    private void showUpdateDialog(boolean connectSuccesfull, FreeplaneVersion localVersion, FreeplaneVersion newVersion, String history) {
        if (!connectSuccesfull) {
            this.showUpdateDialog("can_not_connect_to_info_server", newVersion, history);
        } else {
            this.showUpdateDialog("new_version_available", newVersion, history);
        }
    }

    private int showUpdateDialog(String info, FreeplaneVersion freeplaneLatestVersion, String history) {
        JLabel freeplaneLatestVersionLabel;
        Box messagePane = Box.createVerticalBox();
        JLabel emptyLabel = new JLabel("");
        JPanel gridPane = new JPanel(new GridBagLayout());
        gridPane.setAlignmentX(0.0f);
        Border paddingBorder = BorderFactory.createEmptyBorder(0, 10, 10, 0);
        gridPane.setBorder(BorderFactory.createCompoundBorder(paddingBorder, paddingBorder));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int gridRow = 0;
        c.weightx = 0.5;
        JLabel componentHeader = new JLabel(TextUtils.getText((String)"updater.component"), 0);
        JLabel installedVersionHeader = new JLabel(TextUtils.getText((String)"updater.version.installed"), 0);
        JLabel latestVersionHeader = new JLabel(TextUtils.getText((String)"updater.version.latest"), 0);
        Font boldFont = new Font(componentHeader.getFont().getName(), 1, componentHeader.getFont().getSize());
        componentHeader.setFont(boldFont);
        installedVersionHeader.setFont(boldFont);
        latestVersionHeader.setFont(boldFont);
        componentHeader.setBorder(paddingBorder);
        installedVersionHeader.setBorder(paddingBorder);
        latestVersionHeader.setBorder(paddingBorder);
        c.gridy = 0;
        c.gridx = 0;
        gridPane.add((Component)componentHeader, c);
        c.gridx = 1;
        gridPane.add((Component)installedVersionHeader, c);
        c.gridx = 2;
        gridPane.add((Component)latestVersionHeader, c);
        c.gridx = 3;
        gridPane.add((Component)emptyLabel, c);
        c.gridx = 4;
        gridPane.add((Component)emptyLabel, c);
        c.gridy = 1;
        JLabel freeplaneLabel = new JLabel("Freeplane");
        FreeplaneVersion freeplaneLocalVersion = FreeplaneVersion.getVersion();
        JLabel freeplaneInstalledVersionLabel = new JLabel(freeplaneLocalVersion.toString(), 0);
        Locale defaultLocale = Locale.getDefault();
        String language = defaultLocale.getLanguage();
        String translatedWebUpdate = this.getWebUpdateUrl(language);
        JButton changelogButton = new JButton(TextUtils.getText((String)"updater.viewChangelog"));
        changelogButton.addActionListener(this.openUrlListener);
        changelogButton.setActionCommand(translatedWebUpdate);
        JButton updateButton = new JButton(TextUtils.getText((String)"updater.goToDownload"));
        updateButton.addActionListener(this.openUrlListener);
        updateButton.setActionCommand("http://freeplane.sourceforge.net");
        Boolean needsUpdate = Boolean.FALSE;
        if (freeplaneLatestVersion != null) {
            needsUpdate = freeplaneLocalVersion.compareTo(freeplaneLatestVersion) < 0 ? Boolean.TRUE : Boolean.FALSE;
            freeplaneLatestVersionLabel = new JLabel(freeplaneLatestVersion.toString(), 0);
        } else {
            freeplaneLatestVersionLabel = new JLabel(TextUtils.getText((String)"updater.version.unknown"), 0);
            freeplaneLatestVersionLabel.setToolTipText(TextUtils.getText((String)info));
        }
        changelogButton.setEnabled(needsUpdate);
        updateButton.setEnabled(needsUpdate);
        c.gridx = 0;
        gridPane.add((Component)freeplaneLabel, c);
        c.gridx = 1;
        gridPane.add((Component)freeplaneInstalledVersionLabel, c);
        c.gridx = 2;
        gridPane.add((Component)freeplaneLatestVersionLabel, c);
        c.gridx = 3;
        gridPane.add((Component)changelogButton, c);
        c.gridx = 4;
        gridPane.add((Component)updateButton, c);
        List installedAddOns = AddOnsController.getController().getInstalledAddOns();
        gridRow = 3;
        for (AddOnProperties addOnProperties : installedAddOns) {
            JLabel addOnLatestVersionLabel;
            FreeplaneVersion addOnLocalVersion = this.toFreeplaneVersion(addOnProperties.getVersion());
            FreeplaneVersion addOnLatestVersion = this.toFreeplaneVersion(addOnProperties.getLatestVersion());
            JLabel addOnInstalledVersionLabel = new JLabel(addOnLocalVersion.toString(), 0);
            needsUpdate = Boolean.FALSE;
            if (addOnLatestVersion != null) {
                if (addOnLocalVersion.compareTo(addOnLatestVersion) < 0) {
                    needsUpdate = Boolean.TRUE;
                }
                addOnLatestVersionLabel = new JLabel(addOnLatestVersion.toString(), 0);
            } else {
                addOnLatestVersionLabel = new JLabel(TextUtils.getText((String)"updater.version.unknown"), 0);
                if (addOnProperties.getUpdateUrl() != null) {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText((String)"updater.version.unreachable") + " " + addOnProperties.getUpdateUrl());
                } else {
                    addOnLatestVersionLabel.setToolTipText(TextUtils.getText((String)"updater.version.noUpdateUrl"));
                }
            }
            JLabel addOnLabel = new JLabel(TextUtils.getText((String)("addons." + addOnProperties.getName())));
            c.gridx = 0;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLabel, c);
            c.gridx = 1;
            c.gridy = gridRow;
            gridPane.add((Component)addOnInstalledVersionLabel, c);
            c.gridx = 2;
            c.gridy = gridRow;
            gridPane.add((Component)addOnLatestVersionLabel, c);
            c.gridx = 3;
            c.gridy = gridRow;
            changelogButton = new JButton(TextUtils.getText((String)"updater.viewChangelog"));
            changelogButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionChangelogUrl() != null) {
                changelogButton.setActionCommand(addOnProperties.getLatestVersionChangelogUrl().toString());
            } else if (addOnProperties.getUpdateUrl() != null) {
                changelogButton.setActionCommand(String.valueOf(addOnProperties.getUpdateUrl()));
            }
            gridPane.add((Component)changelogButton, c);
            changelogButton.setEnabled(needsUpdate);
            c.gridx = 4;
            c.gridy = gridRow;
            updateButton = new JButton(TextUtils.getText((String)"updater.goToDownload"));
            updateButton.addActionListener(this.openUrlListener);
            if (addOnProperties.getLatestVersionDownloadUrl() != null) {
                updateButton.setActionCommand(addOnProperties.getLatestVersionDownloadUrl().toString());
            } else if (addOnProperties.getHomepage() != null) {
                updateButton.setActionCommand(addOnProperties.getHomepage().toString());
            }
            gridPane.add((Component)updateButton, c);
            updateButton.setEnabled(needsUpdate);
            ++gridRow;
        }
        messagePane.add(gridPane);
        JLabel confLabel = new JLabel(TextUtils.getText((String)"preferences"));
        confLabel.setFont(boldFont);
        messagePane.add(confLabel);
        JCheckBox updateAutomatically = new JCheckBox(TextUtils.getText((String)"OptionPanel.check_updates_automatically"), ResourceController.getResourceController().getBooleanProperty(CHECK_UPDATES_AUTOMATICALLY));
        updateAutomatically.setAlignmentX(0.0f);
        messagePane.add(updateAutomatically);
        Object[] options = new Object[]{TextUtils.getText((String)"simplyhtml.closeBtnName")};
        int choice = JOptionPane.showOptionDialog(UITools.getMenuComponent(), messagePane, TextUtils.getText((String)"updatecheckdialog"), -1, 1, null, options, options[0]);
        ResourceController.getResourceController().setProperty(CHECK_UPDATES_AUTOMATICALLY, Boolean.toString(updateAutomatically.isSelected()));
        return choice;
    }

    private FreeplaneVersion toFreeplaneVersion(String versionString) {
        try {
            return FreeplaneVersion.getVersion((String)versionString);
        }
        catch (Exception e) {
            return FreeplaneVersion.getVersion((String)"0.0.0");
        }
    }
}

