/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.DoubleClickTimer;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;

public class MNodeMotionListener
extends DefaultNodeMouseMotionListener
implements IMouseListener {
    private Point dragStartingPoint = null;
    private Quantity<LengthUnits> originalHGap;
    private Quantity<LengthUnits> originalAssignedParentVGap;
    private Quantity<LengthUnits> minimalDistanceBetweenChildren;
    private Quantity<LengthUnits> originalShiftY;
    private static final String EDIT_ON_DOUBLE_CLICK = "edit_on_double_click";

    Point getDragStartingPoint() {
        return this.dragStartingPoint;
    }

    private int getHGapChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int hGapChange = (int)((float)(dragNextPoint.x - this.dragStartingPoint.x) / mapView.getZoom());
        if (node.isLeft()) {
            hGapChange = -hGapChange;
        }
        return hGapChange;
    }

    private int getNodeShiftYChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int shiftYChange = (int)((float)(dragNextPoint.y - this.dragStartingPoint.y) / mapView.getZoom());
        return shiftYChange;
    }

    private NodeView getNodeView(MouseEvent e) {
        return ((MainView)e.getSource()).getNodeView();
    }

    private int getVGapChange(Point dragNextPoint, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int vGapChange = (int)((float)(dragNextPoint.y - this.dragStartingPoint.y) / mapView.getZoom());
        return vGapChange;
    }

    public boolean isDragActive() {
        return this.dragStartingPoint != null;
    }

    public void mouseClicked(MouseEvent e) {
        boolean shoudResetPosition;
        boolean bl = shoudResetPosition = e.getButton() == 1 && e.getClickCount() == 2 && this.doubleClickTimer.getDelay() > 0;
        if (shoudResetPosition) {
            MainView mainView = (MainView)e.getComponent();
            if (mainView.getMouseArea().equals((Object)MouseArea.MOTION)) {
                Controller controller = Controller.getCurrentController();
                MLocationController locationController = (MLocationController)LocationController.getController((ModeController)controller.getModeController());
                if (e.getModifiersEx() == 0) {
                    NodeView nodeV = this.getNodeView(e);
                    NodeModel node = nodeV.getModel();
                    locationController.moveNodePosition(node, (Quantity<LengthUnits>)LocationModel.DEFAULT_HGAP, (Quantity<LengthUnits>)LocationModel.DEFAULT_SHIFT_Y);
                    return;
                }
                if (Compat.isCtrlEvent((MouseEvent)e)) {
                    NodeView nodeV = this.getNodeView(e);
                    NodeModel childDistanceContainer = nodeV.getParentView().getChildDistanceContainer().getModel();
                    locationController.setMinimalDistanceBetweenChildren(childDistanceContainer, (Quantity<LengthUnits>)LocationModel.DEFAULT_VGAP);
                    return;
                }
            } else if (Compat.isPlainEvent((MouseEvent)e) && !this.isInFoldingRegion(e)) {
                MTextController textController = MTextController.getController();
                textController.getEventQueue().activate(e);
                textController.edit(IEditHandler.FirstAction.EDIT_CURRENT, false);
            }
        }
        super.mouseClicked(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isDragActive()) {
            return;
        }
        MainView v = (MainView)e.getSource();
        if (v.isInDragRegion(e.getPoint())) {
            v.setMouseArea(MouseArea.MOTION);
            v.setCursor(Cursor.getPredefinedCursor(13));
            return;
        }
        super.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isDragActive()) {
            super.mouseExited(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        MapView mapView = MapView.getMapView((Component)e.getComponent());
        mapView.select();
        this.doubleClickTimer.cancel();
        this.setClickDelay();
        if (this.isInDragRegion(e)) {
            if ((e.getModifiersEx() & 0x400) == 1024) {
                this.nodeSelector.stopTimerForDelayedSelection();
                NodeView nodeV = this.getNodeView(e);
                Point point = e.getPoint();
                UITools.convertPointToAncestor((Component)nodeV, (Point)point, JScrollPane.class);
                this.findGridPoint(point);
                NodeModel node = nodeV.getModel();
                this.dragStartingPoint = point;
                this.originalAssignedParentVGap = LocationModel.getModel((NodeModel)node.getParentNode()).getVGap();
                NodeModel childDistanceContainer = nodeV.getParentView().getChildDistanceContainer().getModel();
                this.minimalDistanceBetweenChildren = ((LocationController)mapView.getModeController().getExtension(LocationController.class)).getMinimalDistanceBetweenChildren(childDistanceContainer);
                this.originalHGap = LocationModel.getModel((NodeModel)node).getHGap();
                this.originalShiftY = LocationModel.getModel((NodeModel)node).getShiftY();
            }
        } else {
            super.mousePressed(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseDragged(MouseEvent e) {
        boolean shouldMoveSingleNode;
        if (!this.isDragActive()) {
            return;
        }
        if ((e.getModifiersEx() & 0x400) != 1024) return;
        final MainView mainView = (MainView)e.getSource();
        NodeView nodeV = this.getNodeView(e);
        final MapView mapView = nodeV.getMap();
        Point point = e.getPoint();
        UITools.convertPointToAncestor((Component)nodeV, (Point)point, JScrollPane.class);
        this.findGridPoint(point);
        ModeController c = Controller.getCurrentController().getModeController();
        Point dragNextPoint = point;
        boolean bl = shouldMoveSingleNode = !Compat.isCtrlEvent((MouseEvent)e);
        if (shouldMoveSingleNode) {
            int shiftYChange;
            NodeModel node = nodeV.getModel();
            LocationModel locationModel = LocationModel.createLocationModel((NodeModel)node);
            int hGapChange = this.getHGapChange(dragNextPoint, node);
            if (hGapChange != 0) {
                locationModel.setHGap(this.originalHGap.add((double)hGapChange, (Enum)LengthUnits.px));
            }
            if ((shiftYChange = this.getNodeShiftYChange(dragNextPoint, node)) != 0) {
                locationModel.setShiftY(this.originalShiftY.add((double)shiftYChange, (Enum)LengthUnits.px));
            }
            if (hGapChange == 0 && shiftYChange == 0) return;
            c.getMapController().nodeRefresh(node);
        } else {
            NodeModel childDistanceContainer = nodeV.getParentView().getChildDistanceContainer().getModel();
            int vGapChange = this.getVGapChange(dragNextPoint, childDistanceContainer);
            int newVGap = Math.max(0, this.minimalDistanceBetweenChildren.toBaseUnitsRounded() - vGapChange);
            LocationModel locationModel = LocationModel.createLocationModel((NodeModel)childDistanceContainer);
            if (locationModel.getVGap().toBaseUnitsRounded() == newVGap) {
                return;
            }
            locationModel.setVGap(new Quantity((double)newVGap, (Enum)LengthUnits.px).in((Enum)LengthUnits.pt));
            MapController mapController = c.getMapController();
            mapController.nodeRefresh(childDistanceContainer);
            mapController.nodeRefresh(nodeV.getModel());
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle r = mainView.getBounds();
                UITools.convertRectangleToAncestor((Component)mainView.getParent(), (Rectangle)r, (Component)mapView);
                boolean isEventPointVisible = mapView.getVisibleRect().contains(r);
                if (!isEventPointVisible) {
                    mapView.scrollRectToVisible(r);
                }
            }
        });
    }

    private void findGridPoint(Point point) {
        int gridSize = ResourceController.getResourceController().getLengthProperty("grid_size");
        if (gridSize <= 2) {
            return;
        }
        point.x -= point.x % gridSize;
        point.y -= point.y % gridSize;
    }

    public void mouseReleased(MouseEvent e) {
        MainView v = (MainView)e.getSource();
        if (!v.contains(e.getX(), e.getY())) {
            v.setMouseArea(MouseArea.OUT);
        }
        if (!this.isDragActive()) {
            super.mouseReleased(e);
            return;
        }
        NodeView nodeV = this.getNodeView(e);
        NodeModel node = nodeV.getModel();
        ModeController modeController = nodeV.getMap().getModeController();
        Controller controller = modeController.getController();
        MLocationController locationController = (MLocationController)LocationController.getController((ModeController)controller.getModeController());
        NodeView parentView = nodeV.getParentView();
        NodeView childDistanceContainerView = parentView.getChildDistanceContainer();
        NodeModel childDistanceContainer = childDistanceContainerView.getModel();
        Quantity parentVGap = locationController.getMinimalDistanceBetweenChildren(childDistanceContainer);
        Quantity hgap = LocationModel.getModel((NodeModel)node).getHGap();
        Quantity shiftY = LocationModel.getModel((NodeModel)node).getShiftY();
        this.adjustNodeIndices(nodeV);
        this.resetPositions(node);
        Quantity hGap = hgap;
        locationController.moveNodePosition(node, (Quantity<LengthUnits>)hGap, (Quantity<LengthUnits>)shiftY);
        locationController.setMinimalDistanceBetweenChildren(childDistanceContainer, (Quantity<LengthUnits>)parentVGap);
        this.stopDrag();
    }

    private void adjustNodeIndices(NodeView nodeV) {
        NodeModel[] selectedsBackup = null;
        NodeModel node = nodeV.getModel();
        if (FreeNode.isFreeNode((NodeModel)node)) {
            selectedsBackup = this.adjustNodeIndexBackupSelection(nodeV, selectedsBackup);
        } else {
            NodeModel[] siblingNodes;
            MapView map = nodeV.getMap();
            for (NodeModel sibling : siblingNodes = node.getParentNode().getChildren().toArray(new NodeModel[0])) {
                if (!FreeNode.isFreeNode((NodeModel)sibling)) continue;
                NodeView siblingV = map.getNodeView(sibling);
                selectedsBackup = this.adjustNodeIndexBackupSelection(siblingV, selectedsBackup);
            }
        }
        if (selectedsBackup != null) {
            ModeController modeController = nodeV.getMap().getModeController();
            Controller controller = modeController.getController();
            controller.getSelection().replaceSelection(selectedsBackup);
        }
    }

    private NodeModel[] adjustNodeIndexBackupSelection(NodeView nodeV, NodeModel[] selectedsBackup) {
        NodeModel node = nodeV.getModel();
        boolean isLeft = nodeV.isLeft();
        int newIndex = this.calculateNewFreeNodeIndex(nodeV);
        if (newIndex != -1) {
            ModeController modeController = nodeV.getMap().getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (selectedsBackup == null) {
                Collection selecteds = mapController.getSelectedNodes();
                selectedsBackup = selecteds.toArray(new NodeModel[selecteds.size()]);
            }
            mapController.moveNode(node, newIndex);
        }
        return selectedsBackup;
    }

    public int getRefX(NodeView node) {
        return node.getContent().getX() + node.getContent().getWidth() / 2;
    }

    private int calculateNewFreeNodeIndex(NodeView nodeV) {
        int result;
        NodeModel node = nodeV.getModel();
        if (SummaryNode.isHidden((NodeModel)node)) {
            return -1;
        }
        boolean left = nodeV.isLeft();
        int nodeY = this.getRefY(nodeV);
        NodeView parent = nodeV.getParentView();
        int newIndex = 0;
        int oldIndex = -1;
        int wrondSideCount = 0;
        int hiddenNodeCount = 0;
        int childCount = node.getParentNode().getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Component component = parent.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView siblingV = (NodeView)component;
            NodeModel sibling = siblingV.getModel();
            if (siblingV.isLeft() == left && !SummaryNode.isHidden((NodeModel)sibling) && this.getRefY(siblingV) > nodeY) break;
            if (siblingV != nodeV) {
                ++newIndex;
                if (siblingV.isLeft() != left) {
                    ++wrondSideCount;
                    continue;
                }
                wrondSideCount = 0;
                if (oldIndex >= 0 && SummaryNode.isHidden((NodeModel)sibling)) {
                    ++hiddenNodeCount;
                    continue;
                }
                hiddenNodeCount = 0;
                continue;
            }
            oldIndex = i;
        }
        if ((result = newIndex - wrondSideCount - hiddenNodeCount) == oldIndex) {
            return -1;
        }
        return result;
    }

    private int getRefY(NodeView sibling) {
        return sibling.getY() + sibling.getContent().getY();
    }

    private void resetPositions(NodeModel node) {
        LocationModel locationModel = LocationModel.getModel((NodeModel)node.getParentNode());
        locationModel.setVGap(this.originalAssignedParentVGap);
        LocationModel.getModel((NodeModel)node).setHGap(this.originalHGap);
        LocationModel.getModel((NodeModel)node).setShiftY(this.originalShiftY);
    }

    private void resetDragStartingPoint() {
        this.dragStartingPoint = null;
        this.minimalDistanceBetweenChildren = this.originalAssignedParentVGap = LocationModel.DEFAULT_VGAP;
        this.originalHGap = LocationModel.DEFAULT_HGAP;
        this.originalShiftY = LocationModel.DEFAULT_SHIFT_Y;
    }

    private void stopDrag() {
        this.resetDragStartingPoint();
    }

    private void setClickDelay() {
        if (ResourceController.getResourceController().getBooleanProperty(EDIT_ON_DOUBLE_CLICK)) {
            this.doubleClickTimer.setDelay(DoubleClickTimer.MAX_TIME_BETWEEN_CLICKS);
        } else {
            this.doubleClickTimer.setDelay(0);
        }
    }
}

