/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Random;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class ScanexTileSource
extends TMSTileSource {
    private static final String DEFAULT_URL = "http://maps.kosmosnimki.ru";
    private static final int DEFAULT_MAXZOOM = 14;
    private static final String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;
    private ScanexLayer layer = ScanexLayer.IRS;
    private double cachedLat;

    public ScanexTileSource(TileSourceInfo info) {
        super(info);
        String url = info.getUrl();
        for (ScanexLayer slayer : ScanexLayer.values()) {
            if (!url.equalsIgnoreCase(slayer.getName())) continue;
            this.layer = slayer;
            this.baseUrl = DEFAULT_URL;
            if (this.maxZoom != 0) break;
            this.maxZoom = 14;
            break;
        }
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTilePath(int zoom, int tilex, int tiley) {
        int tmp = (int)Math.pow(2.0, zoom - 1);
        tiley = tmp - tiley - 1;
        return this.layer.getUri() + "&apikey=" + API_KEY + "&x=" + (tilex -= tmp) + "&y=" + tiley + "&z=" + zoom;
    }

    private double tileYToLat(double y, int zoom) {
        double lat0;
        double lat = this.cachedLat;
        do {
            lat0 = lat;
            if (!((lat -= Math.toDegrees(ScanexTileSource.nextTerm(Math.toRadians(lat), y, zoom))) > 85.05112877980659) && !(lat < -85.05112877980659)) continue;
            Random r = new Random();
            lat = -85.05112877980659 + (double)r.nextInt(170);
        } while (Math.abs(lat0 - lat) > 1.0E-6);
        this.cachedLat = lat;
        return lat;
    }

    private static double nextTerm(double lat, double y, int zoom) {
        double sinl = Math.sin(lat);
        double cosl = Math.cos(lat);
        zoom = (int)Math.pow(2.0, zoom - 1);
        double ec = Math.exp((1.0 - y / (double)zoom) * Math.PI);
        double f = Math.tan(0.7853981633974483 + lat / 2.0) - ec * Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * sinl) / 2.0), E);
        double df = 1.0 / (1.0 - sinl) - ec * E * cosl / ((1.0 - E * sinl) * Math.sqrt(1.0 - E * E * sinl * sinl));
        return f / df;
    }

    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private String name;
        private String uri;

        private ScanexLayer(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

