/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoManifest
extends Manifest {
    FrameworkContext fwCtx;
    Manifest mf;
    String location;
    AutoInfo autoInfo;
    Attributes mainAttrs;
    Set<String> packages = new TreeSet<String>();
    static String configSource = null;
    static Map<String, AutoInfo> configs = null;
    private final Hashtable<String, String> fileProps = new Hashtable();
    static /* synthetic */ Class class$org$knopflerfish$framework$AutoManifest;

    public AutoManifest(FrameworkContext fwCtx, Manifest mf, String location) {
        if (mf == null) {
            throw new NullPointerException("Manifest cannot be null");
        }
        if (location == null) {
            throw new NullPointerException("location cannot be null");
        }
        this.fwCtx = fwCtx;
        this.mf = mf;
        this.location = location;
        if (configs == null) {
            if (fwCtx.props.getBooleanProperty("org.knopflerfish.framework.automanifest")) {
                configSource = fwCtx.props.getProperty("org.knopflerfish.framework.automanifest.config");
                configs = this.loadConfig(configSource);
                if (fwCtx.debug.automanifest) {
                    fwCtx.debug.println(((Object)new StringBuffer().append("Loaded auto manifest config from ").append(configSource)).toString());
                }
            } else {
                configs = new TreeMap<String, AutoInfo>();
            }
        }
        this.autoInfo = this.findConfig();
        if (this.isAuto() && fwCtx.debug.automanifest) {
            fwCtx.debug.println(((Object)new StringBuffer().append("Using auto manifest for bundlelocation ").append(location)).toString());
        }
    }

    public boolean isAuto() {
        return this.autoInfo != null;
    }

    @Override
    public void clear() {
        this.mf.clear();
        this.mainAttrs = null;
    }

    @Override
    public Attributes getAttributes(String name) {
        return this.mf.getAttributes(name);
    }

    @Override
    public Map<String, Attributes> getEntries() {
        return this.mf.getEntries();
    }

    @Override
    public void read(InputStream is) throws IOException {
        this.mf.read(is);
        this.mainAttrs = null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.mf.write(out);
    }

    public Manifest getManifest() {
        return this.mf;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AutoManifest)) {
            return false;
        }
        AutoManifest af = (AutoManifest)obj;
        return ((Object)this.mf).equals(af.mf) && this.location.equals(af.location);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mf).hashCode() + 17 * this.location.hashCode();
    }

    @Override
    public Attributes getMainAttributes() {
        if (this.mainAttrs == null) {
            this.mainAttrs = this.mf.getMainAttributes();
            if (this.autoInfo != null) {
                this.mainAttrs.putValue("Bundle-AutoManifest-config", configSource);
                for (String key : this.autoInfo.headers.keySet()) {
                    String val = this.autoInfo.headers.get(key);
                    if ("[remove]".equals(val)) {
                        this.mainAttrs.remove(new Attributes.Name(key));
                        continue;
                    }
                    if ("[autoexport]".equals(val)) {
                        String exports = this.getExports();
                        if (this.fwCtx.debug.automanifest) {
                            this.fwCtx.debug.println(((Object)new StringBuffer().append("Auto exports for ").append(this.location).append(": ").append(exports)).toString());
                        }
                        if (exports.length() > 0) {
                            this.mainAttrs.putValue("Export-Package", exports);
                            continue;
                        }
                        this.mainAttrs.remove(new Attributes.Name("Export-Package"));
                        continue;
                    }
                    this.mainAttrs.putValue(key, val);
                }
            }
        }
        return this.mainAttrs;
    }

    public void addFile(File file) throws IOException {
        this.addFile(file.getAbsolutePath(), file);
    }

    public void addFile(String prefix, File file) throws IOException {
        String f;
        String string = f = prefix.length() < file.getAbsolutePath().length() ? file.getAbsolutePath().substring(prefix.length() + 1) : file.getAbsolutePath();
        if (f.endsWith(".jar")) {
            this.addZipFile(new ZipFile(file));
        } else if (this.isValidFileName(f)) {
            this.addFileName(f);
        } else if (file.isDirectory()) {
            String[] files;
            for (String file2 : files = file.list()) {
                this.addFile(prefix, new File(file.getAbsolutePath(), file2));
            }
        }
    }

    private boolean isValidFileName(String f) {
        if (this.autoInfo != null && this.autoInfo.fileNameFilter != null) {
            this.fileProps.put("file", f);
            return this.autoInfo.fileNameFilter.evaluate(this.fileProps, true);
        }
        return f.endsWith(".class");
    }

    public void addZipFile(ZipFile jar) {
        Enumeration<? extends ZipEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String f = ze.getName();
            if (!this.isValidFileName(f)) continue;
            this.addFileName(f);
        }
    }

    public void addFileName(String f) {
        int ix = (f = f.replace('\\', '/')).lastIndexOf("/");
        if (ix != -1) {
            f = f.substring(0, ix);
        }
        f = f.replace('/', '.');
        if (this.autoInfo != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("pkg", f);
            if (this.autoInfo.exportFilter.evaluate(props, true) && !this.packages.contains(f)) {
                this.packages.add(f);
            }
        }
        this.mainAttrs = null;
    }

    String getExports() {
        StringBuffer sb = new StringBuffer();
        for (String pkg : this.packages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pkg);
            if (this.autoInfo.version == null) continue;
            sb.append(";");
            sb.append(this.autoInfo.version);
        }
        return ((Object)sb).toString();
    }

    private AutoInfo findConfig() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("location", this.location);
        Attributes attrs = this.mf.getMainAttributes();
        for (Object key : attrs.keySet()) {
            String val = attrs.getValue(key.toString());
            props.put(key.toString(), val.toString());
        }
        for (String id : configs.keySet()) {
            AutoInfo ai = configs.get(id);
            if (!ai.filter.evaluate(props, true)) continue;
            return ai;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AutoInfo> loadConfig(String urlS) {
        if (urlS != null && !"".equals(urlS)) {
            URL url = null;
            InputStream is = null;
            try {
                url = urlS.startsWith("!!") ? (class$org$knopflerfish$framework$AutoManifest == null ? (class$org$knopflerfish$framework$AutoManifest = AutoManifest.class$("org.knopflerfish.framework.AutoManifest")) : class$org$knopflerfish$framework$AutoManifest).getResource(urlS.substring(2)) : new URL(urlS);
                is = url.openStream();
                Map<String, AutoInfo> map = this.loadConfigFromInputStream(is);
                return map;
            }
            catch (Exception e) {
                this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Failed to load autoimportexport conf from ").append(url)).toString(), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignored) {}
            }
        }
        return new HashMap<String, AutoInfo>();
    }

    private Map<String, AutoInfo> loadConfigFromInputStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        TreeMap<String, AutoInfo> configMap = new TreeMap<String, AutoInfo>();
        for (Object object : props.keySet()) {
            String key = (String)object;
            int ix = key.indexOf(".");
            if (ix == -1) continue;
            String id = key.substring(0, ix);
            String pattern = (String)props.get(((Object)new StringBuffer().append(id).append(".match.filter")).toString());
            String export = (String)props.get(((Object)new StringBuffer().append(id).append(".export.filter")).toString());
            String fileFilter = (String)props.get(((Object)new StringBuffer().append(id).append(".export.file.filter")).toString());
            HashMap<String, String> headers = new HashMap<String, String>();
            if (fileFilter == null) {
                fileFilter = "(file=*.class)";
            }
            String headerPre = ((Object)new StringBuffer().append(id).append(".header.")).toString();
            for (Object object2 : props.keySet()) {
                String key2 = (String)object2;
                String val2 = (String)props.get(key2);
                if (!key2.startsWith(headerPre)) continue;
                headers.put(key2.substring(headerPre.length()), val2);
            }
            AutoInfo ai = new AutoInfo(pattern, export, fileFilter, headers);
            ai.version = (String)props.get(((Object)new StringBuffer().append(id).append(".export.version")).toString());
            configMap.put(id, ai);
        }
        return configMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AutoInfo {
        LDAPExpr filter;
        LDAPExpr exportFilter;
        LDAPExpr fileNameFilter;
        Map<String, String> headers;
        String version;

        AutoInfo(String filter, String export, String nameFilter, Map<String, String> headers) {
            try {
                this.filter = new LDAPExpr(filter);
            }
            catch (Exception e) {
                throw new RuntimeException(((Object)new StringBuffer().append("Bad filter '").append(filter).append("': ").append(e)).toString());
            }
            try {
                this.fileNameFilter = new LDAPExpr(nameFilter);
            }
            catch (Exception e) {
                throw new RuntimeException(((Object)new StringBuffer().append("Bad file name filter '").append(nameFilter).append("': ").append(e)).toString());
            }
            try {
                this.exportFilter = new LDAPExpr(export);
            }
            catch (Exception e) {
                throw new RuntimeException(((Object)new StringBuffer().append("Bad export filter '").append(export).append("': ").append(e)).toString());
            }
            this.headers = headers;
        }

        public String toString() {
            return ((Object)new StringBuffer().append("AutoInfo[filter=").append(this.filter).append(", exportFilter=").append(this.exportFilter).append(", version=").append(this.version).append(", headers=").append(this.headers).append("]")).toString();
        }
    }
}

