/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassPath {
    private final FrameworkContext fwCtx;
    private final ArrayList<FileArchive> archives = new ArrayList(4);
    private Map<String, FileArchive> nativeLibs;
    private final Debug debug;
    private final long bid;

    BundleClassPath(BundleArchive ba, List<BundleGeneration> frags, FrameworkContext fwCtx) throws BundleException {
        this.fwCtx = fwCtx;
        this.debug = fwCtx.debug;
        this.bid = ba.getBundleId();
        this.checkBundleArchive(ba, frags);
        if (frags != null) {
            for (BundleGeneration bundleGeneration : frags) {
                this.checkBundleArchive(bundleGeneration.archive, null);
            }
        }
        this.resolveNativeCode(ba, false);
        if (frags != null) {
            for (BundleGeneration bundleGeneration : frags) {
                this.resolveNativeCode(bundleGeneration.archive, true);
            }
        }
    }

    BundleClassPath(BundleArchive ba, FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
        this.debug = fwCtx.debug;
        this.bid = ba.getBundleId();
        this.checkBundleArchive(ba, null);
    }

    void attachFragment(BundleGeneration gen) throws BundleException {
        this.checkBundleArchive(gen.archive, null);
        this.resolveNativeCode(gen.archive, true);
    }

    Vector<FileArchive> componentExists(String component, boolean onlyFirst, boolean dirs) {
        Vector<FileArchive> v;
        block7: {
            block5: {
                block6: {
                    v = null;
                    if (component.startsWith("/")) {
                        component = component.substring(1);
                    }
                    if (this.debug.classLoader) {
                        this.debug.println(((Object)new StringBuffer().append(this).append("compentExists: ").append(component)).toString());
                    }
                    if (0 != component.length()) break block5;
                    if (!onlyFirst) break block6;
                    v = new Vector<FileArchive>(1);
                    v.addElement(this.archives.get(0));
                    if (!this.debug.classLoader) break block7;
                    this.debug.println(((Object)new StringBuffer().append(this).append("compentExists added first top in classpath.")).toString());
                    break block7;
                }
                v = new Vector<FileArchive>(this.archives);
                if (!this.debug.classLoader) break block7;
                this.debug.println(((Object)new StringBuffer().append(this).append("compentExists added all tops in classpath.")).toString());
                break block7;
            }
            for (FileArchive fa : this.archives) {
                if (!fa.exists(component, dirs)) continue;
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(fa);
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append(this).append("compentExists added: ").append(fa)).toString());
                }
                if (!onlyFirst) continue;
                break;
            }
        }
        return v;
    }

    InputStream getInputStream(String component, int ix) {
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        return this.archives.get(ix).getBundleResourceStream(component);
    }

    String getNativeLibrary(String libName) {
        if (this.debug.classLoader) {
            this.debug.println(((Object)new StringBuffer().append(this).append("getNativeLibrary: lib=").append(libName)).toString());
        }
        if (this.nativeLibs != null) {
            String[] keys = new String[]{System.mapLibraryName(libName), libName};
            FileArchive fa = null;
            String key = null;
            String[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String k;
                key = k = arr$[i$];
                if (this.debug.classLoader) {
                    this.debug.println(((Object)new StringBuffer().append(this).append("getNativeLibrary: try, ").append(key)).toString());
                }
                if ((fa = this.nativeLibs.get(key)) == null) {
                    String libExtensions = this.fwCtx.props.getProperty("org.osgi.framework.library.extensions");
                    int pos = key.lastIndexOf(".");
                    if (libExtensions.length() > 0 && pos > -1) {
                        String[] exts;
                        String baseKey = key.substring(0, pos + 1);
                        for (String ext : exts = Util.splitwords(libExtensions, ", \t")) {
                            key = ((Object)new StringBuffer().append(baseKey).append(ext)).toString();
                            if (this.debug.classLoader) {
                                this.debug.println(((Object)new StringBuffer().append(this).append("getNativeLibrary: try, ").append(key)).toString());
                            }
                            if ((fa = this.nativeLibs.get(key)) != null) break;
                        }
                    }
                }
                if (fa != null) break;
            }
            if (fa == null) {
                return null;
            }
            if (this.debug.classLoader) {
                this.debug.println(((Object)new StringBuffer().append(this).append("getNativeLibrary: got, ").append(fa)).toString());
            }
            return fa.getNativeLibrary(key);
        }
        return null;
    }

    public String toString() {
        return ((Object)new StringBuffer().append("BundleClassPath(#").append(this.bid).append(").")).toString();
    }

    private void checkBundleArchive(BundleArchive ba, List<BundleGeneration> frags) {
        String bcp = ba.getAttribute("Bundle-ClassPath");
        if (bcp != null) {
            StringTokenizer st = new StringTokenizer(bcp, ",");
            while (st.hasMoreTokens()) {
                String path = st.nextToken().trim();
                FileArchive a = ba.getFileArchive(path);
                if (a == null && frags != null) {
                    for (BundleGeneration bundleGeneration : frags) {
                        a = bundleGeneration.archive.getFileArchive(path);
                        if (a == null) continue;
                        break;
                    }
                }
                if (a != null) {
                    this.archives.add(a);
                    if (!this.debug.classLoader) continue;
                    this.debug.println(((Object)new StringBuffer().append(this).append("- Added path entry: ").append(a)).toString());
                    continue;
                }
                this.fwCtx.frameworkWarning(ba.getBundleGeneration().bundle, (Throwable)new IllegalArgumentException(((Object)new StringBuffer().append("Bundle-ClassPath entry ").append(path).append(" not found in bundle")).toString()), new FrameworkListener[0]);
                if (!this.debug.classLoader) continue;
                this.debug.println(((Object)new StringBuffer().append(this).append("- Failed to find class path entry: ").append(path)).toString());
            }
        } else {
            this.archives.add(ba.getFileArchive("."));
        }
    }

    private void resolveNativeCode(BundleArchive ba, boolean isFrag) throws BundleException {
        String bnc = ba.getAttribute("Bundle-NativeCode");
        if (bnc != null) {
            ArrayList<String> proc = new ArrayList<String>(3);
            String procP = this.fwCtx.props.getProperty("org.osgi.framework.processor").toLowerCase();
            proc.add(procP);
            String procS = System.getProperty("os.arch").toLowerCase();
            if (!procP.equals(procS)) {
                proc.add(procS);
            }
            if (procP.startsWith("arm_")) {
                proc.add("arm");
            }
            for (int i = 0; i < Alias.processorAliases.length; ++i) {
                if (!procP.equalsIgnoreCase(Alias.processorAliases[i][0])) continue;
                for (int j = 1; j < Alias.processorAliases[i].length; ++j) {
                    if (procS.equals(Alias.processorAliases[i][j])) continue;
                    proc.add(Alias.processorAliases[i][j]);
                }
                break;
            }
            ArrayList<String> os = new ArrayList<String>();
            String osP = this.fwCtx.props.getProperty("org.osgi.framework.os.name").toLowerCase();
            os.add(osP);
            String osS = System.getProperty("os.name").toLowerCase();
            if (!osS.equals(osP)) {
                os.add(osS);
            }
            for (int i = 0; i < Alias.osNameAliases.length; ++i) {
                if (!osP.equalsIgnoreCase(Alias.osNameAliases[i][0])) continue;
                for (int j = 1; j < Alias.osNameAliases[i].length; ++j) {
                    if (osS.equals(Alias.osNameAliases[i][j])) continue;
                    os.add(Alias.osNameAliases[i][j]);
                }
                break;
            }
            Version osVer = new Version(this.fwCtx.props.getProperty("org.osgi.framework.os.version"));
            String osLang = this.fwCtx.props.getProperty("org.osgi.framework.language");
            boolean optional = false;
            List<String> best = null;
            VersionRange bestVer = null;
            boolean bestLang = false;
            List<Util.HeaderEntry> hes = Util.parseManifestHeader("Bundle-NativeCode", bnc, false, false, false);
            Iterator<Util.HeaderEntry> heIt = hes.iterator();
            while (heIt.hasNext()) {
                List<String> keys;
                boolean matchLang;
                VersionRange matchVer;
                block31: {
                    List sf;
                    List lang;
                    List ol;
                    Util.HeaderEntry he = heIt.next();
                    matchVer = null;
                    matchLang = false;
                    keys = he.getKeys();
                    if (keys.size() == 1 && "*".equals(keys.get(0)) && !heIt.hasNext()) {
                        optional = true;
                        break;
                    }
                    List pl = (List)he.getAttributes().get("processor");
                    if (pl == null || !this.containsIgnoreCase(proc, pl) || (ol = (List)he.getAttributes().get("osname")) == null || !this.containsIgnoreCase(os, ol)) continue;
                    List ver = (List)he.getAttributes().get("osversion");
                    if (ver != null) {
                        boolean okVer = false;
                        for (String string : ver) {
                            matchVer = new VersionRange(string);
                            if (!matchVer.includes(osVer)) continue;
                            okVer = true;
                            break;
                        }
                        if (!okVer) continue;
                    }
                    if ((lang = (List)he.getAttributes().get("language")) != null) {
                        for (String string : lang) {
                            if (!osLang.equalsIgnoreCase(string)) continue;
                            matchLang = true;
                            break;
                        }
                        if (!matchLang) continue;
                    }
                    if ((sf = (List)he.getAttributes().get("selection-filter")) != null) {
                        String sfs = (String)sf.get(0);
                        if (sf.size() == 1) {
                            try {
                                if (!FrameworkUtil.createFilter(sfs).match(this.fwCtx.props.getProperties())) {
                                    continue;
                                }
                                break block31;
                            }
                            catch (InvalidSyntaxException ise) {
                                throw new BundleException(((Object)new StringBuffer().append("Bundle#").append(this.bid).append(", Invalid syntax for native code selection filter: ").append(sfs)).toString(), 8, ise);
                            }
                        }
                        throw new BundleException(((Object)new StringBuffer().append("Bundle#").append(this.bid).append(", Invalid character after native code selection filter: ").append(sfs)).toString(), 8);
                    }
                }
                if (best != null) {
                    boolean verEqual = false;
                    if (bestVer != null) {
                        if (matchVer == null) continue;
                        int d = bestVer.getLeft().compareTo(matchVer.getLeft());
                        if (d == 0) {
                            verEqual = true;
                        } else if (d > 0) {
                            continue;
                        }
                    } else if (matchVer == null) {
                        verEqual = true;
                    }
                    if (verEqual && (!matchLang || bestLang)) continue;
                }
                best = keys;
                bestVer = matchVer;
                bestLang = matchLang;
            }
            if (best == null) {
                if (optional) {
                    return;
                }
                throw new BundleException(((Object)new StringBuffer().append("Bundle#").append(this.bid).append(", no matching native code libraries found for os=").append(os).append(" version=").append(osVer).append(", processor=").append(proc).append(" and language=").append(osLang).append(".")).toString(), 8);
            }
            this.nativeLibs = new HashMap<String, FileArchive>();
            block9: for (String name : best) {
                for (FileArchive fa : this.archives) {
                    String key;
                    if (isFrag && fa.getBundleGeneration().archive != ba || (key = fa.checkNativeLibrary(name)) == null) continue;
                    this.nativeLibs.put(key, fa);
                    if (!this.debug.classLoader) continue block9;
                    this.debug.println(((Object)new StringBuffer().append(this).append("- Registered native library: ").append(key).append(" -> ").append(fa)).toString());
                    continue block9;
                }
                throw new BundleException(((Object)new StringBuffer().append("Bundle#").append(this.bid).append(", failed to resolve native code: ").append(name)).toString(), 8);
            }
        } else {
            this.nativeLibs = null;
        }
    }

    private boolean containsIgnoreCase(List<String> fl, List<String> l) {
        for (String string : l) {
            String s = string.toLowerCase();
            for (String string2 : fl) {
                if (!Util.filterMatch(string2, s)) continue;
                return true;
            }
        }
        return false;
    }
}

