/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.knopflerfish.framework.BundleURLConnection;
import org.knopflerfish.framework.FrameworkContext;

public class BundleURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "bundle";
    public static final String PERM_OK = "P";
    private final ArrayList<FrameworkContext> framework = new ArrayList(2);

    public URLConnection openConnection(URL u) throws IOException {
        String h = u.getHost();
        FrameworkContext fw = this.getFramework(h);
        if (fw == null) {
            throw new IOException("Framework associated with URL is not active");
        }
        if (u.getAuthority() != PERM_OK) {
            fw.perm.checkResourceAdminPerm(fw.bundles.getBundle(BundleURLStreamHandler.getId(h)));
        }
        return new BundleURLConnection(u, fw);
    }

    protected void parseURL(URL u, String s, int start, int limit) {
        FrameworkContext fw;
        int cpElem;
        long id;
        String host;
        String path;
        block28: {
            int pstart;
            path = u.getPath();
            host = u.getHost();
            id = -1L;
            cpElem = u.getPort();
            if (limit <= start) break block28;
            int len = limit - start;
            char[] sc = new char[len];
            s.getChars(start, limit, sc, 0);
            int pos = 0;
            if (len >= 2 && sc[0] == '/' && sc[1] == '/') {
                for (pos = 2; pos < len && sc[pos] != ':' && sc[pos] != '/'; ++pos) {
                    if (sc[pos] == '!' || sc[pos] == '.') {
                        if (id != -1L) continue;
                        id = Long.parseLong(new String(sc, 2, pos - 2));
                        continue;
                    }
                    if (Character.isDigit(sc[pos])) continue;
                    throw new IllegalArgumentException("Illegal chars in bundle id specification");
                }
                host = new String(sc, 2, pos - 2);
                if (pos < len && sc[pos] == ':') {
                    ++pos;
                    cpElem = 0;
                    while (pos < len && sc[pos] != '/') {
                        if (!Character.isDigit(sc[pos])) {
                            throw new IllegalArgumentException("Illegal chars in bundle port specification");
                        }
                        cpElem = 10 * cpElem + (sc[pos++] - 48);
                    }
                } else {
                    cpElem = -1;
                }
            }
            if (pos >= len) break block28;
            if (sc[pos] != '/') {
                if (path != null) {
                    int dirend = path.lastIndexOf(47) + 1;
                    if (dirend > 0) {
                        int plen = len - pos;
                        pstart = path.startsWith("/") ? 0 : 1;
                        if ((len = dirend + plen + pstart) > sc.length) {
                            char[] newsc = new char[len];
                            System.arraycopy(sc, pos, newsc, dirend + pstart, plen);
                            sc = newsc;
                        } else if (pos != dirend) {
                            System.arraycopy(sc, pos, sc, dirend + pstart, plen);
                        }
                        path.getChars(1 - pstart, dirend, sc, 1);
                    } else {
                        len = 1;
                    }
                } else {
                    len = 1;
                }
                sc[0] = 47;
                pstart = 0;
                pos = 0;
            } else {
                pstart = pos;
            }
            int dots = 0;
            int ipos = pstart - 1;
            boolean slash = false;
            while (pos < len) {
                block30: {
                    block32: {
                        block33: {
                            block34: {
                                block29: {
                                    block31: {
                                        if (sc[pos] != '/') break block29;
                                        if (slash) break block30;
                                        slash = true;
                                        if (dots != 1) break block31;
                                        dots = 0;
                                        break block30;
                                    }
                                    if (dots == 2 && ipos > pstart) {
                                        dots = 0;
                                        while (ipos > pstart && sc[--ipos] != '/') {
                                        }
                                    }
                                    break block32;
                                    break block30;
                                }
                                if (sc[pos] != '.') break block33;
                                if (!slash) break block34;
                                dots = 1;
                                slash = false;
                                break block30;
                            }
                            if (dots != 1) break block32;
                            dots = 2;
                            break block30;
                        }
                        slash = false;
                    }
                    while (dots-- > 0) {
                        sc[++ipos] = 46;
                    }
                    if (++ipos != pos) {
                        sc[ipos] = sc[pos];
                    }
                }
                ++pos;
            }
            if (dots == 2) {
                if (ipos > pstart) {
                    while (ipos > pstart && sc[--ipos] != '/') {
                    }
                } else {
                    while (dots-- > 0) {
                        sc[++ipos] = 46;
                    }
                    sc[++ipos] = 47;
                }
            }
            path = new String(sc, pstart, ipos - pstart + 1);
        }
        if (id == -1L) {
            id = BundleURLStreamHandler.getId(host);
        }
        if ((fw = this.getFramework(host)) == null) {
            throw new IllegalArgumentException("Framework associated with URL is not active");
        }
        fw.perm.checkResourceAdminPerm(fw.bundles.getBundle(id));
        this.setURL(u, PROTOCOL, host, cpElem, PERM_OK, null, path, null, null);
    }

    protected boolean equals(URL u1, URL u2) {
        return this.sameFile(u1, u2);
    }

    protected int hashCode(URL u) {
        int h = 0;
        if (PROTOCOL.equals(u.getProtocol())) {
            String file;
            String host = u.getHost();
            if (host != null) {
                h = host.hashCode();
            }
            if ((file = u.getFile()) != null) {
                h += file.hashCode();
            }
            h += u.getPort();
        } else {
            h = ((Object)u).hashCode();
        }
        return h;
    }

    protected boolean sameFile(URL u1, URL u2) {
        String p1 = u1.getProtocol();
        if (PROTOCOL.equals(p1)) {
            if (!p1.equals(u2.getProtocol())) {
                return false;
            }
            if (!this.hostsEqual(u1, u2)) {
                return false;
            }
            if (!(u1.getFile() == u2.getFile() || u1.getFile() != null && u1.getFile().equals(u2.getFile()))) {
                return false;
            }
            return u1.getPort() == u2.getPort();
        }
        return ((Object)u1).equals(u2);
    }

    protected boolean hostsEqual(URL u1, URL u2) {
        String s2;
        String s1 = u1.getHost();
        return s1 == (s2 = u2.getHost()) || s1 != null && s1.equals(s2);
    }

    protected String toExternalForm(URL url) {
        StringBuffer res = new StringBuffer(url.getProtocol());
        res.append("://");
        res.append(url.getHost());
        int port = url.getPort();
        if (port >= 0) {
            res.append(":").append(port);
        }
        res.append(url.getPath());
        return ((Object)res).toString();
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    void addFramework(FrameworkContext fw) {
        this.framework.add(fw);
    }

    void removeFramework(FrameworkContext fw) {
        this.framework.remove(fw);
    }

    private FrameworkContext getFramework(String host) {
        int fwId;
        Iterator<FrameworkContext> i = this.framework.iterator();
        int e = host.indexOf("!");
        if (e == -1) {
            fwId = 0;
        } else {
            try {
                fwId = Integer.parseInt(host.substring(e + 1));
            }
            catch (NumberFormatException _) {
                return null;
            }
        }
        while (i.hasNext()) {
            FrameworkContext fw = i.next();
            if (fw.id != fwId) continue;
            return fw;
        }
        return null;
    }

    public static long getId(String host) {
        int e = host.indexOf(".");
        if (e == -1) {
            e = host.indexOf("!");
        }
        if (e >= 0) {
            host = host.substring(0, e);
        }
        return Long.parseLong(host);
    }
}

