/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.ImportPkg;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
implements ExportedPackage {
    private final ExportPkg pkg;

    ExportedPackageImpl(ExportPkg pkg) {
        this.pkg = pkg;
    }

    public String getName() {
        return this.pkg.name;
    }

    public Bundle getExportingBundle() {
        if (this.pkg.pkg != null) {
            return this.pkg.bpkgs.bg.bundle;
        }
        return null;
    }

    public Bundle[] getImportingBundles() {
        List<ImportPkg> imps = this.pkg.getPackageImporters();
        if (imps != null) {
            HashSet<BundleImpl> bs = new HashSet<BundleImpl>();
            Iterator<ImportPkg> i$ = imps.iterator();
            while (i$.hasNext()) {
                ImportPkg ip = i$.next();
                bs.add(ip.bpkgs.bg.bundle);
            }
            List<BundlePackages> rl = this.pkg.bpkgs.getRequiredBy();
            Iterator<BundlePackages> i$2 = rl.iterator();
            while (i$2.hasNext()) {
                BundlePackages bp = i$2.next();
                bs.add(bp.bg.bundle);
            }
            return bs.toArray(new Bundle[bs.size()]);
        }
        return null;
    }

    public String getSpecificationVersion() {
        return this.pkg.version.toString();
    }

    public boolean isRemovalPending() {
        if (this.pkg.isProvider()) {
            return this.pkg.zombie;
        }
        return false;
    }

    public Version getVersion() {
        return this.pkg.version;
    }

    public String toString() {
        return this.pkg.name + "(" + this.pkg.version + ")";
    }
}

