/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistrationImpl<S>
implements ServiceRegistration<S> {
    final FrameworkContext fwCtx;
    BundleImpl bundle;
    Object service;
    ServiceReferenceImpl<S> reference;
    private PropertiesDictionary properties;
    private Hashtable<Bundle, Integer> dependents = new Hashtable();
    private HashMap<Bundle, S> serviceInstances = new HashMap();
    private final HashSet<Bundle> ungetInProgress = new HashSet();
    private volatile boolean available;
    private final Object eventLock = new Object();
    private volatile boolean unregistering = false;
    private Thread factoryThread = null;

    ServiceRegistrationImpl(BundleImpl b, Object s, PropertiesDictionary props) {
        this.fwCtx = b.fwCtx;
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
    }

    @Override
    public ServiceReference<S> getReference() {
        ServiceReferenceImpl<S> res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Dictionary<String, ?> props) {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.available) {
                Set<ServiceListenerEntry> before;
                Services services = this.fwCtx.services;
                synchronized (services) {
                    PropertiesDictionary propertiesDictionary = this.properties;
                    synchronized (propertiesDictionary) {
                        Object old_rank = this.properties.get("service.ranking");
                        before = this.fwCtx.listeners.getMatchingServiceListeners(this.reference);
                        String[] classes = (String[])this.properties.get("objectClass");
                        Long sid = (Long)this.properties.get("service.id");
                        this.properties = new PropertiesDictionary(props, classes, sid);
                        Object new_rank = this.properties.get("service.ranking");
                        if (old_rank != new_rank && new_rank instanceof Integer && !((Object)((Integer)new_rank)).equals(old_rank)) {
                            this.fwCtx.services.updateServiceRegistrationOrder(this, classes);
                        }
                    }
                }
                this.fwCtx.perm.callServiceChanged(this.fwCtx, this.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(2, this.reference), before);
                if (!before.isEmpty()) {
                    this.fwCtx.perm.callServiceChanged(this.fwCtx, before, new ServiceEvent(8, this.reference), null);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        if (this.unregistering) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.unregistering) {
                return;
            }
            this.unregistering = true;
            if (this.available) {
                if (null != this.bundle) {
                    this.fwCtx.services.removeServiceRegistration(this);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
        if (null != this.bundle) {
            this.fwCtx.perm.callServiceChanged(this.fwCtx, this.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(4, this.reference), null);
        }
        object = this.eventLock;
        synchronized (object) {
            this.available = false;
            Bundle[] using = this.getUsingBundles();
            if (using != null) {
                for (Bundle element : using) {
                    this.ungetService(element, false);
                }
            }
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                this.bundle = null;
                this.dependents = null;
                this.reference = null;
                this.service = null;
                this.serviceInstances = null;
                this.unregistering = false;
            }
        }
    }

    PropertiesDictionary getProperties() {
        return this.properties;
    }

    Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    S getService(Bundle b) {
        boolean bl;
        Integer ref;
        BundleImpl sBundle = null;
        PropertiesDictionary propertiesDictionary = this.properties;
        synchronized (propertiesDictionary) {
            if (!this.available) return null;
            ref = this.dependents.get(b);
            if (this.service instanceof ServiceFactory) {
                if (ref == null) {
                    this.dependents.put(b, new Integer(0));
                    this.factoryThread = Thread.currentThread();
                } else if (this.factoryThread != null && this.factoryThread.equals(Thread.currentThread())) {
                    throw new IllegalStateException("Recursive call of getService");
                }
            } else {
                this.dependents.put(b, new Integer(ref != null ? ref + 1 : 1));
                Object object = this.service;
                return (S)object;
            }
            sBundle = this.bundle;
        }
        Object s = null;
        if (ref == null) {
            try {
                s = sBundle.fwCtx.perm.callGetService(this, b);
                if (s == null) {
                    sBundle.fwCtx.frameworkWarning(sBundle, (Throwable)new ServiceException("ServiceFactory produced null", 2), new FrameworkListener[0]);
                }
            }
            catch (Throwable throwable) {
                sBundle.fwCtx.frameworkError(sBundle, (Throwable)new ServiceException("ServiceFactory throw an exception", 3, throwable), new FrameworkListener[0]);
            }
            if (s != null) {
                String[] stringArray;
                for (String classe : stringArray = (String[])this.getProperty("objectClass")) {
                    String cls = classe;
                    if (sBundle.fwCtx.services.checkServiceClass(s, cls)) continue;
                    sBundle.fwCtx.frameworkError(sBundle, (Throwable)new ServiceException(((Object)new StringBuffer().append("ServiceFactory produced an object that did not implement: ").append(cls)).toString(), 2), new FrameworkListener[0]);
                    s = null;
                    break;
                }
            }
            if (s == null) {
                PropertiesDictionary propertiesDictionary2 = this.properties;
                synchronized (propertiesDictionary2) {
                    if (this.dependents != null) {
                        this.dependents.remove(b);
                    }
                    this.factoryThread = null;
                    return null;
                }
            }
        }
        boolean bl2 = false;
        PropertiesDictionary propertiesDictionary3 = this.properties;
        synchronized (propertiesDictionary3) {
            if (s == null) {
                while ((s = this.serviceInstances.get(b)) == null) {
                    try {
                        this.properties.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.dependents != null && this.dependents.containsKey(b)) continue;
                    break;
                }
            } else {
                this.factoryThread = null;
                this.serviceInstances.put(b, s);
                this.properties.notifyAll();
            }
            if (s != null) {
                Integer n = ref = this.dependents != null ? this.dependents.get(b) : null;
                if (ref != null) {
                    this.dependents.put(b, new Integer(ref + 1));
                } else {
                    bl = true;
                }
            }
        }
        if (!bl) return s;
        try {
            sBundle.fwCtx.perm.callUngetService(this, b, s);
            return null;
        }
        catch (Throwable throwable) {
            sBundle.fwCtx.frameworkError(sBundle, throwable, new FrameworkListener[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Hashtable<Bundle, Integer> d = this.dependents;
        if (d != null) {
            Hashtable<Bundle, Integer> hashtable = d;
            synchronized (hashtable) {
                int size = d.size() + this.ungetInProgress.size();
                if (size > 0) {
                    Bundle[] res = new Bundle[size];
                    Enumeration<Bundle> e = d.keys();
                    while (e.hasMoreElements()) {
                        res[--size] = e.nextElement();
                    }
                    for (Bundle b : this.ungetInProgress) {
                        res[--size] = b;
                    }
                    return res;
                }
            }
        }
        return null;
    }

    boolean isUsedByBundle(Bundle b) {
        Hashtable<Bundle, Integer> deps = this.dependents;
        if (deps != null) {
            return deps.containsKey(b);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle b, boolean checkRefCounter) {
        BundleImpl sBundle;
        Hashtable<Bundle, Integer> deps;
        Object serviceToRemove = null;
        Dictionary dictionary = this.properties;
        synchronized (dictionary) {
            if (this.dependents == null) {
                return false;
            }
            Integer countInteger = this.dependents.get(b);
            if (countInteger == null) {
                return false;
            }
            int count = countInteger;
            if (checkRefCounter && count > 1) {
                this.dependents.put(b, new Integer(count - 1));
            } else {
                Hashtable<Bundle, Integer> hashtable = this.dependents;
                synchronized (hashtable) {
                    this.ungetInProgress.add(b);
                    this.dependents.remove(b);
                }
                serviceToRemove = this.serviceInstances.remove(b);
            }
            deps = this.dependents;
            sBundle = this.bundle;
        }
        if (serviceToRemove != null && this.service instanceof ServiceFactory) {
            try {
                sBundle.fwCtx.perm.callUngetService(this, b, serviceToRemove);
            }
            catch (Throwable e) {
                sBundle.fwCtx.frameworkError(sBundle, e, new FrameworkListener[0]);
            }
        }
        dictionary = deps;
        synchronized (dictionary) {
            this.ungetInProgress.remove(b);
        }
        return true;
    }
}

