/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Services {
    HashMap<ServiceRegistrationImpl<?>, String[]> services = new HashMap();
    private final HashMap<String, List<ServiceRegistrationImpl<?>>> classServices = new HashMap();
    private PermissionOps secure;
    FrameworkContext framework;
    static final Util.Comparator<ServiceRegistrationImpl<?>, ServiceRegistrationImpl<?>> sComp = new Util.Comparator<ServiceRegistrationImpl<?>, ServiceRegistrationImpl<?>>(){

        @Override
        public int compare(ServiceRegistrationImpl<?> a, ServiceRegistrationImpl<?> b) {
            return a.reference.compareTo(b.reference);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((ServiceRegistrationImpl)x0, (ServiceRegistrationImpl)x1);
        }
    };
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;

    Services(FrameworkContext fwCtx, PermissionOps perm) {
        this.framework = fwCtx;
        this.secure = perm;
    }

    void clear() {
        this.services.clear();
        this.classServices.clear();
        this.secure = null;
        this.framework = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration<?> register(BundleImpl bundle, String[] classes, Object service, Dictionary<String, ?> properties) {
        if (service == null) {
            throw new IllegalArgumentException("Can't register null as a service");
        }
        for (String classe : classes) {
            String cls = classe;
            if (cls == null) {
                throw new IllegalArgumentException("Can't register as null class");
            }
            this.secure.checkRegisterServicePerm(cls);
            if (bundle.id != 0L) {
                if (cls.equals((class$org$osgi$service$packageadmin$PackageAdmin == null ? Services.class$("org.osgi.service.packageadmin.PackageAdmin") : class$org$osgi$service$packageadmin$PackageAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a PackageAdmin service is not allowed");
                }
                if (cls.equals((class$org$osgi$service$permissionadmin$PermissionAdmin == null ? Services.class$("org.osgi.service.permissionadmin.PermissionAdmin") : class$org$osgi$service$permissionadmin$PermissionAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a PermissionAdmin service is not allowed");
                }
                if (cls.equals((class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? Services.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin") : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName())) {
                    throw new IllegalArgumentException("Registeration of a ConditionalPermissionAdmin service is not allowed");
                }
            }
            if (service instanceof ServiceFactory || this.checkServiceClass(service, cls)) continue;
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Service object is not an instance of ").append(cls)).toString());
        }
        ServiceRegistrationImpl res = new ServiceRegistrationImpl(bundle, service, new PropertiesDictionary(properties, classes, null));
        Services len$ = this;
        synchronized (len$) {
            this.services.put(res, classes);
            for (String clazz : classes) {
                List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
                if (s == null) {
                    s = new ArrayList(1);
                    this.classServices.put(clazz, s);
                }
                int ip = Math.abs(Util.binarySearch(s, sComp, res) + 1);
                s.add(ip, res);
            }
        }
        ServiceReference r = res.getReference();
        bundle.fwCtx.perm.callServiceChanged(bundle.fwCtx, bundle.fwCtx.listeners.getMatchingServiceListeners(r), new ServiceEvent(1, r), null);
        return res;
    }

    synchronized void updateServiceRegistrationOrder(ServiceRegistrationImpl<?> sr, String[] classes) {
        for (String clazz : classes) {
            List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
            s.remove(sr);
            s.add(Math.abs(Util.binarySearch(s, sComp, sr) + 1), sr);
        }
    }

    boolean checkServiceClass(Object service, String cls) {
        Class<?> sc = service.getClass();
        ClassLoader scl = this.secure.getClassLoaderOf(sc);
        Class<?> c = null;
        boolean ok = false;
        try {
            c = scl != null ? scl.loadClass(cls) : Class.forName(cls);
            ok = c.isInstance(service);
        }
        catch (ClassNotFoundException e) {
            block2: for (Class<?> csc = sc; csc != null; csc = csc.getSuperclass()) {
                if (cls.equals(csc.getName())) {
                    ok = true;
                    break;
                }
                Class<?>[] ic = csc.getInterfaces();
                for (int iic = ic.length - 1; iic >= 0; --iic) {
                    if (!cls.equals(ic[iic].getName())) continue;
                    ok = true;
                    continue block2;
                }
            }
        }
        return ok;
    }

    synchronized List<ServiceRegistrationImpl<?>> get(String clazz) {
        List<ServiceRegistrationImpl<?>> v = this.classServices.get(clazz);
        if (v != null) {
            List res = (List)((ArrayList)v).clone();
            return res;
        }
        return null;
    }

    synchronized ServiceReference<?> get(BundleImpl bundle, String clazz) {
        try {
            ServiceReference<?>[] srs = this.get(clazz, null, bundle);
            if (this.framework.debug.service_reference) {
                this.framework.debug.println(((Object)new StringBuffer().append("get service ref ").append(clazz).append(" for bundle ").append(bundle.location).append(" = ").append(srs != null ? srs[0] : null)).toString());
            }
            if (srs != null) {
                return srs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized ServiceReference<?>[] get(String clazz, String filter, BundleImpl bundle) throws InvalidSyntaxException {
        void var4_18;
        LDAPExpr ldap = null;
        if (clazz == null) {
            if (filter != null) {
                ldap = new LDAPExpr(filter);
                Set<String> matched = ldap.getMatchedObjectClasses();
                if (matched != null) {
                    List<ServiceRegistrationImpl<?>> v = null;
                    boolean vReadOnly = true;
                    for (String match : matched) {
                        List<ServiceRegistrationImpl<?>> cl = this.classServices.get(match);
                        if (cl == null) continue;
                        if (v == null) {
                            v = cl;
                            continue;
                        }
                        if (vReadOnly) {
                            v = new ArrayList(v);
                            vReadOnly = false;
                        }
                        v.addAll(cl);
                    }
                    if (v == null) return null;
                    Iterator iterator = v.iterator();
                } else {
                    Iterator<ServiceRegistrationImpl<?>> iterator = this.services.keySet().iterator();
                }
            } else {
                Iterator<ServiceRegistrationImpl<?>> iterator = this.services.keySet().iterator();
            }
        } else {
            List<ServiceRegistrationImpl<?>> v = this.classServices.get(clazz);
            if (v == null) {
                return null;
            }
            Iterator<ServiceRegistrationImpl<?>> iterator = v.iterator();
            if (filter != null) {
                ldap = new LDAPExpr(filter);
            }
        }
        ArrayList res = new ArrayList();
        while (var4_18.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)var4_18.next();
            ServiceReference sri = sr.getReference();
            if (!this.secure.okGetServicePerms(sri) || filter != null && !ldap.evaluate(sr.getProperties(), false)) continue;
            if (bundle != null) {
                String[] classes = this.services.get(sr);
                for (int i = 0; i < classes.length; ++i) {
                    if (sri.isAssignableTo(bundle, classes[i])) continue;
                    sri = null;
                    break;
                }
            }
            if (sri == null) continue;
            res.add(sri);
        }
        if (res.isEmpty()) {
            return null;
        }
        if (bundle != null) {
            this.framework.serviceHooks.filterServiceReferences(bundle.bundleContext, clazz, filter, false, res);
        } else {
            this.framework.serviceHooks.filterServiceReferences(null, clazz, filter, true, res);
        }
        if (!res.isEmpty()) return res.toArray(new ServiceReference[res.size()]);
        return null;
    }

    synchronized void removeServiceRegistration(ServiceRegistrationImpl<?> sr) {
        String[] classes = (String[])sr.getProperty("objectClass");
        this.services.remove(sr);
        for (String clazz : classes) {
            List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
            if (s.size() > 1) {
                s.remove(sr);
                continue;
            }
            this.classServices.remove(clazz);
        }
    }

    synchronized Set<ServiceRegistrationImpl<?>> getRegisteredByBundle(Bundle b) {
        HashSet res = new HashSet();
        for (ServiceRegistrationImpl<?> sr : this.services.keySet()) {
            if (sr.bundle != b) continue;
            res.add(sr);
        }
        return res;
    }

    synchronized Set<ServiceRegistrationImpl<?>> getUsedByBundle(Bundle b) {
        HashSet res = new HashSet();
        for (ServiceRegistrationImpl<?> sr : this.services.keySet()) {
            if (!sr.isUsedByBundle(b)) continue;
            res.add(sr);
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

