/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionUpdateImpl;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionsHandle;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConditionalPermissionInfoStorage {
    private final File condPermDir;
    private long lastFile;
    private ArrayList<ConditionalPermissionInfoImpl> cpiTable = new ArrayList();
    private final PermissionsHandle ph;
    private int generation = -1;
    private final Debug debug;
    private final boolean readOnly;
    static final String END_MARKER = "END";

    ConditionalPermissionInfoStorage(PermissionsHandle ph) {
        this.ph = ph;
        this.debug = ph.framework.debug;
        this.readOnly = ph.framework.props.getBooleanProperty("org.knopflerfish.framework.readonly");
        this.condPermDir = Util.getFileStorage(ph.framework, "condperm", !this.readOnly);
        if (this.condPermDir == null) {
            System.err.println("Property org.osgi.framework.dir not set,conditional permission info will not be saved between sessions");
        } else {
            this.load();
        }
    }

    synchronized ConditionalPermissionInfo get(String name) {
        int i = this.find(name);
        if (i >= 0) {
            return this.cpiTable.get(i);
        }
        return null;
    }

    synchronized Enumeration<ConditionalPermissionInfo> getAllEnumeration() {
        return new Vector<ConditionalPermissionInfoImpl>(this.cpiTable).elements();
    }

    ArrayList<ConditionalPermissionInfoImpl> getAll() {
        return this.cpiTable;
    }

    synchronized ConditionalPermissionUpdate getUpdate() {
        return new ConditionalPermissionUpdateImpl(this, this.cpiTable, this.generation);
    }

    synchronized ConditionalPermissionInfo put(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        ConditionalPermissionInfoImpl old;
        int oldIx;
        if (name == null) {
            name = this.uniqueName();
            oldIx = -1;
        } else {
            if (name.equals("")) {
                throw new IllegalArgumentException("Name can not be an empty string");
            }
            oldIx = this.find(name);
        }
        ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, name, conds, perms, "allow", this.ph.framework);
        if (oldIx >= 0) {
            old = this.cpiTable.set(oldIx, res);
            this.updateChangedConditionalPermission(res, oldIx, oldIx);
        } else {
            old = null;
            this.cpiTable.add(0, res);
            this.updateChangedConditionalPermission(res, 0, -1);
        }
        ++this.generation;
        this.save();
        if (this.debug.permissions) {
            this.debug.println(((Object)new StringBuffer().append("CondPermStorage set ").append(res)).toString());
            if (old != null) {
                this.debug.println(((Object)new StringBuffer().append("CondPermStorage replaced ").append(old)).toString());
            }
        }
        return res;
    }

    synchronized void remove(ConditionalPermissionInfoImpl obj) {
        int pos = this.cpiTable.indexOf(obj);
        if (this.debug.permissions) {
            this.debug.println(((Object)new StringBuffer().append("CondPermStorage remove ").append(obj).append(", pos=").append(pos)).toString());
        }
        if (pos >= 0) {
            this.cpiTable.remove(pos);
            this.updateChangedConditionalPermission(null, -1, pos);
            ++this.generation;
            this.save();
            if (this.debug.permissions) {
                this.debug.println(((Object)new StringBuffer().append("CondPermStorage removed ").append(obj)).toString());
            }
        }
    }

    synchronized boolean commitUpdate(List<ConditionalPermissionInfo> updatedTable, int parentGen) {
        int i;
        if (parentGen != this.generation) {
            return false;
        }
        ArrayList<ConditionalPermissionInfo> checkTable = new ArrayList<ConditionalPermissionInfo>(updatedTable);
        HashSet<String> names = new HashSet<String>();
        int oi = 0;
        ConditionalPermissionInfoImpl ocpi = oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
        int[] update = new int[this.cpiTable.size() + checkTable.size()];
        int ui = 0;
        String uniqueNameBase = ((Object)new StringBuffer().append(Integer.toString(this.generation, 36)).append("_")).toString();
        int nextRemove = update.length;
        for (i = 0; i < checkTable.size(); ++i) {
            ConditionalPermissionInfoImpl cpi;
            try {
                cpi = (ConditionalPermissionInfoImpl)checkTable.get(i);
            }
            catch (ClassCastException _) {
                throw new IllegalStateException(((Object)new StringBuffer().append("Illegal class of element in updated table, index=").append(i)).toString());
            }
            if (cpi == null) {
                throw new IllegalStateException(((Object)new StringBuffer().append("Updated table contains null element, index=").append(i)).toString());
            }
            String name = cpi.getName();
            if (name != null) {
                if (!names.add(name)) {
                    throw new IllegalStateException(((Object)new StringBuffer().append("Updated table contains elements with same name, name=").append(name)).toString());
                }
                while (name.startsWith(uniqueNameBase)) {
                    uniqueNameBase = ((Object)new StringBuffer().append(uniqueNameBase).append("_")).toString();
                }
            }
            if (cpi == ocpi) {
                ocpi = ++oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
                continue;
            }
            int removed = 0;
            for (int j = oi + 1; j < this.cpiTable.size(); ++j) {
                if (this.cpiTable.get(j) != cpi) continue;
                removed = j;
                break;
            }
            if (removed != 0) {
                while (oi++ < removed) {
                    if (nextRemove > ui) {
                        nextRemove = ui;
                    }
                    update[ui++] = -i - 1;
                }
                ocpi = oi < this.cpiTable.size() ? this.cpiTable.get(oi) : null;
                continue;
            }
            update[ui++] = i;
        }
        if (oi++ < this.cpiTable.size()) {
            if (nextRemove > ui) {
                nextRemove = ui;
            }
            do {
                update[ui++] = -i - 1;
            } while (oi++ < this.cpiTable.size());
        }
        if (ui == 0) {
            return true;
        }
        int NOP = Integer.MIN_VALUE;
        int nops = 0;
        int uniqueCounter = 0;
        for (int pui = 0; pui < ui; ++pui) {
            int u = update[pui];
            if (u >= 0) {
                ConditionalPermissionInfoImpl cpi;
                int rMatch;
                boolean remove = false;
                if (nextRemove < ui && update[nextRemove] + 1 == -(rMatch = u + nextRemove - pui - nops)) {
                    update[nextRemove] = Integer.MIN_VALUE;
                    ++nops;
                    while (++nextRemove < ui && update[nextRemove] >= 0) {
                    }
                    remove = true;
                }
                if ((cpi = (ConditionalPermissionInfoImpl)checkTable.get(u)).getName() == null) {
                    cpi.setName(((Object)new StringBuffer().append(uniqueNameBase).append(uniqueCounter++)).toString());
                }
                cpi.setPermissionInfoStorage(this);
                if (remove) {
                    this.cpiTable.set(u, cpi);
                    this.updateChangedConditionalPermission(cpi, u, u);
                    continue;
                }
                this.cpiTable.add(u, cpi);
                this.updateChangedConditionalPermission(cpi, u, -1);
                continue;
            }
            if (u != Integer.MIN_VALUE) {
                while (++nextRemove < ui && update[nextRemove] >= 0) {
                }
                u = -1 - u;
                this.cpiTable.remove(u);
                this.updateChangedConditionalPermission(null, -1, u);
                continue;
            }
            --nops;
        }
        ++this.generation;
        this.save();
        if (this.debug.permissions) {
            this.debug.println(((Object)new StringBuffer().append("CondPermStorage commited update, ").append(ui).append(" changes")).toString());
        }
        return true;
    }

    synchronized int size() {
        return this.cpiTable.size();
    }

    private int find(String name) {
        for (int i = 0; i < this.cpiTable.size(); ++i) {
            if (!((ConditionalPermissionInfo)this.cpiTable.get(i)).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private String uniqueName() {
        String uniqueNameBase = ((Object)new StringBuffer().append(Integer.toString(this.generation, 36)).append("_")).toString();
        for (ConditionalPermissionInfoImpl element : this.cpiTable) {
            String name = element.getName();
            while (name.startsWith(uniqueNameBase)) {
                uniqueNameBase = ((Object)new StringBuffer().append(uniqueNameBase).append("_")).toString();
            }
        }
        return ((Object)new StringBuffer().append(uniqueNameBase).append("0")).toString();
    }

    private void updateChangedConditionalPermission(ConditionalPermissionInfoImpl cpi, int pos, int removePos) {
        Iterator<PermissionsWrapper> i = this.ph.getPermissionWrappers();
        while (i.hasNext()) {
            i.next().updateChangedConditionalPermission(cpi, pos, removePos, this.cpiTable.size());
        }
    }

    private void save() {
        if (this.debug.permissions) {
            this.debug.println(((Object)new StringBuffer().append("CondPermStorage save ").append(this.size()).append(" cpis, gen=").append(this.generation)).toString());
        }
        if (this.condPermDir != null && !this.readOnly) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ConditionalPermissionInfoStorage.this.purge();
                    File f = new File(ConditionalPermissionInfoStorage.this.condPermDir, Long.toString(++ConditionalPermissionInfoStorage.this.lastFile));
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new FileWriter(f));
                        out.write(((Object)new StringBuffer().append("# Save generation ").append(ConditionalPermissionInfoStorage.this.generation).append(" at: ").append(System.currentTimeMillis())).toString());
                        out.newLine();
                        for (ConditionalPermissionInfoImpl element : ConditionalPermissionInfoStorage.this.cpiTable) {
                            out.write(element.toString());
                            out.newLine();
                        }
                        out.write(ConditionalPermissionInfoStorage.END_MARKER);
                        out.newLine();
                        out.close();
                    }
                    catch (IOException e) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                            f.delete();
                        }
                        ConditionalPermissionInfoStorage.this.debug.printStackTrace("NYI! Report error", e);
                    }
                    return null;
                }
            });
        }
    }

    private void load() {
        File[] files = PermUtil.getSortedFiles(this.condPermDir);
        this.lastFile = -1L;
        for (int i = files.length - 1; i >= 0; --i) {
            block3: {
                try {
                    long l = Long.parseLong(files[i].getName());
                    if (l <= this.lastFile) break block3;
                    this.lastFile = l;
                }
                catch (Exception ignore) {
                    continue;
                }
            }
            if (this.load(files[i])) break;
            files[i].delete();
        }
    }

    private boolean load(File fh) {
        BufferedReader in = null;
        ArrayList<ConditionalPermissionInfoImpl> loadTable = new ArrayList<ConditionalPermissionInfoImpl>();
        try {
            in = new BufferedReader(new FileReader(fh));
            String l = in.readLine();
            while (l != null) {
                if (!(l = l.trim()).equals("") && !l.startsWith("#")) {
                    if (l.equals(END_MARKER)) {
                        in.close();
                        this.cpiTable = loadTable;
                        return true;
                    }
                    ConditionalPermissionInfoImpl res = new ConditionalPermissionInfoImpl(this, l, this.ph.framework);
                    loadTable.add(res);
                }
                l = in.readLine();
            }
            in.close();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            this.debug.printStackTrace("NYI! Report error", e);
        }
        return false;
    }

    private void purge() {
        File[] files = PermUtil.getSortedFiles(this.condPermDir);
        int okName = 0;
        for (int i = files.length - 1; i >= 0; --i) {
            try {
                Long.parseLong(files[i].getName());
                if (++okName <= 2) continue;
                files[i].delete();
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }
}

