/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.CheckerMenu;
import com.inet.jortho.CheckerPopup;
import com.inet.jortho.Dictionary;
import com.inet.jortho.DictionaryFactory;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.PopupListener;
import com.inet.jortho.SpellCheckerDialog;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SpellChecker {
    private static String applicationName;
    private static Dictionary currentDictionary;
    private static Locale currentLocale;
    private static final SpellCheckerOptions globalOptions;
    private static final ArrayList<LanguageAction> languages;
    private static final Map<LanguageChangeListener, Object> listeners;
    static final String SELECTED_KEY = "SwingSelectedKey";
    private static UserDictionaryProvider userDictionaryProvider;

    public static void addLanguageChangeLister(LanguageChangeListener listener) {
        listeners.put(listener, null);
    }

    public static JMenu createCheckerMenu() {
        return SpellChecker.createCheckerMenu(null);
    }

    public static JMenu createCheckerMenu(SpellCheckerOptions options) {
        return new CheckerMenu(options);
    }

    public static JPopupMenu createCheckerPopup() {
        return SpellChecker.createCheckerPopup(null);
    }

    public static JPopupMenu createCheckerPopup(SpellCheckerOptions options) {
        return new CheckerPopup(options);
    }

    public static JMenu createLanguagesMenu() {
        JMenu menu = new JMenu(Utils.getResource("languages"));
        ButtonGroup group = new ButtonGroup();
        menu.setEnabled(languages.size() > 0);
        for (LanguageAction action : languages) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setModel(new ActionToggleButtonModel(action));
            menu.add(item);
            group.add(item);
        }
        if (languages.size() > 0) {
            menu.addSeparator();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(DisableLanguageAction.instance);
            item.setModel(new ActionToggleButtonModel(DisableLanguageAction.instance));
            menu.add(item);
            group.add(item);
        }
        return menu;
    }

    public static void enableAutoSpell(JTextComponent text, boolean enable) {
        SpellChecker.enableAutoSpell(text, enable, null);
    }

    public static void enableAutoSpell(JTextComponent text, boolean enable, SpellCheckerOptions options) {
        if (enable) {
            new AutoSpellChecker(text, options);
        } else {
            AutoSpellChecker.disable(text);
        }
    }

    public static void enablePopup(JTextComponent text, boolean enable) {
        if (enable) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(SpellChecker.createCheckerMenu());
            menu.add(SpellChecker.createLanguagesMenu());
            text.addMouseListener(new PopupListener(menu));
        } else {
            for (MouseListener listener : text.getMouseListeners()) {
                if (!(listener instanceof PopupListener)) continue;
                text.removeMouseListener(listener);
            }
        }
    }

    public static void enableShortKey(JTextComponent text, boolean enable) {
        SpellChecker.enableShortKey(text, enable, null);
    }

    public static void enableShortKey(final JTextComponent text, boolean enable, final SpellCheckerOptions options) {
        if (enable) {
            text.getInputMap().put(KeyStroke.getKeyStroke(118, 0), "spell-checking");
            text.getActionMap().put("spell-checking", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpellChecker.showSpellCheckerDialog(text, options);
                }
            });
        } else {
            text.getActionMap().remove("spell-checking");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(Locale oldLocale) {
        LanguageChangeEvent ev = new LanguageChangeEvent(currentLocale, oldLocale);
        Map<LanguageChangeListener, Object> map = listeners;
        synchronized (map) {
            for (LanguageChangeListener listener : listeners.keySet()) {
                listener.languageChanged(ev);
            }
        }
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static Dictionary getCurrentDictionary() {
        return currentDictionary;
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static SpellCheckerOptions getOptions() {
        return globalOptions;
    }

    static UserDictionaryProvider getUserDictionaryProvider() {
        return userDictionaryProvider;
    }

    public static void register(JTextComponent text) throws NullPointerException {
        SpellChecker.register(text, true, true, true);
    }

    public static void register(JTextComponent text, boolean hasPopup, boolean hasShortKey, boolean hasAutoSpell) throws NullPointerException {
        if (hasPopup) {
            SpellChecker.enablePopup(text, true);
        }
        if (hasShortKey) {
            SpellChecker.enableShortKey(text, true);
        }
        if (hasAutoSpell) {
            SpellChecker.enableAutoSpell(text, true);
        }
    }

    public static void registerDictionaries(URL baseURL, String activeLocale) {
        InputStream input;
        if (baseURL == null) {
            try {
                baseURL = new URL("file", null, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        try {
            input = new URL(baseURL, "dictionaries.cnf").openStream();
        }
        catch (Exception e1) {
            try {
                input = new URL(baseURL, "dictionaries.properties").openStream();
            }
            catch (Exception e2) {
                try {
                    input = new URL(baseURL, "dictionaries.txt").openStream();
                }
                catch (Exception e3) {
                    System.err.println("JOrtho configuration file not found!");
                    e1.printStackTrace();
                    e2.printStackTrace();
                    e3.printStackTrace();
                    return;
                }
            }
        }
        Properties props = new Properties();
        try {
            props.load(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String availableLocales = props.getProperty("languages");
        String extension = props.getProperty("extension", ".ortho");
        SpellChecker.registerDictionaries(baseURL, availableLocales, activeLocale, extension);
    }

    public static void registerDictionaries(URL baseURL, String availableLocales, String activeLocale) {
        SpellChecker.registerDictionaries(baseURL, availableLocales, activeLocale, ".ortho");
    }

    public static void registerDictionaries(URL baseURL, String availableLocales, String activeLocale, String extension) {
        if (baseURL == null) {
            try {
                baseURL = new URL("file", null, "");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        for (String locale : availableLocales.split(",")) {
            if ((locale = locale.trim().toLowerCase()).length() <= 0) continue;
            LanguageAction action = new LanguageAction(baseURL, new Locale(locale), extension);
            languages.remove(action);
            languages.add(action);
        }
        Collections.sort(languages);
        SpellChecker.setLanguage(activeLocale);
    }

    public static void setLanguage(String activeLocale) {
        boolean activeSelected = false;
        if (activeLocale != null) {
            activeLocale = activeLocale.trim();
            for (LanguageAction language : languages) {
                if (!language.getLocale().getLanguage().equals(activeLocale)) continue;
                language.actionPerformed(null);
                activeSelected = true;
            }
        }
        if (!activeSelected && languages.size() > 0) {
            DisableLanguageAction.instance.actionPerformed(null);
        }
    }

    public static String getLanguage() {
        return currentLocale == null ? null : currentLocale.getLanguage();
    }

    public static void removeLanguageChangeLister(LanguageChangeListener listener) {
        listeners.remove(listener);
    }

    public static void setApplicationName(String name) {
        applicationName = name;
    }

    public static void setUserDictionaryProvider(UserDictionaryProvider userDictionaryProvider) {
        SpellChecker.userDictionaryProvider = userDictionaryProvider;
    }

    public static void showSpellCheckerDialog(JTextComponent text, SpellCheckerOptions options) {
        if (!text.isEditable()) {
            return;
        }
        Dictionary dictionary = currentDictionary;
        if (dictionary != null) {
            Window parent = SwingUtilities.getWindowAncestor(text);
            SpellCheckerDialog dialog = parent instanceof Frame ? new SpellCheckerDialog((Frame)parent, true, options) : new SpellCheckerDialog((Dialog)parent, true, options);
            dialog.show(text, dictionary, currentLocale);
        }
    }

    public static void unregister(JTextComponent text) {
        SpellChecker.enableShortKey(text, false);
        SpellChecker.enablePopup(text, false);
        SpellChecker.enableAutoSpell(text, false);
    }

    private SpellChecker() {
    }

    static {
        globalOptions = new SpellCheckerOptions();
        languages = new ArrayList();
        listeners = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class LanguageAction
    extends AbstractAction
    implements Comparable<LanguageAction> {
        private static LanguageAction currentAction;
        private static final long serialVersionUID = 1L;
        private final URL baseURL;
        private final String extension;
        private final Locale locale;

        LanguageAction(String name) {
            super(name);
            this.baseURL = null;
            this.locale = null;
            this.extension = null;
        }

        LanguageAction(URL baseURL, Locale locale, String extension) {
            super(locale.getDisplayLanguage());
            this.baseURL = baseURL;
            this.locale = locale;
            this.extension = extension;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            Locale oldLocale = currentLocale;
            currentDictionary = null;
            currentLocale = null;
            SpellChecker.fireLanguageChanged(oldLocale);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DictionaryFactory factory = new DictionaryFactory();
                        try {
                            String userWords;
                            factory.loadWordList(new URL(LanguageAction.this.baseURL, "dictionary_" + LanguageAction.this.locale + LanguageAction.this.extension));
                            UserDictionaryProvider provider = userDictionaryProvider;
                            if (provider != null && (userWords = provider.getUserWords(LanguageAction.this.locale)) != null) {
                                factory.loadPlainWordList(new StringReader(userWords));
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                        }
                        currentDictionary = factory.create();
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    currentLocale = LanguageAction.this.locale;
                                    SpellChecker.fireLanguageChanged(null);
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        LanguageAction.this.setEnabled(true);
                    }
                }
            });
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public int compareTo(LanguageAction obj) {
            return this.toString().compareTo(obj.toString());
        }

        public boolean equals(Object obj) {
            if (obj instanceof LanguageAction) {
                return this.locale.equals(((LanguageAction)obj).locale);
            }
            return false;
        }

        public int hashCode() {
            return this.locale.hashCode();
        }

        public void setSelected(boolean b) {
            if (b) {
                if (currentAction != null && currentAction != this) {
                    currentAction.setSelected(false);
                }
                currentAction = this;
            }
            this.putValue(SpellChecker.SELECTED_KEY, b);
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class DisableLanguageAction
    extends LanguageAction {
        static DisableLanguageAction instance = new DisableLanguageAction();
        private static final long serialVersionUID = 1L;

        private DisableLanguageAction() {
            super(Utils.getResource("disable"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            try {
                currentDictionary = null;
                Locale oldLocale = currentLocale;
                currentLocale = null;
                SpellChecker.fireLanguageChanged(oldLocale);
            }
            finally {
                this.setEnabled(true);
            }
        }

        @Override
        public int compareTo(LanguageAction obj) {
            return this.equals(obj) ? 0 : 1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
        }
    }

    private static class ActionToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 1L;
        private final LanguageAction action;

        ActionToggleButtonModel(LanguageAction action) {
            this.action = action;
        }

        @Override
        public boolean isSelected() {
            return Boolean.TRUE.equals(this.action.getValue(SpellChecker.SELECTED_KEY));
        }

        @Override
        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.action.setSelected(b);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }
}

