/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Suggestion;
import com.inet.jortho.Suggestions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DictionaryBase {
    protected static final char LAST_CHAR = '\uffff';
    protected int idx;
    protected int size;
    protected char[] tree;

    protected DictionaryBase() {
    }

    DictionaryBase(char[] tree) {
        this.tree = tree;
        this.size = tree.length;
    }

    private int charDiff(char a, char b) {
        if ((a = Character.toLowerCase(a)) == (b = Character.toLowerCase(b))) {
            return 1;
        }
        if (Character.getType(a) != Character.getType(b)) {
            return 6;
        }
        return 5;
    }

    public boolean exist(String word) {
        this.idx = 0;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            while (this.idx < this.size && this.tree[this.idx] < c) {
                this.idx += 3;
            }
            if (this.idx >= this.size || this.tree[this.idx] != c) {
                return false;
            }
            if (i == word.length() - 1 && this.isWordMatch()) {
                return true;
            }
            this.idx = this.readIndex();
            if (this.idx > 0) continue;
            return false;
        }
        return false;
    }

    private boolean isWordMatch() {
        return (this.tree[this.idx + 1] & 0x8000) > 0;
    }

    final int readIndex() {
        return ((this.tree[this.idx + 1] & Short.MAX_VALUE) << 16) + this.tree[this.idx + 2];
    }

    private boolean searchChar(char c) {
        while (this.idx < this.size && this.tree[this.idx] < c) {
            this.idx += 3;
        }
        return this.idx < this.size && this.tree[this.idx] == c;
    }

    public List<Suggestion> searchSuggestions(String word) {
        if (word.length() == 0 || this.exist(word)) {
            return new ArrayList<Suggestion>();
        }
        Suggestions suggesions = new Suggestions(Math.min(20, 4 + word.length()));
        this.idx = 0;
        this.searchSuggestions(suggesions, word, 0, 0, 0);
        List<Suggestion> list = suggesions.getlist();
        Collections.sort(list);
        return list;
    }

    private void searchSuggestions(Suggestions list, CharSequence chars, int charPosition, int lastIdx, int diff) {
        StringBuilder buffer;
        StringBuilder buffer2;
        int tempIdx;
        if (diff > list.getMaxDissimilarity()) {
            return;
        }
        this.idx = lastIdx;
        char currentChar = chars.charAt(charPosition);
        if (this.searchChar(currentChar)) {
            if (this.isWordMatch()) {
                if (charPosition + 1 == chars.length()) {
                    list.add(new Suggestion(chars, diff));
                } else {
                    int length = charPosition + 1;
                    CharSequence chars2 = chars.subSequence(0, length);
                    list.add(new Suggestion(chars2, diff + (chars.length() - length) * 5));
                }
            }
            this.idx = this.readIndex();
            if (this.idx <= 0) {
                return;
            }
            if (charPosition + 1 == chars.length()) {
                this.searchSuggestionsLonger(list, chars, chars.length(), this.idx, diff + 5);
                return;
            }
            this.searchSuggestions(list, chars, charPosition + 1, this.idx, diff);
        }
        if (charPosition + 1 < chars.length()) {
            this.idx = lastIdx;
            currentChar = chars.charAt(charPosition + 1);
            if (this.searchChar(currentChar)) {
                tempIdx = this.idx;
                this.idx = this.readIndex();
                if (this.idx > 0) {
                    buffer2 = new StringBuilder(chars);
                    buffer2.setCharAt(charPosition + 1, chars.charAt(charPosition));
                    buffer2.setCharAt(charPosition, currentChar);
                    this.searchSuggestions(list, buffer2, charPosition + 1, this.idx, diff + 3);
                }
                this.idx = tempIdx;
                buffer2 = new StringBuilder();
                buffer2.append(chars, 0, charPosition);
                buffer2.append(chars, charPosition + 1, chars.length());
                this.searchSuggestions(list, buffer2, charPosition, lastIdx, diff + 5);
            }
        }
        tempIdx = this.idx = lastIdx;
        while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
            char newChar = this.tree[this.idx];
            this.idx = this.readIndex();
            if (this.idx > 0 && newChar != currentChar) {
                buffer = new StringBuilder(chars);
                buffer.insert(charPosition, newChar);
                this.searchSuggestions(list, buffer, charPosition + 1, this.idx, diff + 5);
            }
            this.idx = tempIdx += 3;
        }
        if (charPosition < chars.length()) {
            currentChar = chars.charAt(charPosition);
            tempIdx = this.idx = lastIdx;
            while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
                if (this.isWordMatch()) {
                    buffer2 = new StringBuilder();
                    buffer2.append(chars, 0, charPosition);
                    buffer2.append(this.tree[this.idx]);
                    list.add(new Suggestion(buffer2, diff + 5 + (chars.length() - buffer2.length()) * 5));
                }
                if (charPosition + 1 < chars.length()) {
                    char newChar = this.tree[this.idx];
                    this.idx = this.readIndex();
                    if (this.idx > 0 && newChar != currentChar) {
                        buffer = new StringBuilder(chars);
                        buffer.setCharAt(charPosition, newChar);
                        this.searchSuggestions(list, buffer, charPosition + 1, this.idx, diff + this.charDiff(currentChar, newChar));
                    }
                }
                this.idx = tempIdx += 3;
            }
        }
    }

    private void searchSuggestionsLonger(Suggestions list, CharSequence chars, int originalLength, int lastIdx, int diff) {
        this.idx = lastIdx;
        while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
            if (this.isWordMatch()) {
                list.add(new Suggestion(chars.toString() + this.tree[this.idx], diff));
            }
            this.idx += 3;
        }
    }
}

