/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class PairsMarker
implements CaretListener,
SyntaxComponent,
PropertyChangeListener {
    public static final String PROPERTY_COLOR = "PairMarker.Color";
    private JTextComponent pane;
    private Markers.SimpleMarker marker;
    private SyntaxComponent.Status status;

    public void caretUpdate(CaretEvent caretEvent) {
        this.removeMarkers();
        int n = caretEvent.getDot();
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(this.pane);
        Token token = syntaxDocument.getTokenAt(n);
        if (token != null && token.pairValue != 0) {
            Markers.markToken(this.pane, token, this.marker);
            Token token2 = syntaxDocument.getPairFor(token);
            if (token2 != null) {
                Markers.markToken(this.pane, token2, this.marker);
            }
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    public void config(Configuration configuration) {
        Color color = configuration.getColor(PROPERTY_COLOR, new Color(0xEEEE33));
        this.marker = new Markers.SimpleMarker(color);
    }

    public void install(JEditorPane jEditorPane) {
        this.pane = jEditorPane;
        this.pane.addCaretListener(this);
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    public void deinstall(JEditorPane jEditorPane) {
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.pane.removeCaretListener(this);
        this.removeMarkers();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document")) {
            this.pane.removeCaretListener(this);
            if (this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.removeMarkers();
            }
        }
    }
}

