/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.lexers;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import jsyntaxpane.Lexer;
import jsyntaxpane.Token;
import jsyntaxpane.TokenComparators;
import jsyntaxpane.TokenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRegexLexer
implements Lexer {
    Map<TokenType, Pattern> patterns = new HashMap<TokenType, Pattern>();

    public SimpleRegexLexer(Map map) {
        this.putPatterns(map);
    }

    public SimpleRegexLexer(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileReader(string));
        this.putPatterns(properties);
    }

    @Override
    public void parse(Segment segment, int n, List<Token> list) {
        TreeSet<Token> treeSet = new TreeSet<Token>(TokenComparators.LONGEST_FIRST);
        for (Map.Entry<TokenType, Pattern> object : this.patterns.entrySet()) {
            Matcher matcher = object.getValue().matcher(segment);
            while (matcher.find()) {
                Token token = new Token(object.getKey(), matcher.start() + n, matcher.end() - matcher.start());
                treeSet.add(token);
            }
        }
        int n2 = -1;
        for (Token token : treeSet) {
            if (token.start <= n2) continue;
            list.add(token);
            n2 = token.end();
        }
    }

    public SimpleRegexLexer putPattern(TokenType tokenType, String string) {
        this.patterns.put(tokenType, Pattern.compile(string));
        return this;
    }

    public SimpleRegexLexer putPatterns(Map map) {
        for (Object k : map.keySet()) {
            TokenType tokenType = TokenType.valueOf(k.toString());
            this.patterns.put(tokenType, Pattern.compile(map.get(k).toString()));
        }
        return this;
    }
}

