/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKitActions;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.StyleSelector;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTML;

class SHTMLPanelMultipleDocImpl
extends SHTMLPanelImpl
implements ChangeListener {
    public static final String newAction = "new";
    public static final String openAction = "open";
    public static final String closeAction = "close";
    public static final String closeAllAction = "closeAll";
    public static final String saveAction = "save";
    public static final String saveAsAction = "saveAs";
    private JTabbedPane jtpDocs;
    private StyleSelector styleSelector;
    private int activeTabNo;

    @Override
    protected void initDocumentPane() {
        this.dynRes.getAction(newAction).actionPerformed(null);
        this.getDocumentPane().getEditor().setCaretPosition(0);
    }

    @Override
    protected void initActions() {
        super.initActions();
        this.addAction("findReplace", new SHTMLEditorKitActions.MultipleDocFindReplaceAction(this));
        this.addAction("setStyle", new SHTMLEditorKitActions.SetStyleAction(this));
        this.addAction(newAction, new SHTMLEditorKitActions.SHTMLFileNewAction(this));
        this.addAction(openAction, new SHTMLEditorKitActions.SHTMLFileOpenAction(this));
        this.addAction(closeAction, new SHTMLEditorKitActions.SHTMLFileCloseAction(this));
        this.addAction(closeAllAction, new SHTMLEditorKitActions.SHTMLFileCloseAllAction(this));
        this.addAction(saveAction, new SHTMLEditorKitActions.SHTMLFileSaveAction(this));
        this.addAction("saveAll", new SHTMLEditorKitActions.SHTMLFileSaveAllAction(this));
        this.addAction(saveAsAction, new SHTMLEditorKitActions.SHTMLFileSaveAsAction(this));
        this.addAction("exit", new SHTMLEditorKitActions.SHTMLFileExitAction(this));
    }

    @Override
    protected void customizeFrame() {
        this.jtpDocs = new JTabbedPane();
        super.customizeFrame();
        this.jtpDocs.addChangeListener(this);
        this.splitPanel.addComponent(this.jtpDocs, 4);
    }

    @Override
    protected void createToolbarItem(JToolBar toolBar, String itemKey) {
        if (itemKey.equalsIgnoreCase("setStyle")) {
            this.styleSelector = new StyleSelector(this, HTML.Attribute.CLASS);
            this.styleSelector.setPreferredSize(new Dimension(110, 23));
            this.styleSelector.setAction(this.dynRes.getAction("setStyle"));
            Dimension comboBoxSize = new Dimension(300, 24);
            this.styleSelector.setMaximumSize(comboBoxSize);
            this.jtpDocs.addChangeListener(this.styleSelector);
            toolBar.add(this.styleSelector);
        } else {
            super.createToolbarItem(toolBar, itemKey);
        }
    }

    @Override
    protected void registerDocument() {
        super.registerDocument();
        ((SHTMLDocument)this.getDocumentPane().getDocument()).getStyleSheet().addChangeListener(this.styleSelector);
    }

    @Override
    protected void unregisterDocument() {
        super.unregisterDocument();
        ((SHTMLDocument)this.getDocumentPane().getDocument()).getStyleSheet().removeChangeListener(this.styleSelector);
    }

    @Override
    boolean close() {
        this.dynRes.getAction("exit").actionPerformed(new ActionEvent(this, 0, "exit"));
        return this.jtpDocs.getTabCount() == 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.activeTabNo = this.jtpDocs.getSelectedIndex();
        if (this.activeTabNo >= 0) {
            this.setDocumentPane((DocumentPane)this.jtpDocs.getComponentAt(this.activeTabNo));
            this.setEditorPane(this.getDocumentPane().getEditor());
            this.doc = (SHTMLDocument)this.getSHTMLEditorPane().getDocument();
            if (!this.ignoreActivateDoc) {
                this.getDocumentPane().fireActivated();
            }
        } else {
            this.setDocumentPane(null);
            this.setEditorPane(null);
            this.doc = null;
        }
    }

    JTabbedPane getTabbedPaneForDocuments() {
        return this.jtpDocs;
    }

    @Override
    void updateFormatControls() {
        super.updateFormatControls();
        this.styleSelector.update();
    }

    void incNewDocCounter() {
        ++this.newDocCounter;
    }

    void createNewDocumentPane() {
        this.setDocumentPane(new DocumentPane(null, ++this.newDocCounter));
    }

    void selectTabbedPane(int index) {
        this.ignoreActivateDoc = true;
        this.getTabbedPaneForDocuments().setSelectedIndex(index);
        this.ignoreActivateDoc = false;
    }

    int getActiveTabNo() {
        return this.activeTabNo;
    }

    void setActiveTabNo(int activeTabNo) {
        this.activeTabNo = activeTabNo;
    }
}

