/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.AccessControlException;
import org.freeplane.core.util.TextUtils;

class InternationalizedSecurityManager
extends SecurityManager {
    private static final int PERM_Accept = 0;
    private static final int PERM_Connect = 1;
    private static final int PERM_Delete = 7;
    private static final int PERM_Exec = 5;
    private static final int PERM_GROUP_EXEC = 2;
    private static final int PERM_GROUP_FILE = 0;
    private static final int PERM_GROUP_NETWORK = 1;
    private static final int PERM_Link = 6;
    private static final int PERM_Listen = 2;
    private static final int PERM_Multicast = 3;
    private static final int PERM_Read = 8;
    private static final int PERM_SetFactory = 4;
    private static final int PERM_Write = 9;

    @Override
    public void checkAccept(String pHost, int pPort) {
        try {
            super.checkAccept(pHost, pPort);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 0);
        }
    }

    @Override
    public void checkConnect(String pHost, int pPort) {
        try {
            super.checkConnect(pHost, pPort);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 1);
        }
    }

    @Override
    public void checkConnect(String pHost, int pPort, Object pContext) {
        try {
            super.checkConnect(pHost, pPort, pContext);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 1);
        }
    }

    @Override
    public void checkDelete(String pFile) {
        try {
            super.checkDelete(pFile);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 7);
        }
    }

    @Override
    public void checkExec(String pCmd) {
        try {
            super.checkExec(pCmd);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 2, 5);
        }
    }

    @Override
    public void checkLink(String pLib) {
        try {
            super.checkLink(pLib);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 2, 6);
        }
    }

    @Override
    public void checkListen(int pPort) {
        try {
            super.checkListen(pPort);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 2);
        }
    }

    @Override
    public void checkMulticast(InetAddress pMaddr) {
        try {
            super.checkMulticast(pMaddr);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 3);
        }
    }

    @Override
    public void checkMulticast(InetAddress pMaddr, byte pTtl) {
        try {
            super.checkMulticast(pMaddr, pTtl);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 3);
        }
    }

    @Override
    public void checkRead(FileDescriptor pFd) {
        try {
            super.checkRead(pFd);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 8);
        }
    }

    @Override
    public void checkRead(String pFile) {
        try {
            super.checkRead(pFile);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 8, pFile);
        }
    }

    @Override
    public void checkRead(String pFile, Object pContext) {
        try {
            super.checkRead(pFile, pContext);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 8, pFile);
        }
    }

    @Override
    public void checkSetFactory() {
        try {
            super.checkSetFactory();
        }
        catch (AccessControlException e) {
            throw this.getException(e, 1, 4);
        }
    }

    @Override
    public void checkWrite(FileDescriptor pFd) {
        try {
            super.checkWrite(pFd);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 9);
        }
    }

    @Override
    public void checkWrite(String pFile) {
        try {
            super.checkWrite(pFile);
        }
        catch (AccessControlException e) {
            throw this.getException(e, 0, 9);
        }
    }

    private SecurityException getException(AccessControlException e, int pPermissionGroup, int pPermission, String pFile) {
        String message = TextUtils.format((String)"plugins/ScriptEditor.FORBIDDEN_ACTION", (Object[])new Object[]{new Integer(pPermissionGroup), new Integer(pPermission), pFile});
        return new SecurityException(message, e);
    }

    private SecurityException getException(AccessControlException e, int pPermissionGroup, int pPermission) {
        return this.getException(e, pPermissionGroup, pPermission, "");
    }
}

