/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class ConnectorProxy
extends AbstractProxy<ConnectorModel>
implements Proxy.Connector {
    ConnectorProxy(ConnectorModel connector, ScriptContext scriptContext) {
        super(connector, scriptContext);
    }

    @Override
    public String getShape() {
        return this.getConnector().getShape().name();
    }

    @Override
    public void setShape(String shape) {
        this.getLinkController().setShape(this.getConnector(), ConnectorModel.Shape.valueOf((String)shape));
    }

    @Override
    public Color getColor() {
        return this.getLinkController().getColor(this.getConnector());
    }

    @Override
    public String getColorCode() {
        return ColorUtils.colorToString((Color)this.getColor());
    }

    ConnectorModel getConnector() {
        return (ConnectorModel)this.getDelegate();
    }

    @Override
    public boolean hasEndArrow() {
        return this.getConnector().getEndArrow() == ArrowType.DEFAULT;
    }

    @Override
    @Deprecated
    public ArrowType getEndArrow() {
        return this.getConnector().getEndArrow();
    }

    private MLinkController getLinkController() {
        return (MLinkController)LinkController.getController();
    }

    @Override
    public String getMiddleLabel() {
        return this.getConnector().getMiddleLabel();
    }

    @Override
    public Proxy.Node getSource() {
        return new NodeProxy(this.getConnector().getSource(), this.getScriptContext());
    }

    @Override
    public String getSourceLabel() {
        return this.getConnector().getSourceLabel();
    }

    @Override
    public boolean hasStartArrow() {
        return this.getConnector().getStartArrow() == ArrowType.DEFAULT;
    }

    @Override
    @Deprecated
    public ArrowType getStartArrow() {
        return this.getConnector().getStartArrow();
    }

    @Override
    public Proxy.Node getTarget() {
        return new NodeProxy(this.getConnector().getTarget(), this.getScriptContext());
    }

    @Override
    public String getTargetLabel() {
        return this.getConnector().getTargetLabel();
    }

    @Override
    public void setColor(Color color) {
        this.getLinkController().setConnectorColor(this.getConnector(), color);
    }

    @Override
    public void setColorCode(String rgbString) {
        this.setColor(ColorUtils.stringToColor((String)rgbString));
    }

    private void setEndArrowImpl(ArrowType arrowType) {
        ConnectorModel connector = this.getConnector();
        this.getLinkController().changeArrowsOfArrowLink(connector, connector.getStartArrow(), arrowType);
    }

    @Override
    public void setEndArrow(boolean showArrow) {
        this.setEndArrowImpl(showArrow ? ArrowType.DEFAULT : ArrowType.NONE);
    }

    @Override
    @Deprecated
    public void setEndArrow(ArrowType arrowType) {
        this.setEndArrowImpl(arrowType);
    }

    @Override
    public void setMiddleLabel(String label) {
        this.getLinkController().setMiddleLabel(this.getConnector(), label);
    }

    @Override
    @Deprecated
    public void setSimulatesEdge(boolean simulatesEdge) {
        if (simulatesEdge) {
            this.getLinkController().setShape(this.getConnector(), ConnectorModel.Shape.EDGE_LIKE);
        } else {
            this.getLinkController().setShape(this.getConnector(), ConnectorModel.Shape.CUBIC_CURVE);
        }
    }

    @Override
    public void setSourceLabel(String label) {
        this.getLinkController().setSourceLabel(this.getConnector(), label);
    }

    @Override
    public void setStartArrow(boolean showArrow) {
        this.setStartArrowImpl(showArrow ? ArrowType.DEFAULT : ArrowType.NONE);
    }

    private void setStartArrowImpl(ArrowType arrowType) {
        ConnectorModel connector = this.getConnector();
        this.getLinkController().changeArrowsOfArrowLink(connector, arrowType, connector.getEndArrow());
    }

    @Override
    @Deprecated
    public void setStartArrow(ArrowType arrowType) {
        this.setStartArrowImpl(arrowType);
    }

    @Override
    public void setTargetLabel(String label) {
        this.getLinkController().setTargetLabel(this.getConnector(), label);
    }

    @Override
    public boolean simulatesEdge() {
        return ConnectorModel.Shape.EDGE_LIKE.equals((Object)this.getConnector().getShape());
    }

    @Override
    public List<Integer> getStartInclination() {
        return ConnectorProxy.pointToList(this.getConnector().getStartInclination());
    }

    @Override
    public void setInclination(List<Integer> startPoint, List<Integer> endPoint) {
        if (startPoint == null || startPoint.size() != 2 || endPoint == null || endPoint.size() != 2) {
            throw new IllegalArgumentException("start and end points must have 2 elements");
        }
        this.getLinkController().setArrowLinkEndPoints(this.getConnector(), this.listToPoint(startPoint), this.listToPoint(endPoint));
    }

    @Override
    public List<Integer> getEndInclination() {
        return ConnectorProxy.pointToList(this.getConnector().getEndInclination());
    }

    private Point listToPoint(List<Integer> point) {
        return new Point(point.get(0), point.get(1));
    }

    private static List<Integer> pointToList(Point point) {
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(point.x);
        result.add(point.y);
        return result;
    }
}

