/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import genj.geo.GeoLocation;
import genj.geo.GeoService;
import genj.geo.GeoServiceException;
import genj.geo.GeoView;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import genj.window.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class QueryWidget
extends JPanel {
    private static final Resources RESOURCES = Resources.get((Object)QueryWidget.class);
    private static final String TXT_LOCATION = RESOURCES.getString("location");
    private static final String TXT_LATLON = RESOURCES.getString("location.latlon");
    private static final String TXT_QUERYING = RESOURCES.getString("query.querying");
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><row><label/></row><row><label/><city wx=\"1\"/></row><row><label/><lat wx=\"1\"/><lon wx=\"1\"/></row><row><label/></row><row><hits wx=\"1\" wy=\"1\"/></row></col>");
    private Model model;
    private GeoView view;
    private TextFieldWidget city;
    private TextFieldWidget lat;
    private TextFieldWidget lon;
    private JTable hits;
    private JLabel status;
    private boolean isChanging = false;

    public QueryWidget(GeoLocation setLocation, GeoView setView) {
        super((LayoutManager)LAYOUT.copy());
        this.view = setView;
        this.model = new Model();
        this.city = new TextFieldWidget(setLocation.getCity());
        this.lat = new TextFieldWidget(setLocation.isValid() ? "" + setLocation.getCoordinate().y : "");
        this.lon = new TextFieldWidget(setLocation.isValid() ? "" + setLocation.getCoordinate().x : "");
        this.city.setToolTipText(RESOURCES.getString("query.city.tip"));
        this.lat.setToolTipText(RESOURCES.getString("query.lat.tip"));
        this.lon.setToolTipText(RESOURCES.getString("query.lon.tip"));
        this.hits = new JTable(this.model);
        this.hits.setPreferredScrollableViewportSize(new Dimension(64, 64));
        this.status = new JLabel();
        this.add(new JLabel(RESOURCES.getString("query.instruction")));
        this.add(new JLabel(RESOURCES.getString("query.city")));
        this.add((Component)this.city);
        this.add(new JLabel(RESOURCES.getString("query.latlon")));
        this.add((Component)this.lat);
        this.add((Component)this.lon);
        this.add(this.status);
        this.add(new JScrollPane(this.hits));
        final Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String sCity = QueryWidget.this.city.getText().trim();
                int len = sCity.length();
                if (sCity.endsWith("*")) {
                    --len;
                }
                if (len < 3) {
                    return;
                }
                QueryWidget.this.model.setLocation(new GeoLocation(sCity, null, null));
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.city.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!QueryWidget.this.isChanging) {
                    timer.restart();
                }
            }
        });
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!QueryWidget.this.isChanging) {
                    QueryWidget.this.view.setSelection(QueryWidget.this.getGeoLocation());
                }
            }
        };
        this.lat.addChangeListener(cl);
        this.lon.addChangeListener(cl);
        this.hits.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = QueryWidget.this.hits.getSelectedRow();
                if (row < 0) {
                    return;
                }
                GeoLocation loc = QueryWidget.this.model.getLocation(row);
                QueryWidget.this.view.setSelection(loc);
                QueryWidget.this.isChanging = true;
                QueryWidget.this.city.setText(loc.getCity());
                QueryWidget.this.lat.setText("" + loc.getCoordinate().y);
                QueryWidget.this.lon.setText("" + loc.getCoordinate().x);
                QueryWidget.this.isChanging = false;
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.model.start();
    }

    public void removeNotify() {
        this.model.stop();
        this.view.setSelection(Collections.EMPTY_LIST);
        super.removeNotify();
    }

    public GeoLocation getGeoLocation() {
        try {
            GeoLocation loc = new GeoLocation(this.city.getText(), null, null);
            loc.setCoordinate(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            return loc;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class Model
    extends AbstractTableModel
    implements Runnable {
        private Thread thread = null;
        private boolean running = false;
        private GeoLocation query = null;
        private List locations = new ArrayList();

        private Model() {
        }

        public String getColumnName(int col) {
            switch (col) {
                default: {
                    return TXT_LOCATION;
                }
                case 1: 
            }
            return TXT_LATLON;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.locations.size();
        }

        public Object getValueAt(int row, int col) {
            GeoLocation loc = (GeoLocation)this.locations.get(row);
            switch (col) {
                default: {
                    return loc.toString();
                }
                case 1: 
            }
            return loc.getCoordinateAsString();
        }

        public GeoLocation getLocation(int row) {
            return (GeoLocation)this.locations.get(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLocation(GeoLocation set) {
            Model model = this;
            synchronized (model) {
                this.query = set;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                GeoLocation todo;
                Model model = this;
                synchronized (model) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    todo = this.query;
                    this.query = null;
                }
                if (!this.running || todo == null) continue;
                model = this;
                synchronized (model) {
                    this.locations = Collections.EMPTY_LIST;
                    this.fireTableDataChanged();
                    QueryWidget.this.status.setText(TXT_QUERYING);
                }
                try {
                    List found = GeoService.getInstance().query(todo);
                    Model model2 = this;
                    synchronized (model2) {
                        this.locations = found;
                        this.fireTableDataChanged();
                        QueryWidget.this.status.setText(RESOURCES.getString("query.matches", (Object)String.valueOf(found.size())));
                    }
                }
                catch (GeoServiceException e) {
                    GeoView.LOG.log(Level.WARNING, "exception while querying", e);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (QueryWidget.this.isVisible()) {
                                WindowManager.getInstance((Component)QueryWidget.this).openDialog(null, TXT_QUERYING, 1, e.getMessage(), Action2.okOnly(), (Component)QueryWidget.this);
                            }
                        }
                    });
                }
            }
        }

        private synchronized void start() {
            this.stop();
            this.running = true;
            this.thread = new Thread(this);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            this.running = false;
            Model model = this;
            synchronized (model) {
                this.notify();
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }
}

