/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;

public class GeometryEditor {
    private GeometryFactory factory = null;

    public GeometryEditor() {
    }

    public GeometryEditor(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public Geometry edit(Geometry geometry, GeometryEditorOperation geometryEditorOperation) {
        if (this.factory == null) {
            this.factory = geometry.getFactory();
        }
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, geometryEditorOperation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, geometryEditorOperation);
        }
        if (geometry instanceof Point) {
            return geometryEditorOperation.edit(geometry, this.factory);
        }
        if (geometry instanceof LineString) {
            return geometryEditorOperation.edit(geometry, this.factory);
        }
        Assert.shouldNeverReachHere("Unsupported Geometry classes should be caught in the GeometryEditorOperation.");
        return null;
    }

    private Polygon editPolygon(Polygon polygon, GeometryEditorOperation geometryEditorOperation) {
        Polygon polygon2 = (Polygon)geometryEditorOperation.edit(polygon, this.factory);
        if (polygon2.isEmpty()) {
            return polygon2;
        }
        LinearRing linearRing = (LinearRing)this.edit(polygon2.getExteriorRing(), geometryEditorOperation);
        if (linearRing.isEmpty()) {
            return this.factory.createPolygon(null, null);
        }
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon2.getNumInteriorRing(); ++i) {
            LinearRing linearRing2 = (LinearRing)this.edit(polygon2.getInteriorRingN(i), geometryEditorOperation);
            if (linearRing2.isEmpty()) continue;
            arrayList.add(linearRing2);
        }
        return this.factory.createPolygon(linearRing, arrayList.toArray(new LinearRing[0]));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection geometryCollection, GeometryEditorOperation geometryEditorOperation) {
        GeometryCollection geometryCollection2 = (GeometryCollection)geometryEditorOperation.edit(geometryCollection, this.factory);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometryCollection2.getNumGeometries(); ++i) {
            Geometry geometry = this.edit(geometryCollection2.getGeometryN(i), geometryEditorOperation);
            if (geometry.isEmpty()) continue;
            arrayList.add(geometry);
        }
        if (geometryCollection2.getClass() == MultiPoint.class) {
            return this.factory.createMultiPoint(arrayList.toArray(new Point[0]));
        }
        if (geometryCollection2.getClass() == MultiLineString.class) {
            return this.factory.createMultiLineString(arrayList.toArray(new LineString[0]));
        }
        if (geometryCollection2.getClass() == MultiPolygon.class) {
            return this.factory.createMultiPolygon(arrayList.toArray(new Polygon[0]));
        }
        return this.factory.createGeometryCollection(arrayList.toArray(new Geometry[0]));
    }

    public static abstract class CoordinateOperation
    implements GeometryEditorOperation {
        public Geometry edit(Geometry geometry, GeometryFactory geometryFactory) {
            if (geometry instanceof LinearRing) {
                return geometryFactory.createLinearRing(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof LineString) {
                return geometryFactory.createLineString(this.edit(geometry.getCoordinates(), geometry));
            }
            if (geometry instanceof Point) {
                Coordinate[] coordinateArray = this.edit(geometry.getCoordinates(), geometry);
                return geometryFactory.createPoint(coordinateArray.length > 0 ? coordinateArray[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, Geometry var2);
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1, GeometryFactory var2);
    }
}

