/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;

public class GeometryTransformer {
    private Geometry inputGeom;
    protected GeometryFactory factory = null;
    private boolean pruneEmptyGeometry = true;
    private boolean preserveGeometryCollectionType = true;
    private boolean preserveCollections = false;
    private boolean preserveType = false;

    public Geometry getInputGeometry() {
        return this.inputGeom;
    }

    public final Geometry transform(Geometry geometry) {
        this.inputGeom = geometry;
        this.factory = geometry.getFactory();
        if (geometry instanceof Point) {
            return this.transformPoint((Point)geometry, null);
        }
        if (geometry instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)geometry, null);
        }
        if (geometry instanceof LinearRing) {
            return this.transformLineString((LinearRing)geometry, null);
        }
        if (geometry instanceof LineString) {
            return this.transformLineString((LineString)geometry, null);
        }
        if (geometry instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)geometry, null);
        }
        if (geometry instanceof Polygon) {
            return this.transformPolygon((Polygon)geometry, null);
        }
        if (geometry instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)geometry, null);
        }
        if (geometry instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)geometry, null);
        }
        throw new IllegalArgumentException("Unknown Geometry subtype: " + geometry.getClass().getName());
    }

    protected final CoordinateSequence createCoordinateSequence(Coordinate[] coordinateArray) {
        return this.factory.getCoordinateSequenceFactory().create(coordinateArray);
    }

    protected final CoordinateSequence copy(CoordinateSequence coordinateSequence) {
        return (CoordinateSequence)coordinateSequence.clone();
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry geometry) {
        return this.copy(coordinateSequence);
    }

    protected Geometry transformPoint(Point point, Geometry geometry) {
        return this.factory.createPoint(this.transformCoordinates(point.getCoordinateSequence(), point));
    }

    protected Geometry transformMultiPoint(MultiPoint multiPoint, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            Geometry geometry2 = this.transformPoint((Point)multiPoint.getGeometryN(i), multiPoint);
            if (geometry2 == null || geometry2.isEmpty()) continue;
            arrayList.add(geometry2);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformLinearRing(LinearRing linearRing, Geometry geometry) {
        CoordinateSequence coordinateSequence = this.transformCoordinates(linearRing.getCoordinateSequence(), linearRing);
        int n = coordinateSequence.size();
        if (n > 0 && n < 4 && !this.preserveType) {
            return this.factory.createLineString(coordinateSequence);
        }
        return this.factory.createLinearRing(coordinateSequence);
    }

    protected Geometry transformLineString(LineString lineString, Geometry geometry) {
        return this.factory.createLineString(this.transformCoordinates(lineString.getCoordinateSequence(), lineString));
    }

    protected Geometry transformMultiLineString(MultiLineString multiLineString, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            Geometry geometry2 = this.transformLineString((LineString)multiLineString.getGeometryN(i), multiLineString);
            if (geometry2 == null || geometry2.isEmpty()) continue;
            arrayList.add(geometry2);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformPolygon(Polygon polygon, Geometry geometry) {
        boolean bl = true;
        Geometry geometry2 = this.transformLinearRing((LinearRing)polygon.getExteriorRing(), polygon);
        if (geometry2 == null || !(geometry2 instanceof LinearRing) || geometry2.isEmpty()) {
            bl = false;
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            Geometry geometry3 = this.transformLinearRing((LinearRing)polygon.getInteriorRingN(i), polygon);
            if (geometry3 == null || geometry3.isEmpty()) continue;
            if (!(geometry3 instanceof LinearRing)) {
                bl = false;
            }
            arrayList.add(geometry3);
        }
        if (bl) {
            return this.factory.createPolygon((LinearRing)geometry2, arrayList.toArray(new LinearRing[0]));
        }
        ArrayList<Geometry> arrayList2 = new ArrayList<Geometry>();
        if (geometry2 != null) {
            arrayList2.add(geometry2);
        }
        arrayList2.addAll(arrayList);
        return this.factory.buildGeometry(arrayList2);
    }

    protected Geometry transformMultiPolygon(MultiPolygon multiPolygon, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Geometry geometry2 = this.transformPolygon((Polygon)multiPolygon.getGeometryN(i), multiPolygon);
            if (geometry2 == null || geometry2.isEmpty()) continue;
            arrayList.add(geometry2);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformGeometryCollection(GeometryCollection geometryCollection, Geometry geometry) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry2 = this.transform(geometryCollection.getGeometryN(i));
            if (geometry2 == null || this.pruneEmptyGeometry && geometry2.isEmpty()) continue;
            arrayList.add(geometry2);
        }
        if (this.preserveGeometryCollectionType) {
            return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
        }
        return this.factory.buildGeometry(arrayList);
    }
}

