/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NodeMap {
    Map nodeMap = new TreeMap();
    NodeFactory nodeFact;

    public NodeMap(NodeFactory nodeFactory) {
        this.nodeFact = nodeFactory;
    }

    public Node addNode(Coordinate coordinate) {
        Node node = (Node)this.nodeMap.get(coordinate);
        if (node == null) {
            node = this.nodeFact.createNode(coordinate);
            this.nodeMap.put(coordinate, node);
        }
        return node;
    }

    public Node addNode(Node node) {
        Node node2 = (Node)this.nodeMap.get(node.getCoordinate());
        if (node2 == null) {
            this.nodeMap.put(node.getCoordinate(), node);
            return node;
        }
        node2.mergeLabel(node);
        return node2;
    }

    public void add(EdgeEnd edgeEnd) {
        Coordinate coordinate = edgeEnd.getCoordinate();
        Node node = this.addNode(coordinate);
        node.add(edgeEnd);
    }

    public Node find(Coordinate coordinate) {
        return (Node)this.nodeMap.get(coordinate);
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public Collection values() {
        return this.nodeMap.values();
    }

    public Collection getBoundaryNodes(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getLabel().getLocation(n) != 1) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public void print(PrintStream printStream) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.print(printStream);
        }
    }
}

