/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentString;
import java.util.Collection;
import java.util.Iterator;

public class NodingValidator {
    private LineIntersector li = new RobustLineIntersector();
    private Collection segStrings;

    public NodingValidator(Collection collection) {
        this.segStrings = collection;
    }

    public void checkValid() {
        this.checkNoInteriorPointsSame();
        this.checkProperIntersections();
    }

    private void checkProperIntersections() {
        Iterator iterator = this.segStrings.iterator();
        while (iterator.hasNext()) {
            SegmentString segmentString = (SegmentString)iterator.next();
            Iterator iterator2 = this.segStrings.iterator();
            while (iterator2.hasNext()) {
                SegmentString segmentString2 = (SegmentString)iterator2.next();
                this.checkProperIntersections(segmentString, segmentString2);
            }
        }
    }

    private void checkProperIntersections(SegmentString segmentString, SegmentString segmentString2) {
        Coordinate[] coordinateArray = segmentString.getCoordinates();
        Coordinate[] coordinateArray2 = segmentString2.getCoordinates();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            for (int j = 0; j < coordinateArray2.length - 1; ++j) {
                this.checkProperIntersections(segmentString, i, segmentString2, j);
            }
        }
    }

    private void checkProperIntersections(SegmentString segmentString, int n, SegmentString segmentString2, int n2) {
        if (segmentString == segmentString2 && n == n2) {
            return;
        }
        Coordinate coordinate = segmentString.getCoordinates()[n];
        Coordinate coordinate2 = segmentString.getCoordinates()[n + 1];
        Coordinate coordinate3 = segmentString2.getCoordinates()[n2];
        Coordinate coordinate4 = segmentString2.getCoordinates()[n2 + 1];
        this.li.computeIntersection(coordinate, coordinate2, coordinate3, coordinate4);
        if (this.li.hasIntersection() && (this.li.isProper() || this.hasInteriorIntersection(this.li, coordinate, coordinate2) || this.hasInteriorIntersection(this.li, coordinate, coordinate2))) {
            throw new RuntimeException("found non-noded intersection at " + coordinate + "-" + coordinate2 + " and " + coordinate3 + "-" + coordinate4);
        }
    }

    private boolean hasInteriorIntersection(LineIntersector lineIntersector, Coordinate coordinate, Coordinate coordinate2) {
        for (int i = 0; i < lineIntersector.getIntersectionNum(); ++i) {
            Coordinate coordinate3 = lineIntersector.getIntersection(i);
            if (coordinate3.equals(coordinate) || coordinate3.equals(coordinate2)) continue;
            return true;
        }
        return false;
    }

    private void checkNoInteriorPointsSame() {
        Iterator iterator = this.segStrings.iterator();
        while (iterator.hasNext()) {
            SegmentString segmentString = (SegmentString)iterator.next();
            Coordinate[] coordinateArray = segmentString.getCoordinates();
            this.checkNoInteriorPointsSame(coordinateArray[0], this.segStrings);
            this.checkNoInteriorPointsSame(coordinateArray[coordinateArray.length - 1], this.segStrings);
        }
    }

    private void checkNoInteriorPointsSame(Coordinate coordinate, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SegmentString segmentString = (SegmentString)iterator.next();
            Coordinate[] coordinateArray = segmentString.getCoordinates();
            for (int i = 1; i < coordinateArray.length - 1; ++i) {
                if (!coordinateArray[i].equals(coordinate)) continue;
                throw new RuntimeException("found bad noding at index " + i + " pt " + coordinate);
            }
        }
    }
}

