/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import java.util.Iterator;
import java.util.List;

public class RelateNodeGraph {
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public void build(GeometryGraph geometryGraph) {
        this.computeIntersectionNodes(geometryGraph, 0);
        this.copyNodesAndLabels(geometryGraph, 0);
        EdgeEndBuilder edgeEndBuilder = new EdgeEndBuilder();
        List list = edgeEndBuilder.computeEdgeEnds(geometryGraph.getEdgeIterator());
        this.insertEdgeEnds(list);
    }

    public void computeIntersectionNodes(GeometryGraph geometryGraph, int n) {
        Iterator iterator = geometryGraph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            int n2 = edge.getLabel().getLocation(n);
            Iterator iterator2 = edge.getEdgeIntersectionList().iterator();
            while (iterator2.hasNext()) {
                EdgeIntersection edgeIntersection = (EdgeIntersection)iterator2.next();
                RelateNode relateNode = (RelateNode)this.nodes.addNode(edgeIntersection.coord);
                if (n2 == 1) {
                    relateNode.setLabelBoundary(n);
                    continue;
                }
                if (!relateNode.getLabel().isNull(n)) continue;
                relateNode.setLabel(n, 0);
            }
        }
    }

    public void copyNodesAndLabels(GeometryGraph geometryGraph, int n) {
        Iterator iterator = geometryGraph.getNodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Node node2 = this.nodes.addNode(node.getCoordinate());
            node2.setLabel(n, node.getLabel().getLocation(n));
        }
    }

    public void insertEdgeEnds(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            this.nodes.add(edgeEnd);
        }
    }
}

