/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar {
    protected List outEdges = new ArrayList();
    private boolean sorted = false;

    public void add(DirectedEdge directedEdge) {
        this.outEdges.add(directedEdge);
        this.sorted = false;
    }

    public void remove(DirectedEdge directedEdge) {
        this.outEdges.remove(directedEdge);
    }

    public Iterator iterator() {
        this.sortEdges();
        return this.outEdges.iterator();
    }

    public int getDegree() {
        return this.outEdges.size();
    }

    public Coordinate getCoordinate() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DirectedEdge directedEdge = (DirectedEdge)iterator.next();
        return directedEdge.getCoordinate();
    }

    public List getEdges() {
        this.sortEdges();
        return this.outEdges;
    }

    private void sortEdges() {
        if (!this.sorted) {
            Collections.sort(this.outEdges);
            this.sorted = true;
        }
    }

    public int getIndex(Edge edge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge directedEdge = (DirectedEdge)this.outEdges.get(i);
            if (directedEdge.getEdge() != edge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(DirectedEdge directedEdge) {
        this.sortEdges();
        for (int i = 0; i < this.outEdges.size(); ++i) {
            DirectedEdge directedEdge2 = (DirectedEdge)this.outEdges.get(i);
            if (directedEdge2 != directedEdge) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(int n) {
        int n2 = n % this.outEdges.size();
        if (n2 < 0) {
            n2 += this.outEdges.size();
        }
        return n2;
    }

    public DirectedEdge getNextEdge(DirectedEdge directedEdge) {
        int n = this.getIndex(directedEdge);
        return (DirectedEdge)this.outEdges.get(this.getIndex(n + 1));
    }
}

