/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.NodeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class PlanarGraph {
    protected List edges = new ArrayList();
    protected List dirEdges = new ArrayList();
    protected NodeMap nodeMap = new NodeMap();

    public Node findNode(Coordinate coordinate) {
        return this.nodeMap.find(coordinate);
    }

    protected void add(Node node) {
        this.nodeMap.add(node);
    }

    protected void add(Edge edge) {
        this.edges.add(edge);
        this.add(edge.getDirEdge(0));
        this.add(edge.getDirEdge(1));
    }

    protected void add(DirectedEdge directedEdge) {
        this.dirEdges.add(directedEdge);
    }

    public Iterator nodeIterator() {
        return this.nodeMap.iterator();
    }

    public Collection getNodes() {
        return this.nodeMap.values();
    }

    public Iterator dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    public Iterator edgeIterator() {
        return this.edges.iterator();
    }

    public List getEdges() {
        return this.edges;
    }

    public void remove(Edge edge) {
        this.remove(edge.getDirEdge(0));
        this.remove(edge.getDirEdge(1));
        this.edges.remove(edge);
    }

    public void remove(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2 = directedEdge.getSym();
        if (directedEdge2 != null) {
            directedEdge2.setSym(null);
        }
        directedEdge.getFromNode().getOutEdges().remove(directedEdge);
        this.dirEdges.remove(directedEdge);
    }

    public void remove(Node node) {
        List list = node.getOutEdges().getEdges();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            DirectedEdge directedEdge2 = directedEdge.getSym();
            if (directedEdge2 != null) {
                this.remove(directedEdge2);
            }
            this.dirEdges.remove(directedEdge);
            Edge edge = directedEdge.getEdge();
            if (edge == null) continue;
            this.edges.remove(edge);
        }
        this.nodeMap.remove(node.getCoordinate());
    }

    public List findNodesOfDegree(int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Iterator iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getDegree() != n) continue;
            arrayList.add(node);
        }
        return arrayList;
    }
}

