/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Radius;

public class Spheroid {
    public double a;
    public double b;
    public double f;
    public double e;
    double es;
    double t1;
    double t2;
    double t3;
    double t4;
    double t5;
    double t6;

    public Spheroid(Radius radius) {
        this.a = radius.a;
        if (radius.b > 1.0) {
            this.b = radius.b;
            this.f = 1.0 - this.b / this.a;
        } else {
            this.f = 1.0 / radius.rf;
            this.b = this.a - this.a * this.f;
        }
        this.es = this.f + this.f - this.f * this.f;
        this.e = Math.sqrt(this.es);
        double d = this.a * (1.0 - this.es);
        double d2 = this.es * this.es;
        double d3 = d2 * this.es;
        double d4 = d3 * this.es;
        double d5 = d4 * this.es;
        this.t1 = d * (1.0 + 3.0 * this.es / 4.0 + 45.0 * d2 / 64.0 + 175.0 * d3 / 256.0 + 11025.0 * d4 / 16384.0 + 43659.0 * d5 / 65536.0);
        this.t2 = d * (3.0 * this.es / 4.0 + 15.0 * d2 / 16.0 + 525.0 * d3 / 512.0 + 2205.0 * d4 / 2048.0 + 72765.0 * d5 / 65536.0) / 2.0;
        this.t3 = d * (15.0 * d2 / 64.0 + 105.0 * d3 / 256.0 + 2205.0 * d4 / 4096.0 + 10395.0 * d5 / 16384.0) / 4.0;
        this.t4 = d * (35.0 * d3 / 512.0 + 315.0 * d4 / 2048.0 + 31185.0 * d5 / 131072.0) / 6.0;
        this.t5 = d * (315.0 * d4 / 16384.0 + 3465.0 * d5 / 65536.0) / 8.0;
        this.t6 = d * (693.0 * d5 / 131072.0) / 10.0;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getF() {
        return this.f;
    }

    public double getE() {
        return this.e;
    }

    public double distance(Geographic geographic, Geographic geographic2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = Math.atan((1.0 - this.f) * Math.tan(geographic.lat));
        double d8 = Math.atan((1.0 - this.f) * Math.tan(geographic2.lat));
        double d9 = Math.sin(d7);
        double d10 = Math.sin(d8);
        double d11 = Math.cos(d7);
        double d12 = Math.cos(d8);
        double d13 = d6 = geographic2.lon - geographic.lon;
        double d14 = Math.cos(d6);
        double d15 = Math.sin(d6);
        do {
            d4 = d9 * d10 + d11 * d12 * d14;
            d3 = Math.acos(d4);
            d2 = Math.asin(d11 * d12 * d15 / Math.sin(d3));
            d = Math.acos(d4 - 2.0 * d9 * d10 / (Math.cos(d2) * Math.cos(d2)));
            double d16 = this.deltaLongitude(d2, d3, d);
            d5 = d13 - (d6 + d16);
            d13 = d6 + d16;
            d14 = Math.cos(d13);
            d15 = Math.sin(d13);
        } while (Math.abs(d5) > 1.0E-32);
        double d17 = this.mu2(d2);
        double d18 = this.bigA(d17);
        double d19 = this.bigB(d17);
        double d20 = d19 * Math.sin(d3) * (Math.cos(d) + d19 * d4 * (-1.0 + 2.0 * (Math.cos(d) * Math.cos(d))) / 4.0);
        return this.b * (d18 * (d3 - d20));
    }

    public double direction(Geographic geographic, Geographic geographic2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = Math.atan((1.0 - this.f) * Math.tan(geographic.lat));
        double d8 = Math.atan((1.0 - this.f) * Math.tan(geographic2.lat));
        double d9 = Math.sin(d7);
        double d10 = Math.sin(d8);
        double d11 = Math.cos(d7);
        double d12 = Math.cos(d8);
        double d13 = d6 = geographic2.lon - geographic.lon;
        double d14 = Math.cos(d6);
        double d15 = Math.sin(d6);
        do {
            d4 = d9 * d10 + d11 * d12 * d14;
            d3 = Math.acos(d4);
            d2 = Math.asin(d11 * d12 * d15 / Math.sin(d3));
            d = Math.acos(d4 - 2.0 * d9 * d10 / (Math.cos(d2) * Math.cos(d2)));
            double d16 = this.deltaLongitude(d2, d3, d);
            d5 = d13 - (d6 + d16);
            d13 = d6 + d16;
            d14 = Math.cos(d13);
            d15 = Math.sin(d13);
        } while (Math.abs(d5) > 1.0E-32);
        double d17 = this.mu2(d2);
        double d18 = this.bigA(d17);
        double d19 = this.bigB(d17);
        double d20 = d19 * Math.sin(d3) * (Math.cos(d) + d19 * d4 * (-1.0 + 2.0 * (Math.cos(d) * Math.cos(d))) / 4.0);
        double d21 = this.b * (d18 * (d3 - d20));
        double d22 = Math.atan2(d12 * d15, d11 * d10 - d9 * d12 * d14);
        if (d22 < 0.0) {
            d22 += Math.PI * 2;
        }
        return d22;
    }

    public Geographic project(Geographic geographic, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = Math.sqrt(this.a * this.a - this.b * this.b) / this.b;
        double d7 = d6 * d6;
        double d8 = Math.atan((1.0 - this.f) * Math.tan(geographic.lat));
        double d9 = Math.cos(d8);
        double d10 = Math.sin(d8);
        double d11 = Math.cos(d2);
        double d12 = Math.sin(d2);
        double d13 = Math.atan(Math.tan(d8) / d11);
        double d14 = d9 * d12;
        double d15 = Math.asin(d14);
        double d16 = this.mu2(d15);
        double d17 = this.bigA(d16);
        double d18 = this.bigB(d16);
        double d19 = d5 = d / (this.b * d17);
        do {
            d3 = 2.0 * d13 + d19;
            double d20 = d18 * Math.sin(d19) * (Math.cos(d3) + 0.25 * d18 * Math.cos(d19) * (-1.0 + 2.0 * (Math.cos(d3) * Math.cos(d3))));
            d4 = d19 - (d5 + d20);
            d19 = d5 + d20;
        } while (Math.abs(d4) > 1.0E-32);
        double d21 = Math.cos(d19);
        double d22 = Math.sin(d19);
        Geographic geographic2 = new Geographic();
        geographic2.lat = d10 * d21 + d9 * d22 * d11;
        double d23 = Math.sqrt(d14 * d14 + (d10 * d22 - d9 * d21 * d11) * (d10 * d22 - d9 * d21 * d11));
        geographic2.lat = Math.atan2(geographic2.lat, (1.0 - this.f) * d23);
        double d24 = Math.atan2(d22 * d12, d9 * d21 - d10 * d22 * d11);
        geographic2.lon = geographic.lon + d24 - this.deltaLongitude(d15, d19, d3);
        return geographic2;
    }

    public double meridianRadiusOfCurvature(double d) {
        double d2 = 1.0 - this.es * Math.sin(d) * Math.sin(d);
        double d3 = Math.pow(d2, 1.5);
        double d4 = this.a * (1.0 - this.es) / d3;
        return d4;
    }

    public double primeVerticalRadiusOfCurvature(double d) {
        double d2 = this.a * this.a;
        double d3 = d2 * Math.cos(d) * Math.cos(d);
        double d4 = this.b * this.b * Math.sin(d) * Math.sin(d);
        double d5 = d2 / Math.sqrt(d3 + d4);
        return d5;
    }

    public double deltaLongitude(double d, double d2, double d3) {
        double d4 = Math.cos(d) * Math.cos(d);
        double d5 = this.f / 16.0 * d4 * (4.0 + this.f * (4.0 - 3.0 * d4));
        double d6 = Math.cos(d3);
        double d7 = d6 + d5 * Math.cos(d2) * (-1.0 + 2.0 * d6 * d6);
        d7 = d2 + d5 * Math.sin(d2) * d7;
        return (1.0 - d5) * this.f * Math.sin(d) * d7;
    }

    public double mu2(double d) {
        double d2 = Math.sqrt(this.a * this.a - this.b * this.b) / this.b;
        return Math.cos(d) * Math.cos(d) * d2 * d2;
    }

    public double bigA(double d) {
        return 1.0 + d / 256.0 * (64.0 + d * (-12.0 + 5.0 * d));
    }

    public double bigB(double d) {
        return d / 512.0 * (128.0 + d * (-64.0 + 37.0 * d));
    }

    public double M(double d) {
        return this.t1 * d - this.t2 * Math.sin(2.0 * d) + this.t3 * Math.sin(4.0 * d) - this.t4 * Math.sin(6.0 * d) + this.t5 * Math.sin(8.0 * d) - this.t5 * Math.sin(10.0 * d);
    }
}

