/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;
import com.vividsolutions.jump.coordsys.impl.MeridianArcLength;

public class TransverseMercator
extends Projection {
    double L0;
    double k0;
    private MeridianArcLength S = new MeridianArcLength();

    public void setParameters(double d) {
        this.L0 = d / 180.0 * Math.PI;
    }

    public Geographic asGeographic(Planar planar, Geographic geographic) {
        this.planarToGeographicInRadians(planar, geographic);
        geographic.lat = geographic.lat * 180.0 / Math.PI;
        geographic.lon = geographic.lon * 180.0 / Math.PI;
        return geographic;
    }

    public Planar asPlanar(Geographic geographic, Planar planar) {
        Geographic geographic2 = new Geographic();
        geographic2.lat = geographic.lat / 180.0 * Math.PI;
        geographic2.lon = geographic.lon / 180.0 * Math.PI;
        this.geographicInRadiansToPlanar(geographic2, planar);
        return planar;
    }

    void planarToGeographicInRadians(Planar planar, Geographic geographic) {
        double d;
        double d2 = this.footPointLatitude(planar.y);
        double d3 = this.currentSpheroid.getA();
        double d4 = this.currentSpheroid.getB();
        double d5 = (d3 * d3 - d4 * d4) / (d4 * d4);
        double d6 = this.currentSpheroid.primeVerticalRadiusOfCurvature(d2);
        double d7 = this.currentSpheroid.meridianRadiusOfCurvature(d2);
        double d8 = d5 * Math.pow(Math.cos(d2), 2.0);
        double d9 = Math.sqrt(d8);
        double d10 = d8 * d8;
        double d11 = d10 * d8;
        double d12 = d10 * d10;
        double d13 = Math.tan(d2);
        double d14 = d13 * d13;
        double d15 = d14 * d14;
        double d16 = d15 * d14;
        double d17 = d13 * Math.pow(planar.x, 2.0) / (2.0 * d7 * d6);
        double d18 = d13 * Math.pow(planar.x, 4.0) / (24.0 * d7 * Math.pow(d6, 3.0));
        double d19 = d13 * Math.pow(planar.x, 6.0) / (720.0 * d7 * Math.pow(d6, 5.0));
        double d20 = d13 * Math.pow(planar.x, 8.0) / (40320.0 * d7 * Math.pow(d6, 7.0));
        double d21 = 5.0 + 3.0 * d14 + d8 - 4.0 * d10 - 9.0 * d8 * d14;
        double d22 = 61.0 - 90.0 * d14 + 46.0 * d8 + 45.0 * d15 - 252.0 * d14 * d8 - 3.0 * d10 + 100.0 * d11 - 66.0 * d14 * d10 - 90.0 * d15 * d8 + 88.0 * d12 + 225.0 * d15 * d10 + 84.0 * d14 * d11 - 192.0 * d14 * d12;
        double d23 = 1385.0 + 3633.0 * d14 + 4095.0 * d15 + 1575.0 * d16;
        geographic.lat = d2 - d17 + d18 * d21 - d19 * d22 + d20 * d23;
        d17 = d = planar.x / d6;
        d18 = Math.pow(d, 3.0) / 6.0;
        d19 = Math.pow(d, 5.0) / 120.0;
        d20 = Math.pow(d, 7.0) / 5040.0;
        d21 = 1.0 + 2.0 * d14 + d8;
        d22 = 5.0 + 6.0 * d8 + 28.0 * d14 - 3.0 * d10 + 8.0 * d14 * d8 + 24.0 * d15 - 4.0 * d11 + 4.0 * d14 * d10 + 24.0 * d14 * d11;
        d23 = 61.0 + 662.0 * d14 + 1320.0 * d15 + 720.0 * d16;
        geographic.lon = 1.0 / Math.cos(d2) * (d17 - d18 * d21 + d19 * d22 - d20 * d23) + this.L0;
    }

    void geographicInRadiansToPlanar(Geographic geographic, Planar planar) {
        double d = this.currentSpheroid.getA();
        double d2 = this.currentSpheroid.getB();
        double d3 = (d * d - d2 * d2) / (d2 * d2);
        double d4 = this.currentSpheroid.primeVerticalRadiusOfCurvature(geographic.lat);
        double d5 = d3 * Math.pow(Math.cos(geographic.lat), 2.0);
        double d6 = Math.sqrt(d5);
        double d7 = d5 * d5;
        double d8 = d7 * d5;
        double d9 = d7 * d7;
        double d10 = Math.tan(geographic.lat);
        double d11 = d10 * d10;
        double d12 = d11 * d11;
        double d13 = d12 * d11;
        this.S.compute(this.currentSpheroid, geographic.lat, 0);
        double d14 = Math.cos(geographic.lat);
        double d15 = Math.sin(geographic.lat);
        double d16 = geographic.lon - this.L0;
        double d17 = d16 * d16;
        double d18 = d17 * d16;
        double d19 = d17 * d17;
        double d20 = d19 * d16;
        double d21 = d19 * d17;
        double d22 = d20 * d17;
        double d23 = d19 * d19;
        double d24 = d16 * d14;
        double d25 = d18 * Math.pow(d14, 3.0) / 6.0;
        double d26 = d20 * Math.pow(d14, 5.0) / 120.0;
        double d27 = d22 * Math.pow(d14, 7.0) / 5040.0;
        double d28 = 1.0 - d11 + d5;
        double d29 = 5.0 - 18.0 * d11 + d12 + 14.0 * d5 - 58.0 * d11 * d5 + 13.0 * d7 + 4.0 * d8 - 64.0 * d7 * d11 - 24.0 * d8 * d11;
        double d30 = 61.0 - 479.0 * d11 + 179.0 * d12 - d13;
        planar.x = d24 + d25 * d28 + d26 * d29 + d27 * d30;
        d24 = d17 / 2.0 * d15 * d14;
        d25 = d19 / 24.0 * d15 * Math.pow(d14, 3.0);
        d26 = d21 / 720.0 * d15 * Math.pow(d14, 5.0);
        d27 = d23 / 40320.0 * d15 * Math.pow(d14, 7.0);
        d28 = 5.0 - d11 + 9.0 * d5 + 4.0 * d7;
        d29 = 61.0 - 58.0 * d11 + d12 + 270.0 * d5 - 330.0 * d11 * d5 + 445.0 * d7 + 324.0 * d8 - 680.0 * d7 * d11 + 88.0 * d9 - 600.0 * d8 * d11 - 192.0 * d9 * d11;
        d30 = 1385.0 - 311.0 * d11 + 543.0 * d12 - d13;
        planar.y = this.S.s / d4 + d24 + d25 * d28 + d26 * d29 + d27 * d30;
        planar.x = d4 * planar.x;
        planar.y = d4 * planar.y;
    }

    private double footPointLatitude(double d) {
        double d2;
        double d3;
        double d4;
        double d5 = this.currentSpheroid.getA();
        double d6 = d / d5;
        int n = 0;
        do {
            d4 = d6;
            if (++n == 100) break;
            this.S.compute(this.currentSpheroid, d4, 0);
        } while (Math.abs((d6 = d4 - (d3 = this.S.s - d) / (d2 = d5 * (this.S.a0 - 2.0 * this.S.a2 * Math.cos(2.0 * d4) + 4.0 * this.S.a4 * Math.cos(4.0 * d4) - 6.0 * this.S.a6 * Math.cos(6.0 * d4) + 8.0 * this.S.a8 * Math.cos(8.0 * d4)))) - d4) > 1.0E-15);
        d4 = d6;
        return d4;
    }
}

