/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CoordinateArrays {
    private static final CGAlgorithms cga = new RobustCGAlgorithms();
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate[] toCoordinateArray(List list) {
        return list.toArray(coordArrayType);
    }

    public static void reverse(Coordinate[] coordinateArray) {
        int n = coordinateArray.length - 1;
        int n2 = n / 2;
        for (int i = 0; i <= n2; ++i) {
            Coordinate coordinate = coordinateArray[i];
            coordinateArray[i] = coordinateArray[n - i];
            coordinateArray[n - i] = coordinate;
        }
    }

    public static Geometry toLineOrPoint(Coordinate[] coordinateArray, GeometryFactory geometryFactory) {
        if (coordinateArray.length > 1) {
            return geometryFactory.createLineString(coordinateArray);
        }
        if (coordinateArray.length == 1) {
            return geometryFactory.createPoint(coordinateArray[0]);
        }
        return geometryFactory.createPoint((Coordinate)null);
    }

    public static boolean equals(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        if (coordinateArray == coordinateArray2) {
            return true;
        }
        if (coordinateArray == null || coordinateArray2 == null) {
            return false;
        }
        if (coordinateArray.length != coordinateArray2.length) {
            return false;
        }
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinateArray[i].equals(coordinateArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static List fromCoordinateArrays(List list, GeometryFactory geometryFactory) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Coordinate[] coordinateArray = (Coordinate[])iterator.next();
            Geometry geometry = CoordinateArrays.toLineOrPoint(coordinateArray, geometryFactory);
            arrayList.add(geometry);
        }
        return arrayList;
    }

    public static void addCoordinateArrays(Geometry geometry, boolean bl, List list) {
        if (geometry.getDimension() <= 0) {
            return;
        }
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            list.add(lineString.getCoordinates());
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            Coordinate[] coordinateArray = polygon.getExteriorRing().getCoordinates();
            if (bl) {
                coordinateArray = CoordinateArrays.ensureOrientation(coordinateArray, -1);
            }
            list.add(coordinateArray);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                Coordinate[] coordinateArray2 = polygon.getInteriorRingN(i).getCoordinates();
                if (bl) {
                    coordinateArray2 = CoordinateArrays.ensureOrientation(coordinateArray2, 1);
                }
                list.add(coordinateArray2);
            }
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                CoordinateArrays.addCoordinateArrays(geometryCollection.getGeometryN(i), bl, list);
            }
        } else {
            Assert.shouldNeverReachHere("Geometry of type " + geometry.getClass().getName() + " not handled");
        }
    }

    public static Coordinate[] ensureOrientation(Coordinate[] coordinateArray, int n) {
        int n2;
        if (coordinateArray.length == 0) {
            return coordinateArray;
        }
        int n3 = n2 = CGAlgorithms.isCCW(coordinateArray) ? 1 : -1;
        if (n2 != n) {
            Coordinate[] coordinateArray2 = (Coordinate[])coordinateArray.clone();
            CoordinateArrays.reverse(coordinateArray2);
            return coordinateArray2;
        }
        return coordinateArray;
    }

    public static List toCoordinateArrays(Geometry geometry, boolean bl) {
        ArrayList arrayList = new ArrayList();
        CoordinateArrays.addCoordinateArrays(geometry, bl, arrayList);
        return arrayList;
    }
}

