/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LayerManager {
    private static int layerManagerCount = 0;
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    private ArrayList categories = new ArrayList();
    private ArrayList layerReferencesToDispose = new ArrayList();
    private boolean firingEvents = true;
    private ArrayList layerListeners = new ArrayList();
    private Iterator firstColors;

    public LayerManager(Collection collection) {
        this.firstColors = collection.iterator();
        ++layerManagerCount;
    }

    public LayerManager() {
        ++layerManagerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferFiringEvents(Runnable runnable) {
        boolean bl = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            runnable.run();
        }
        finally {
            this.setFiringEvents(bl);
        }
    }

    public Color generateLayerFillColor() {
        Color color = this.firstColors != null && this.firstColors.hasNext() ? (Color)this.firstColors.next() : new Color((int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0));
        color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return color;
    }

    public Layer addLayer(String string, Layer layer) {
        this.addLayerable(string, layer);
        return layer;
    }

    public void addLayerable(String string, Layerable layerable) {
        if (layerable instanceof Layer) {
            if (this.size() == 0 && this.getCoordinateSystem() == CoordinateSystem.UNSPECIFIED) {
                this.setCoordinateSystem(((Layer)layerable).getFeatureCollection().getFeatureSchema().getCoordinateSystem());
            } else {
                this.reproject((Layer)layerable, this.coordinateSystem);
            }
            this.layerReferencesToDispose.add(new WeakReference<Layerable>(layerable));
        }
        this.addCategory(string);
        Category category = this.getCategory(string);
        category.add(0, layerable);
        this.fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reproject(Layer layer, CoordinateSystem coordinateSystem) {
        try {
            Assert.isTrue(this.indexOf(layer) == -1, "If the LayerManager contained this layer, we'd need to be concerned about rolling back on an error [Jon Aquino]");
            if (!Reprojector.instance().wouldChangeValues(layer.getFeatureCollection().getFeatureSchema().getCoordinateSystem(), coordinateSystem)) {
                return;
            }
            Iterator iterator = layer.getFeatureCollection().getFeatures().iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Reprojector.instance().reproject(feature.getGeometry(), layer.getFeatureCollection().getFeatureSchema().getCoordinateSystem(), coordinateSystem);
            }
        }
        finally {
            layer.getFeatureCollection().getFeatureSchema().setCoordinateSystem(coordinateSystem);
        }
    }

    public void addCategory(String string) {
        this.addCategory(string, this.categories.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(String string, int n) {
        if (this.getCategory(string) != null) {
            return;
        }
        Category category = new Category();
        category.setLayerManager(this);
        boolean bl = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            category.setName(string);
        }
        finally {
            this.setFiringEvents(bl);
        }
        this.categories.add(n, category);
        this.fireCategoryChanged(category, CategoryEventType.ADDED, this.indexOf(category));
    }

    public Category getCategory(String string) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            if (!category.getName().equals(string)) continue;
            return category;
        }
        return null;
    }

    public List getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public Layer addLayer(String string, String string2, FeatureCollection featureCollection) {
        String string3 = string2 == null ? "Layer" : string2;
        Layer layer = new Layer(string3, this.generateLayerFillColor(), featureCollection, this);
        this.addLayerable(string, layer);
        return layer;
    }

    public String uniqueLayerName(String string) {
        String string2;
        if (!this.isExistingLayerableName(string)) {
            return string;
        }
        if (string == "Relative Vectors") {
            new Throwable().printStackTrace(System.err);
        }
        int n = 2;
        do {
            string2 = string + " (" + n + ")";
            ++n;
        } while (this.isExistingLayerableName(string2));
        return string2;
    }

    private boolean isExistingLayerableName(String string) {
        Iterator iterator = this.getLayerables(Layerable.class).iterator();
        while (iterator.hasNext()) {
            Layerable layerable = (Layerable)iterator.next();
            if (!layerable.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void remove(Layerable layerable) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            int n = category.indexOf(layerable);
            if (n == -1) continue;
            category.remove(layerable);
            this.fireLayerChanged(layerable, LayerEventType.REMOVED, category, n);
        }
    }

    public void removeIfEmpty(Category category) {
        if (!category.isEmpty()) {
            return;
        }
        int n = this.indexOf(category);
        this.categories.remove(category);
        this.fireCategoryChanged(category, CategoryEventType.REMOVED, n);
    }

    public int indexOf(Category category) {
        return this.categories.indexOf(category);
    }

    public void fireCategoryChanged(Category category, CategoryEventType categoryEventType) {
        this.fireCategoryChanged(category, categoryEventType, this.indexOf(category));
    }

    private void fireCategoryChanged(final Category category, final CategoryEventType categoryEventType, final int n) {
        if (!this.firingEvents) {
            return;
        }
        Iterator iterator = this.layerListeners.iterator();
        while (iterator.hasNext()) {
            final LayerListener layerListener = (LayerListener)iterator.next();
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.categoryChanged(new CategoryEvent(category, categoryEventType, n));
                }
            });
        }
    }

    public void fireFeaturesChanged(Collection collection, FeatureEventType featureEventType, Layer layer) {
        Assert.isTrue(featureEventType != FeatureEventType.GEOMETRY_MODIFIED);
        this.fireFeaturesChanged(collection, featureEventType, layer, null);
    }

    public void fireGeometryModified(Collection collection, Layer layer, Collection collection2) {
        Assert.isTrue(collection2 != null);
        this.fireFeaturesChanged(collection, FeatureEventType.GEOMETRY_MODIFIED, layer, collection2);
    }

    private void fireFeaturesChanged(final Collection collection, final FeatureEventType featureEventType, final Layer layer, final Collection collection2) {
        if (!this.firingEvents) {
            return;
        }
        Iterator iterator = new ArrayList(this.layerListeners).iterator();
        while (iterator.hasNext()) {
            final LayerListener layerListener = (LayerListener)iterator.next();
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.featuresChanged(new FeatureEvent(collection, featureEventType, layer, collection2));
                }
            });
        }
    }

    private void fireLayerEvent(Runnable runnable) {
        try {
            GUIUtil.invokeOnEventThread(runnable);
        }
        catch (InterruptedException interruptedException) {
            Assert.shouldNeverReachHere();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace(System.err);
            Assert.shouldNeverReachHere();
        }
    }

    private void fireLayerChanged(final Layerable layerable, final LayerEventType layerEventType, final Category category, final int n) {
        if (!this.firingEvents) {
            return;
        }
        Iterator iterator = new ArrayList(this.layerListeners).iterator();
        while (iterator.hasNext()) {
            final LayerListener layerListener = (LayerListener)iterator.next();
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.layerChanged(new LayerEvent(layerable, layerEventType, category, n));
                }
            });
        }
    }

    public void fireLayerChanged(Layerable layerable, LayerEventType layerEventType) {
        Category category = this.getCategory(layerable);
        if (category == null) {
            Assert.isTrue(!this.isFiringEvents(), "If this event is being fired because you are constructing a Layer, cat will be null because you haven't yet added the Layer to the LayerManager. While constructing a layer, you should set firingEvents to false. (Layerable = " + layerable.getName() + ")");
            return;
        }
        this.fireLayerChanged(layerable, layerEventType, category, category.indexOf(layerable));
    }

    public void setFiringEvents(boolean bl) {
        this.firingEvents = bl;
    }

    public boolean isFiringEvents() {
        return this.firingEvents;
    }

    public Iterator reverseIterator(Class clazz) {
        ArrayList arrayList = new ArrayList(this.getLayerables(clazz));
        Collections.reverse(arrayList);
        this.moveLayersDrawnLastToEnd(arrayList);
        return arrayList.iterator();
    }

    private void moveLayersDrawnLastToEnd(List list) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Layer layer;
            Layerable layerable = (Layerable)iterator.next();
            if (!(layerable instanceof Layer) || !(layer = (Layer)layerable).isDrawingLast()) continue;
            arrayList.add(layer);
            iterator.remove();
        }
        list.addAll(arrayList);
    }

    public Iterator iterator() {
        return this.getLayers().iterator();
    }

    public Layer getLayer(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (!layer.getName().equals(string)) continue;
            return layer;
        }
        return null;
    }

    public void addLayerListener(LayerListener layerListener) {
        Assert.isTrue(!this.layerListeners.contains(layerListener));
        this.layerListeners.add(layerListener);
    }

    public void removeLayerListener(LayerListener layerListener) {
        this.layerListeners.remove(layerListener);
    }

    public Layer getLayer(int n) {
        return (Layer)this.getLayers().get(n);
    }

    public int size() {
        return this.getLayers().size();
    }

    public Envelope getEnvelopeOfAllLayers() {
        Envelope envelope = new Envelope();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            envelope.expandToInclude(layer.getFeatureCollection().getEnvelope());
        }
        return envelope;
    }

    public int indexOf(Layer layer) {
        return this.getLayers().indexOf(layer);
    }

    public Category getCategory(Layerable layerable) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            if (!category.contains(layerable)) continue;
            return category;
        }
        return null;
    }

    public List getLayers() {
        return this.getLayerables(Layer.class);
    }

    public List getLayerables(Class clazz) {
        Assert.isTrue(Layerable.class.isAssignableFrom(clazz));
        ArrayList<Layerable> arrayList = new ArrayList<Layerable>();
        Iterator iterator = new ArrayList(this.categories).iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            Iterator iterator2 = new ArrayList(category.getLayerables()).iterator();
            while (iterator2.hasNext()) {
                Layerable layerable = (Layerable)iterator2.next();
                if (!clazz.isInstance(layerable)) continue;
                arrayList.add(layerable);
            }
        }
        return arrayList;
    }

    public List getVisibleLayers(boolean bl) {
        ArrayList arrayList = new ArrayList(this.getLayers());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (layer.getName().equals("Fence") && !bl) {
                iterator.remove();
                continue;
            }
            if (layer.isVisible()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public void dispose() {
        Iterator iterator = this.layerReferencesToDispose.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Layer layer = (Layer)weakReference.get();
            if (layer == null) continue;
            layer.dispose();
        }
        --layerManagerCount;
    }

    public static int layerManagerCount() {
        return layerManagerCount;
    }

    public Collection getEditableLayers() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Iterator iterator = this.getLayers().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (!layer.isEditable()) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    public Collection getLayersWithModifiedFeatureCollections() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            if (!layer.isFeatureCollectionModified()) continue;
            arrayList.add(layer);
        }
        return arrayList;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public static void main(String[] stringArray) throws ParseException {
        System.out.println(Line2D.linesIntersect(708248.882609455, 2402253.07294874, 708249.523621829, 2402244.3124463, 708247.896591321, 2402252.48269854, 708261.854734465, 2402182.39086576));
        System.out.println(new WKTReader().read("LINESTRING(708248.882609455 2402253.07294874, 708249.523621829 2402244.3124463)").intersects(new WKTReader().read("LINESTRING(708247.896591321 2402252.48269854, 708261.854734465 2402182.39086576)")));
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }
}

