/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;

public class PolygonHandler
implements ShapeHandler {
    protected static CGAlgorithms cga = new RobustCGAlgorithms();
    int myShapeType;

    public PolygonHandler() {
        this.myShapeType = 5;
    }

    public PolygonHandler(int n) throws InvalidShapefileException {
        if (n != 5 && n != 15 && n != 25) {
            throw new InvalidShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.myShapeType = n;
    }

    boolean pointInList(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = Array.getLength(coordinateArray);
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            if (coordinate.x != coordinate2.x || coordinate.y != coordinate2.y || coordinate.z != coordinate2.z && coordinate.z == coordinate.z) continue;
            return true;
        }
        return false;
    }

    public Geometry read(EndianDataInputStream endianDataInputStream, GeometryFactory geometryFactory, int n) throws IOException, InvalidShapefileException {
        int n2;
        LinearRing linearRing;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = endianDataInputStream.readIntLE();
        n5 += 2;
        if (n6 == 0) {
            return new MultiPolygon(null, new PrecisionModel(), 0);
        }
        if (n6 != this.myShapeType) {
            throw new InvalidShapefileException("PolygonHandler.read() - got shape type " + n6 + " but was expecting " + this.myShapeType);
        }
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        endianDataInputStream.readDoubleLE();
        n5 += 16;
        int n7 = endianDataInputStream.readIntLE();
        int n8 = endianDataInputStream.readIntLE();
        n5 += 4;
        int[] nArray = new int[n7];
        for (int i = 0; i < n7; ++i) {
            nArray[i] = endianDataInputStream.readIntLE();
            n5 += 2;
        }
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        ArrayList<LinearRing> arrayList2 = new ArrayList<LinearRing>();
        Coordinate[] coordinateArray = new Coordinate[n8];
        for (n4 = 0; n4 < n8; ++n4) {
            coordinateArray[n4] = new Coordinate(endianDataInputStream.readDoubleLE(), endianDataInputStream.readDoubleLE());
            n5 += 8;
        }
        if (this.myShapeType == 15) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n5 += 8;
            for (n4 = 0; n4 < n8; ++n4) {
                coordinateArray[n4].z = endianDataInputStream.readDoubleLE();
                n5 += 4;
            }
        }
        if (this.myShapeType >= 15 && n >= (n4 = this.myShapeType == 15 ? 22 + 2 * n7 + 8 * n8 + 8 + 4 * n8 + 8 + 4 * n8 : 22 + 2 * n7 + 8 * n8 + 8 + 4 * n8)) {
            endianDataInputStream.readDoubleLE();
            endianDataInputStream.readDoubleLE();
            n5 += 8;
            for (n3 = 0; n3 < n8; ++n3) {
                endianDataInputStream.readDoubleLE();
                n5 += 4;
            }
        }
        while (n5 < n) {
            n4 = endianDataInputStream.readShortBE();
            ++n5;
        }
        n4 = 0;
        for (int i = 0; i < n7; ++i) {
            n3 = nArray[i];
            int n9 = i == n7 - 1 ? n8 : nArray[i + 1];
            int n10 = n9 - n3;
            Coordinate[] coordinateArray2 = new Coordinate[n10];
            for (int j = 0; j < n10; ++j) {
                coordinateArray2[j] = coordinateArray[n4];
                ++n4;
            }
            linearRing = geometryFactory.createLinearRing(coordinateArray2);
            if (CGAlgorithms.isCCW(coordinateArray2)) {
                arrayList2.add(linearRing);
                continue;
            }
            arrayList.add(linearRing);
        }
        ArrayList arrayList3 = new ArrayList(arrayList.size());
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            arrayList3.add(new ArrayList());
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            linearRing = (LinearRing)arrayList2.get(n2);
            Geometry geometry = null;
            Envelope envelope = null;
            Envelope envelope2 = linearRing.getEnvelopeInternal();
            Coordinate coordinate = linearRing.getCoordinateN(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                LinearRing linearRing2 = (LinearRing)arrayList.get(i);
                Envelope envelope3 = linearRing2.getEnvelopeInternal();
                if (geometry != null) {
                    envelope = geometry.getEnvelopeInternal();
                }
                boolean bl = false;
                Coordinate[] coordinateArray3 = linearRing2.getCoordinates();
                if (envelope3.contains(envelope2)) {
                    if (CGAlgorithms.isPointInRing(coordinate, coordinateArray3) || this.pointInList(coordinate, coordinateArray3)) {
                        bl = true;
                    }
                }
                if (!bl || geometry != null && !envelope.contains(envelope3)) continue;
                geometry = linearRing2;
            }
            if (geometry == null) {
                System.out.println("polygon found with a hole thats not inside a shell");
                continue;
            }
            ((ArrayList)arrayList3.get(arrayList.indexOf(geometry))).add(linearRing);
        }
        Polygon[] polygonArray = new Polygon[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            polygonArray[i] = geometryFactory.createPolygon((LinearRing)arrayList.get(i), ((ArrayList)arrayList3.get(i)).toArray(new LinearRing[0]));
        }
        if (polygonArray.length == 1) {
            return polygonArray[0];
        }
        arrayList3 = null;
        arrayList = null;
        arrayList2 = null;
        MultiPolygon multiPolygon = geometryFactory.createMultiPolygon(polygonArray);
        return multiPolygon;
    }

    public void write(Geometry geometry, EndianDataOutputStream endianDataOutputStream) throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        MultiPolygon multiPolygon = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        endianDataOutputStream.writeIntLE(this.getShapeType());
        Envelope envelope = multiPolygon.getEnvelopeInternal();
        endianDataOutputStream.writeDoubleLE(envelope.getMinX());
        endianDataOutputStream.writeDoubleLE(envelope.getMinY());
        endianDataOutputStream.writeDoubleLE(envelope.getMaxX());
        endianDataOutputStream.writeDoubleLE(envelope.getMaxY());
        int n5 = 0;
        for (n4 = 0; n4 < multiPolygon.getNumGeometries(); ++n4) {
            object = (Polygon)multiPolygon.getGeometryN(n4);
            n5 = n5 + 1 + ((Polygon)object).getNumInteriorRing();
        }
        n4 = 0;
        object = new int[n5];
        for (n3 = 0; n3 < multiPolygon.getNumGeometries(); ++n3) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n3);
            object[n4] = polygon.getExteriorRing().getNumPoints();
            ++n4;
            for (n2 = 0; n2 < polygon.getNumInteriorRing(); ++n2) {
                object[n4] = polygon.getInteriorRingN(n2).getNumPoints();
                ++n4;
            }
        }
        n3 = multiPolygon.getNumPoints();
        endianDataOutputStream.writeIntLE(n5);
        endianDataOutputStream.writeIntLE(n3);
        int n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            endianDataOutputStream.writeIntLE(n6);
            n6 += object[n2];
        }
        Coordinate[] coordinateArray = multiPolygon.getCoordinates();
        int n7 = Array.getLength(coordinateArray);
        for (n = 0; n < n7; ++n) {
            endianDataOutputStream.writeDoubleLE(coordinateArray[n].x);
            endianDataOutputStream.writeDoubleLE(coordinateArray[n].y);
        }
        if (this.myShapeType == 15) {
            double[] dArray = this.zMinMax(multiPolygon);
            if (Double.isNaN(dArray[0])) {
                endianDataOutputStream.writeDoubleLE(0.0);
                endianDataOutputStream.writeDoubleLE(0.0);
            } else {
                endianDataOutputStream.writeDoubleLE(dArray[0]);
                endianDataOutputStream.writeDoubleLE(dArray[1]);
            }
            for (int i = 0; i < n3; ++i) {
                double d = coordinateArray[i].z;
                if (Double.isNaN(d)) {
                    endianDataOutputStream.writeDoubleLE(0.0);
                    continue;
                }
                endianDataOutputStream.writeDoubleLE(d);
            }
        }
        if (this.myShapeType >= 15) {
            endianDataOutputStream.writeDoubleLE(-1.0E41);
            endianDataOutputStream.writeDoubleLE(-1.0E41);
            for (n = 0; n < n3; ++n) {
                endianDataOutputStream.writeDoubleLE(-1.0E41);
            }
        }
    }

    public int getShapeType() {
        return this.myShapeType;
    }

    public int getLength(Geometry geometry) {
        int n;
        MultiPolygon multiPolygon = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : new MultiPolygon(new Polygon[]{(Polygon)geometry}, geometry.getPrecisionModel(), geometry.getSRID());
        int n2 = 0;
        for (n = 0; n < multiPolygon.getNumGeometries(); ++n) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
            n2 = n2 + 1 + polygon.getNumInteriorRing();
        }
        n = multiPolygon.getNumPoints();
        if (this.myShapeType == 15) {
            return 22 + 2 * n2 + 8 * n + 4 * n + 8 + 4 * n + 8;
        }
        if (this.myShapeType == 25) {
            return 22 + 2 * n2 + 8 * n + 4 * n + 8;
        }
        return 22 + 2 * n2 + 8 * n;
    }

    double[] zMinMax(Geometry geometry) {
        boolean bl = false;
        Coordinate[] coordinateArray = geometry.getCoordinates();
        double[] dArray = new double[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        for (int i = 0; i < coordinateArray.length; ++i) {
            double d3 = coordinateArray[i].z;
            if (Double.isNaN(d3)) continue;
            if (bl) {
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                continue;
            }
            bl = true;
            d = d3;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }
}

