/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.fop.pdf.PDFObject;

public class PDFInfo
extends PDFObject {
    private String producer;
    private String title = null;
    private String author = null;
    private String subject = null;
    private String keywords = null;
    private Date creationDate = null;
    private String creator;

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String k) {
        this.keywords = k;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public byte[] toPDF() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFInfo.encode(this.getObjectID()));
            bout.write(PDFInfo.encode("<< /Type /Info\n"));
            if (this.title != null) {
                bout.write(PDFInfo.encode("/Title "));
                bout.write(this.encodeText(this.title));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.author != null) {
                bout.write(PDFInfo.encode("/Author "));
                bout.write(this.encodeText(this.author));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.subject != null) {
                bout.write(PDFInfo.encode("/Subject "));
                bout.write(this.encodeText(this.subject));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.keywords != null) {
                bout.write(PDFInfo.encode("/Keywords "));
                bout.write(this.encodeText(this.keywords));
                bout.write(PDFInfo.encode("\n"));
            }
            if (this.creator != null) {
                bout.write(PDFInfo.encode("/Creator "));
                bout.write(this.encodeText(this.creator));
                bout.write(PDFInfo.encode("\n"));
            }
            bout.write(PDFInfo.encode("/Producer "));
            bout.write(this.encodeText(this.producer));
            bout.write(PDFInfo.encode("\n"));
            if (this.creationDate == null) {
                this.creationDate = new Date();
            }
            bout.write(PDFInfo.encode("/CreationDate "));
            bout.write(this.encodeString(this.formatDateTime(this.creationDate)));
            bout.write(PDFInfo.encode("\n>>\nendobj\n"));
        }
        catch (IOException ioe) {
            log.error((Object)"Ignored I/O exception", (Throwable)ioe);
        }
        return bout.toByteArray();
    }
}

