/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.xml.XMLXMLHandler;
import org.apache.fop.util.XMLizable;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XMLRenderer
extends PrintRenderer {
    public static final String XML_MIME_TYPE = "application/X-fop-areatree";
    public static final String NS = "";
    public static final String CDATA = "CDATA";
    public static final Attributes EMPTY_ATTS = new AttributesImpl();
    private boolean startedSequence = false;
    private RendererContext context;
    protected Renderer mimic;
    protected ContentHandler handler;
    protected AttributesImpl atts = new AttributesImpl();
    protected OutputStream out;
    protected List extensionAttachments;
    static /* synthetic */ Class class$org$apache$fop$area$Trait$Background;

    public XMLRenderer() {
        this.context = new RendererContext(this, XML_MIME_TYPE);
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        XMLXMLHandler xmlHandler = new XMLXMLHandler();
        this.userAgent.getXMLHandlerRegistry().addXMLHandler(xmlHandler);
    }

    public void mimicRenderer(Renderer renderer) {
        this.mimic = renderer;
    }

    public void setupFontInfo(FontInfo inFontInfo) {
        if (this.mimic != null) {
            this.mimic.setupFontInfo(inFontInfo);
        } else {
            super.setupFontInfo(inFontInfo);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    private boolean isCoarseXml() {
        return (Boolean)this.userAgent.getRendererOptions().get("fineDetail");
    }

    protected void handleSAXException(SAXException saxe) {
        throw new RuntimeException(saxe.getMessage());
    }

    protected void comment(String comment) {
        if (this.handler instanceof LexicalHandler) {
            try {
                ((LexicalHandler)((Object)this.handler)).comment(comment.toCharArray(), 0, comment.length());
            }
            catch (SAXException saxe) {
                this.handleSAXException(saxe);
            }
        }
    }

    protected void startElement(String tagName) {
        this.startElement(tagName, EMPTY_ATTS);
    }

    protected void startElement(String tagName, Attributes atts) {
        try {
            this.handler.startElement(NS, tagName, tagName, atts);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void endElement(String tagName) {
        try {
            this.handler.endElement(NS, tagName, tagName);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void characters(String text) {
        try {
            char[] ca = text.toCharArray();
            this.handler.characters(ca, 0, ca.length);
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
    }

    protected void addAttribute(String name, String value) {
        this.atts.addAttribute(NS, name, name, CDATA, value);
    }

    protected void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    protected void addAttribute(String name, Rectangle2D rect) {
        this.addAttribute(name, this.createString(rect));
    }

    protected void addAreaAttributes(Area area) {
        this.addAttribute("ipd", area.getIPD());
        this.addAttribute("bpd", area.getBPD());
        if (area.getIPD() != 0) {
            this.addAttribute("ipda", area.getAllocIPD());
        }
        if (area.getBPD() != 0) {
            this.addAttribute("bpda", area.getAllocBPD());
        }
        this.addAttribute("bap", area.getBorderAndPaddingWidthStart() + " " + area.getBorderAndPaddingWidthEnd() + " " + area.getBorderAndPaddingWidthBefore() + " " + area.getBorderAndPaddingWidthAfter());
    }

    /*
     * WARNING - void declaration
     */
    protected void addTraitAttributes(Area area) {
        Map traitMap = area.getTraits();
        if (traitMap != null) {
            Iterator iter = traitMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry traitEntry = iter.next();
                Object key = traitEntry.getKey();
                String name = Trait.getTraitName(key);
                Class clazz = Trait.getTraitClass(key);
                if ("break-before".equals(name) || "break-after".equals(name)) continue;
                Object value = traitEntry.getValue();
                if (key == Trait.FONT) {
                    FontTriplet triplet = (FontTriplet)value;
                    this.addAttribute("font-name", triplet.getName());
                    this.addAttribute("font-style", triplet.getStyle());
                    this.addAttribute("font-weight", triplet.getWeight());
                    continue;
                }
                if (clazz.equals(class$org$apache$fop$area$Trait$Background == null ? XMLRenderer.class$("org.apache.fop.area.Trait$Background") : class$org$apache$fop$area$Trait$Background)) {
                    void var10_10;
                    Trait.Background bkg = (Trait.Background)value;
                    this.addAttribute(name, bkg.toString());
                    if (bkg.getColor() != null) {
                        this.addAttribute("bkg-color", bkg.getColor().toString());
                    }
                    if (bkg.getURL() == null) continue;
                    this.addAttribute("bkg-img", bkg.getURL());
                    int repeat = bkg.getRepeat();
                    switch (repeat) {
                        case 112: {
                            String repString = "repeat";
                            break;
                        }
                        case 113: {
                            String repString = "repeat-x";
                            break;
                        }
                        case 114: {
                            String repString = "repeat-y";
                            break;
                        }
                        case 96: {
                            String repString = "no-repeat";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal value for repeat encountered: " + repeat);
                        }
                    }
                    this.addAttribute("bkg-repeat", (String)var10_10);
                    this.addAttribute("bkg-horz-offset", bkg.getHoriz());
                    this.addAttribute("bkg-vert-offset", bkg.getVertical());
                    continue;
                }
                if (key == Trait.START_INDENT || key == Trait.END_INDENT) {
                    if ((Integer)value == 0) continue;
                    this.addAttribute(name, value.toString());
                    continue;
                }
                this.addAttribute(name, value.toString());
            }
        }
    }

    private String createString(Rectangle2D rect) {
        return NS + (int)rect.getX() + " " + (int)rect.getY() + " " + (int)rect.getWidth() + " " + (int)rect.getHeight();
    }

    private void handleDocumentExtensionAttachments() {
        if (this.extensionAttachments != null && this.extensionAttachments.size() > 0) {
            this.handleExtensionAttachments(this.extensionAttachments);
            this.extensionAttachments.clear();
        }
    }

    public void processOffDocumentItem(OffDocumentItem oDI) {
        if (oDI instanceof OffDocumentExtensionAttachment) {
            ExtensionAttachment attachment = ((OffDocumentExtensionAttachment)oDI).getAttachment();
            if (this.extensionAttachments == null) {
                this.extensionAttachments = new ArrayList();
            }
            this.extensionAttachments.add(attachment);
        } else {
            String warn = "Ignoring OffDocumentItem: " + oDI;
            log.warn((Object)warn);
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug((Object)"Rendering areas to Area Tree XML");
        if (this.handler == null) {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            try {
                TransformerHandler transformerHandler = factory.newTransformerHandler();
                this.handler = transformerHandler;
                StreamResult res = new StreamResult(outputStream);
                transformerHandler.setResult(res);
            }
            catch (TransformerConfigurationException tce) {
                throw new RuntimeException(tce.getMessage());
            }
            this.out = outputStream;
        }
        try {
            this.handler.startDocument();
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
        if (this.userAgent.getProducer() != null) {
            this.comment("Produced by " + this.userAgent.getProducer());
        }
        this.startElement("areaTree");
    }

    public void stopRenderer() throws IOException {
        if (this.startedSequence) {
            this.endElement("pageSequence");
        }
        this.endElement("areaTree");
        try {
            this.handler.endDocument();
        }
        catch (SAXException saxe) {
            this.handleSAXException(saxe);
        }
        if (this.out != null) {
            this.out.flush();
        }
        log.debug((Object)"Written out Area Tree XML");
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.atts.clear();
        this.addAttribute("bounds", page.getViewArea());
        this.addAttribute("nr", page.getPageNumber());
        this.addAttribute("formatted-nr", page.getPageNumberString());
        this.addAttribute("simple-page-master-name", page.getSimplePageMasterName());
        if (page.isBlank()) {
            this.addAttribute("blank", "true");
        }
        this.startElement("pageViewport", this.atts);
        this.startElement("page");
        this.handlePageExtensionAttachments(page);
        super.renderPage(page);
        this.endElement("page");
        this.endElement("pageViewport");
    }

    private void handleExtensionAttachments(List attachments) {
        if (attachments != null && attachments.size() > 0) {
            this.startElement("extension-attachments");
            Iterator i = attachments.iterator();
            while (i.hasNext()) {
                ExtensionAttachment attachment = (ExtensionAttachment)i.next();
                if (attachment instanceof XMLizable) {
                    try {
                        ((XMLizable)((Object)attachment)).toSAX(this.handler);
                    }
                    catch (SAXException e) {
                        log.error((Object)"Error while serializing Extension Attachment", (Throwable)e);
                    }
                    continue;
                }
                String warn = "Ignoring non-XMLizable ExtensionAttachment: " + attachment;
                log.warn((Object)warn);
            }
            this.endElement("extension-attachments");
        }
    }

    private void handlePageExtensionAttachments(PageViewport page) {
        this.handleExtensionAttachments(page.getExtensionAttachments());
    }

    public void startPageSequence(LineArea seqTitle) {
        this.handleDocumentExtensionAttachments();
        if (this.startedSequence) {
            this.endElement("pageSequence");
        }
        this.startedSequence = true;
        this.startElement("pageSequence");
        if (seqTitle != null) {
            this.startElement("title");
            List children = seqTitle.getInlineAreas();
            for (int count = 0; count < children.size(); ++count) {
                InlineArea inline = (InlineArea)children.get(count);
                this.renderInlineArea(inline);
            }
            this.endElement("title");
        }
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.atts.clear();
            this.addAreaAttributes(port);
            this.addTraitAttributes(port);
            this.addAttribute("rect", port.getViewArea());
            if (port.isClip()) {
                this.addAttribute("clipped", "true");
            }
            this.startElement("regionViewport", this.atts);
            RegionReference region = port.getRegionReference();
            this.atts.clear();
            this.addAreaAttributes(region);
            this.addTraitAttributes(region);
            this.addAttribute("name", region.getRegionName());
            this.addAttribute("ctm", region.getCTM().toString());
            if (region.getRegionClass() == 35) {
                this.startElement("regionBefore", this.atts);
                this.renderRegion(region);
                this.endElement("regionBefore");
            } else if (region.getRegionClass() == 38) {
                this.startElement("regionStart", this.atts);
                this.renderRegion(region);
                this.endElement("regionStart");
            } else if (region.getRegionClass() == 36) {
                BodyRegion body = (BodyRegion)region;
                if (body.getColumnCount() != 1) {
                    this.addAttribute("columnGap", body.getColumnGap());
                    this.addAttribute("columnCount", body.getColumnCount());
                }
                this.startElement("regionBody", this.atts);
                this.renderBodyRegion(body);
                this.endElement("regionBody");
            } else if (region.getRegionClass() == 37) {
                this.startElement("regionEnd", this.atts);
                this.renderRegion(region);
                this.endElement("regionEnd");
            } else if (region.getRegionClass() == 34) {
                this.startElement("regionAfter", this.atts);
                this.renderRegion(region);
                this.endElement("regionAfter");
            }
            this.endElement("regionViewport");
        }
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
    }

    protected void endVParea() {
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        this.startElement("beforeFloat");
        super.renderBeforeFloat(bf);
        this.endElement("beforeFloat");
    }

    protected void renderFootnote(Footnote footnote) {
        this.startElement("footnote");
        super.renderFootnote(footnote);
        this.endElement("footnote");
    }

    protected void renderMainReference(MainReference mr) {
        this.atts.clear();
        this.addAreaAttributes(mr);
        this.addTraitAttributes(mr);
        if (mr.getColumnCount() != 1) {
            this.addAttribute("columnGap", mr.getColumnGap());
        }
        this.startElement("mainReference", this.atts);
        Span span = null;
        List spans = mr.getSpans();
        for (int count = 0; count < spans.size(); ++count) {
            span = (Span)spans.get(count);
            this.atts.clear();
            if (span.getColumnCount() != 1) {
                this.addAttribute("columnCount", span.getColumnCount());
            }
            this.addAreaAttributes(span);
            this.addTraitAttributes(span);
            this.startElement("span", this.atts);
            for (int c = 0; c < span.getColumnCount(); ++c) {
                NormalFlow flow = span.getNormalFlow(c);
                this.renderFlow(flow);
            }
            this.endElement("span");
        }
        this.endElement("mainReference");
    }

    protected void renderFlow(NormalFlow flow) {
        this.atts.clear();
        this.addAreaAttributes(flow);
        this.addTraitAttributes(flow);
        this.startElement("flow", this.atts);
        super.renderFlow(flow);
        this.endElement("flow");
    }

    protected void renderBlock(Block block) {
        this.atts.clear();
        this.addAreaAttributes(block);
        this.addTraitAttributes(block);
        int positioning = block.getPositioning();
        if (block instanceof BlockViewport) {
            BlockViewport bvp = (BlockViewport)block;
            boolean abspos = false;
            if (bvp.getPositioning() == 2 || bvp.getPositioning() == 3) {
                abspos = true;
            }
            if (abspos) {
                this.addAttribute("left-position", bvp.getXOffset());
                this.addAttribute("top-position", bvp.getYOffset());
            }
            this.addAttribute("ctm", bvp.getCTM().toString());
            if (bvp.getClip()) {
                this.addAttribute("clipped", "true");
            }
        } else {
            if (block.getXOffset() != 0) {
                this.addAttribute("left-offset", block.getXOffset());
            }
            if (block.getYOffset() != 0) {
                this.addAttribute("top-offset", block.getYOffset());
            }
        }
        switch (positioning) {
            case 1: {
                this.addAttribute("positioning", "relative");
                break;
            }
            case 2: {
                this.addAttribute("positioning", "absolute");
                break;
            }
            case 3: {
                this.addAttribute("positioning", "fixed");
                break;
            }
        }
        this.startElement("block", this.atts);
        super.renderBlock(block);
        this.endElement("block");
    }

    protected void renderLineArea(LineArea line) {
        this.atts.clear();
        this.addAreaAttributes(line);
        this.addTraitAttributes(line);
        this.startElement("lineArea", this.atts);
        super.renderLineArea(line);
        this.endElement("lineArea");
    }

    protected void renderViewport(Viewport viewport) {
        this.atts.clear();
        this.addAreaAttributes(viewport);
        this.addTraitAttributes(viewport);
        this.addAttribute("offset", viewport.getOffset());
        this.addAttribute("pos", viewport.getContentPosition());
        if (viewport.getClip()) {
            this.addAttribute("clip", "true");
        }
        this.startElement("viewport", this.atts);
        super.renderViewport(viewport);
        this.endElement("viewport");
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.atts.clear();
        this.addAreaAttributes(image);
        this.addTraitAttributes(image);
        this.addAttribute("url", image.getURL());
        this.startElement("image", this.atts);
        this.endElement("image");
    }

    public void renderContainer(Container cont) {
        this.startElement("container");
        super.renderContainer(cont);
        this.endElement("container");
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        this.atts.clear();
        this.addAreaAttributes(fo);
        this.addTraitAttributes(fo);
        String ns = fo.getNameSpace();
        this.addAttribute("ns", ns);
        this.startElement("foreignObject", this.atts);
        Document doc = fo.getDocument();
        this.context.setProperty("handler", this.handler);
        this.renderXML(this.context, doc, ns);
        this.endElement("foreignObject");
    }

    protected void renderCharacter(Character ch) {
        this.atts.clear();
        this.addAreaAttributes(ch);
        this.addTraitAttributes(ch);
        this.addAttribute("offset", ch.getOffset());
        this.addAttribute("baseline", ch.getBaselineOffset());
        this.startElement("char", this.atts);
        this.characters(ch.getChar());
        this.endElement("char");
    }

    protected void renderInlineSpace(Space space) {
        this.atts.clear();
        this.addAreaAttributes(space);
        this.addTraitAttributes(space);
        this.addAttribute("offset", space.getOffset());
        this.startElement("space", this.atts);
        this.endElement("space");
    }

    protected void renderText(TextArea text) {
        this.atts.clear();
        if (text.getTextWordSpaceAdjust() != 0) {
            this.addAttribute("twsadjust", text.getTextWordSpaceAdjust());
        }
        if (text.getTextLetterSpaceAdjust() != 0) {
            this.addAttribute("tlsadjust", text.getTextLetterSpaceAdjust());
        }
        this.addAttribute("offset", text.getOffset());
        this.addAttribute("baseline", text.getBaselineOffset());
        this.addAreaAttributes(text);
        this.addTraitAttributes(text);
        this.startElement("text", this.atts);
        super.renderText(text);
        this.endElement("text");
    }

    protected void renderWord(WordArea word) {
        this.atts.clear();
        this.addAttribute("offset", word.getOffset());
        this.startElement("word", this.atts);
        this.characters(word.getWord());
        this.endElement("word");
        super.renderWord(word);
    }

    protected void renderSpace(SpaceArea space) {
        this.atts.clear();
        this.addAttribute("offset", space.getOffset());
        this.startElement("space", this.atts);
        this.characters(space.getSpace());
        this.endElement("space");
        super.renderSpace(space);
    }

    protected void renderInlineParent(InlineParent ip) {
        this.atts.clear();
        this.addAreaAttributes(ip);
        this.addTraitAttributes(ip);
        this.addAttribute("offset", ip.getOffset());
        this.startElement("inlineparent", this.atts);
        super.renderInlineParent(ip);
        this.endElement("inlineparent");
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        this.atts.clear();
        this.addAreaAttributes(ibp);
        this.addTraitAttributes(ibp);
        this.addAttribute("offset", ibp.getOffset());
        this.startElement("inlineblockparent", this.atts);
        super.renderInlineBlockParent(ibp);
        this.endElement("inlineblockparent");
    }

    protected void renderLeader(Leader area) {
        this.atts.clear();
        this.addAreaAttributes(area);
        this.addTraitAttributes(area);
        this.addAttribute("offset", area.getOffset());
        this.addAttribute("ruleStyle", area.getRuleStyleAsString());
        this.addAttribute("ruleThickness", area.getRuleThickness());
        this.startElement("leader", this.atts);
        this.endElement("leader");
        super.renderLeader(area);
    }

    public String getMimeType() {
        return XML_MIME_TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

