/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.layout.Layout;
import gj.layout.LayoutRenderer;
import gj.layout.tree.TreeLayout;
import gj.model.Graph;
import gj.model.Node;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Iterator;

public class TreeLayoutRenderer
implements LayoutRenderer {
    public void render(Graph graph, Layout layout, Graphics2D graphics) {
        if (!(layout instanceof TreeLayout)) {
            return;
        }
        TreeLayout tlayout = (TreeLayout)layout;
        if (tlayout.appliedTo != graph) {
            return;
        }
        Node root = tlayout.getRoot();
        if (root != null && graph.getNodes().contains(root)) {
            this.emphasize(root, Color.green, graphics);
        }
        if (tlayout.isDebug()) {
            graphics.setColor(Color.lightGray);
            Iterator it = tlayout.debugShapes.iterator();
            while (it.hasNext()) {
                Shape shape = (Shape)it.next();
                graphics.draw(shape);
            }
        }
    }

    private void emphasize(Node node, Color color, Graphics2D graphics) {
        Shape shape = node.getShape();
        if (shape == null) {
            return;
        }
        graphics.setColor(color);
        AffineTransform old = graphics.getTransform();
        graphics.translate(node.getPosition().getX(), node.getPosition().getY());
        graphics.scale(1.1, 1.1);
        graphics.draw(shape);
        graphics.setTransform(old);
    }
}

