/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.EventListenerInitializer;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    public static final String INLINE_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.inline.script.description";
    public static final String EVENT_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.event.script.description";
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;
    protected Set languages = new HashSet();
    protected Interpreter interpreter;

    public static boolean isDynamicDocument(BridgeContext bridgeContext, Document document) {
        Element element = document.getDocumentElement();
        if (element != null && "http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(bridgeContext, document.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(BridgeContext bridgeContext, Element element) {
        List list = bridgeContext.getBridgeExtensions(element.getOwnerDocument());
        return BaseScriptingEnvironment.isDynamicElement(element, bridgeContext, list);
    }

    public static boolean isDynamicElement(Element element, BridgeContext bridgeContext, List list) {
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (BridgeExtension)iterator.next();
            if (!object.isDynamicElement(element)) continue;
            return true;
        }
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (element.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
        }
        object = element.getFirstChild();
        while (object != null) {
            if (object.getNodeType() == 1 && BaseScriptingEnvironment.isDynamicElement(bridgeContext, (Element)object)) {
                return true;
            }
            object = object.getNextSibling();
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext bridgeContext) {
        this.bridgeContext = bridgeContext;
        this.document = bridgeContext.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interpreter, String string) {
        return new Window(interpreter, string);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public Interpreter getInterpreter() {
        if (this.interpreter != null) {
            return this.interpreter;
        }
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        return this.getInterpreter(string);
    }

    public Interpreter getInterpreter(String string) {
        this.interpreter = this.bridgeContext.getInterpreter(string);
        if (this.interpreter == null) {
            if (this.languages.contains(string)) {
                return null;
            }
            this.languages.add(string);
            return null;
        }
        if (!this.languages.contains(string)) {
            this.languages.add(string);
            this.initializeEnvironment(this.interpreter, string);
        }
        return this.interpreter;
    }

    public void initializeEnvironment(Interpreter interpreter, String string) {
        interpreter.bindObject("window", (Object)this.createWindow(interpreter, string));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            block25: {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string;
                String string2;
                Element element = (Element)nodeList.item(n2);
                String string3 = element.getAttributeNS(null, "type");
                if (string3.length() == 0) {
                    string3 = "text/ecmascript";
                }
                if (string3.equals("application/java-archive")) {
                    try {
                        string2 = XLinkSupport.getXLinkHref((Element)element);
                        string = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)element), string2);
                        this.checkCompatibleScriptURL(string3, (ParsedURL)string);
                        object5 = null;
                        try {
                            object5 = new URL(this.docPURL.toString());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        object4 = new DocumentJarClassLoader(new URL(string.toString()), (URL)object5);
                        object3 = ((URLClassLoader)object4).findResource("META-INF/MANIFEST.MF");
                        if (object3 != null) {
                            ScriptHandler scriptHandler;
                            object2 = new Manifest(((URL)object3).openStream());
                            object = ((Manifest)object2).getMainAttributes().getValue("Script-Handler");
                            if (object != null) {
                                scriptHandler = (ScriptHandler)((ClassLoader)object4).loadClass((String)object).newInstance();
                                if (window == null) {
                                    window = this.createWindow();
                                }
                                scriptHandler.run(this.document, window);
                            }
                            if ((object = ((Manifest)object2).getMainAttributes().getValue("SVG-Handler-Class")) != null) {
                                scriptHandler = (EventListenerInitializer)((ClassLoader)object4).loadClass((String)object).newInstance();
                                if (window == null) {
                                    window = this.createWindow();
                                }
                                scriptHandler.initializeEventListeners((SVGDocument)this.document);
                            }
                        }
                        break block25;
                    }
                    catch (Exception exception) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(exception);
                        }
                        break block25;
                    }
                }
                string2 = this.getInterpreter(string3);
                if (string2 != null) {
                    try {
                        string = XLinkSupport.getXLinkHref((Element)element);
                        object4 = null;
                        if (string.length() > 0) {
                            object4 = string;
                            object3 = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)element), string);
                            this.checkCompatibleScriptURL(string3, (ParsedURL)object3);
                            object5 = new InputStreamReader(object3.openStream());
                        } else {
                            this.checkCompatibleScriptURL(string3, this.docPURL);
                            object3 = this.bridgeContext.getDocumentLoader();
                            object2 = element;
                            object = (SVGDocument)object2.getOwnerDocument();
                            int n3 = ((DocumentLoader)object3).getLineNumber(element);
                            object4 = Messages.formatMessage(INLINE_SCRIPT_DESCRIPTION, new Object[]{object.getURL(), "<" + element.getNodeName() + ">", new Integer(n3)});
                            Node node = element.getFirstChild();
                            if (node == null) break block25;
                            StringBuffer stringBuffer = new StringBuffer();
                            while (node != null) {
                                if (node.getNodeType() == 4 || node.getNodeType() == 3) {
                                    stringBuffer.append(node.getNodeValue());
                                }
                                node = node.getNextSibling();
                            }
                            object5 = new StringReader(stringBuffer.toString());
                        }
                        string2.evaluate((Reader)object5, (String)object4);
                    }
                    catch (IOException iOException) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(iOException);
                        }
                        return;
                    }
                    catch (InterpreterException interpreterException) {
                        System.err.println("InterpExcept: " + (Object)((Object)interpreterException));
                        this.handleInterpreterException(interpreterException);
                        return;
                    }
                    catch (SecurityException securityException) {
                        if (this.userAgent == null) break block25;
                        this.userAgent.displayError(securityException);
                    }
                }
            }
            ++n2;
        }
    }

    protected void checkCompatibleScriptURL(String string, ParsedURL parsedURL) {
        this.userAgent.checkLoadScript(string, parsedURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        String string = sVGSVGElement.getContentScriptType();
        this.dispatchSVGLoad((Element)sVGSVGElement, true, string);
    }

    protected void dispatchSVGLoad(Element element, boolean bl, String string) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.dispatchSVGLoad((Element)node, bl, string);
            }
            node = node.getNextSibling();
        }
        DocumentEvent documentEvent = (DocumentEvent)((Object)element.getOwnerDocument());
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent("SVGLoad", false, false);
        EventTarget eventTarget = (EventTarget)((Object)element);
        final String string2 = element.getAttributeNS(null, "onload");
        if (string2.length() == 0) {
            eventTarget.dispatchEvent(event);
            return;
        }
        final Interpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            eventTarget.dispatchEvent(event);
            return;
        }
        if (bl) {
            this.checkCompatibleScriptURL(string, this.docPURL);
            bl = false;
        }
        DocumentLoader documentLoader = this.bridgeContext.getDocumentLoader();
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        int n = documentLoader.getLineNumber(element);
        final String string3 = Messages.formatMessage(EVENT_SCRIPT_DESCRIPTION, new Object[]{sVGDocument.getURL(), "onload", new Integer(n)});
        EventListener eventListener = new EventListener(){

            public void handleEvent(Event event) {
                try {
                    interpreter.bindObject(BaseScriptingEnvironment.EVENT_NAME, (Object)event);
                    interpreter.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, (Object)event);
                    interpreter.evaluate((Reader)new StringReader(string2), string3);
                }
                catch (IOException iOException) {
                }
                catch (InterpreterException interpreterException) {
                    BaseScriptingEnvironment.this.handleInterpreterException(interpreterException);
                }
            }
        };
        eventTarget.addEventListener("SVGLoad", eventListener, false);
        eventTarget.dispatchEvent(event);
        eventTarget.removeEventListener("SVGLoad", eventListener, false);
    }

    protected void dispatchSVGZoomEvent() {
        this.dispatchSVGDocEvent("SVGZoom");
    }

    protected void dispatchSVGScrollEvent() {
        this.dispatchSVGDocEvent("SVGScroll");
    }

    protected void dispatchSVGResizeEvent() {
        this.dispatchSVGDocEvent("SVGResize");
    }

    protected void dispatchSVGDocEvent(String string) {
        SVGSVGElement sVGSVGElement;
        SVGSVGElement sVGSVGElement2 = sVGSVGElement = (SVGSVGElement)this.document.getDocumentElement();
        DocumentEvent documentEvent = (DocumentEvent)((Object)this.document);
        Event event = documentEvent.createEvent("SVGEvents");
        event.initEvent(string, false, false);
        sVGSVGElement2.dispatchEvent(event);
    }

    protected void handleInterpreterException(InterpreterException interpreterException) {
        if (this.userAgent != null) {
            Exception exception = interpreterException.getException();
            this.userAgent.displayError((Exception)(exception == null ? interpreterException : exception));
        }
    }

    protected void handleSecurityException(SecurityException securityException) {
        if (this.userAgent != null) {
            this.userAgent.displayError(securityException);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interpreter, String string) {
            this.interpreter = interpreter;
            this.language = string;
        }

        public Object setInterval(String string, long l) {
            return null;
        }

        public Object setInterval(Runnable runnable, long l) {
            return null;
        }

        public void clearInterval(Object object) {
        }

        public Object setTimeout(String string, long l) {
            return null;
        }

        public Object setTimeout(Runnable runnable, long l) {
            return null;
        }

        public void clearTimeout(Object object) {
        }

        public Node parseXML(String string, Document document) {
            return null;
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler) {
            this.getURL(string, uRLResponseHandler, "UTF8");
        }

        public void getURL(String string, Window.URLResponseHandler uRLResponseHandler, String string2) {
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler) {
            this.postURL(string, string2, uRLResponseHandler, "text/plain", null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3) {
            this.postURL(string, string2, uRLResponseHandler, string3, null);
        }

        public void postURL(String string, String string2, Window.URLResponseHandler uRLResponseHandler, String string3, String string4) {
        }

        public void alert(String string) {
        }

        public boolean confirm(String string) {
            return false;
        }

        public String prompt(String string) {
            return null;
        }

        public String prompt(String string, String string2) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

