/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.ActionAbout;
import genj.app.ActionOptions;
import genj.app.GedcomDockable;
import genj.app.Menu;
import genj.app.PluginFactory;
import genj.app.Priority;
import genj.app.StatusBar;
import genj.app.Toolbar;
import genj.app.ViewDockable;
import genj.app.WorkbenchListener;
import genj.common.ContextListWidget;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Submitter;
import genj.gedcom.UnitOfWork;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomIOException;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.GedcomReaderFactory;
import genj.io.GedcomWriter;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.SafeProxy;
import genj.util.ServiceLookup;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import genj.util.swing.FileChooser;
import genj.util.swing.ImageIcon;
import genj.util.swing.MacAdapter;
import genj.view.SelectionSink;
import genj.view.View;
import genj.view.ViewContext;
import genj.view.ViewFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import spin.Spin;
import swingx.docking.DefaultDockable;
import swingx.docking.Dockable;
import swingx.docking.DockingPane;
import swingx.docking.dock.TabbedDock;
import swingx.docking.persistence.XMLPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbench
extends JPanel
implements SelectionSink {
    private static final ImageIcon IMG_CLOSE = new ImageIcon(Workbench.class, "images/Close.png");
    private static final ImageIcon IMG_NEW = new ImageIcon(Workbench.class, "images/New.png");
    private static final ImageIcon IMG_OPEN = new ImageIcon(Workbench.class, "images/Open.png");
    private static final ImageIcon IMG_EXIT = new ImageIcon(Workbench.class, "images/Exit.png");
    private static final ImageIcon IMG_SAVE = new ImageIcon(Workbench.class, "images/Save.png");
    private static final String ACC_SAVE = "ctrl S";
    private static final String ACC_NEW = "ctrl N";
    private static final String ACC_OPEN = "ctrl O";
    private static final String ACC_CLOSE = "ctrl W";
    static final Logger LOG = Logger.getLogger("genj.app");
    static final Resources RES = Resources.get(Workbench.class);
    static final Registry REGISTRY = Registry.get(Workbench.class);
    private List<WorkbenchListener> listeners = new CopyOnWriteArrayList<WorkbenchListener>();
    private List<Object> plugins = new ArrayList<Object>();
    private List<ViewFactory> viewFactories = ServiceLookup.lookup(ViewFactory.class);
    private Context context = new Context();
    private DockingPane dockingPane = new WorkbenchPane();
    private Menu menu = new Menu(this);
    private Toolbar toolbar = new Toolbar(this);
    private Runnable runOnExit;
    private StatusBar statusBar = new StatusBar(this);

    public Workbench(Runnable runnable) {
        this.runOnExit = runnable;
        LOG.info("loading plugins");
        for (PluginFactory pluginFactory : ServiceLookup.lookup(PluginFactory.class)) {
            LOG.info("Loading plugin " + pluginFactory.getClass());
            Object object = pluginFactory.createPlugin(this);
            this.plugins.add(object);
        }
        LOG.info("/loading plugins");
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.dockingPane, "Center");
        this.add((Component)this.statusBar, "South");
        new ActionCloseView();
        if (MacAdapter.isMac()) {
            MacAdapter.getInstance().setAboutListener(new ActionAbout());
            MacAdapter.getInstance().setQuitListener(new ActionExit());
            MacAdapter.getInstance().setPreferencesListener(new ActionOptions());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        DialogHelper.visitContainers(this, new DialogHelper.ComponentVisitor(){

            public Component visit(Component component, Component component2) {
                if (component instanceof JFrame) {
                    JFrame jFrame = (JFrame)component;
                    jFrame.setJMenuBar(Workbench.this.menu);
                    jFrame.getRootPane().putClientProperty(Workbench.class, Workbench.this);
                }
                return null;
            }
        });
    }

    @Override
    public void removeNotify() {
        DialogHelper.visitContainers(this, new DialogHelper.ComponentVisitor(){

            public Component visit(Component component, Component component2) {
                if (component instanceof JFrame) {
                    JFrame jFrame = (JFrame)component;
                    jFrame.setJMenuBar(null);
                    jFrame.getRootPane().putClientProperty(Workbench.class, null);
                }
                return null;
            }
        });
        super.removeNotify();
    }

    static Workbench getWorkbench(Component component) {
        Component component2 = DialogHelper.visitOwners(component, new DialogHelper.ComponentVisitor(){

            public Component visit(Component component, Component component2) {
                if (component instanceof Workbench) {
                    return (Workbench)component;
                }
                if (component instanceof View) {
                    ViewDockable viewDockable = (ViewDockable)((View)component).getClientProperty(ViewDockable.class);
                    return viewDockable.getWorkbench();
                }
                if (component instanceof JFrame) {
                    return (Workbench)((JFrame)component).getRootPane().getClientProperty(Workbench.class);
                }
                return null;
            }
        });
        return component2 instanceof Workbench ? (Workbench)component2 : null;
    }

    public void saveLayout(Writer writer) {
        new LayoutPersister(this.dockingPane, writer).save();
    }

    public void loadLayout(Reader reader) {
        new LayoutPersister(this.dockingPane, reader).load();
    }

    public Context getContext() {
        return this.context;
    }

    public void newGedcom() {
        Gedcom gedcom;
        int n;
        File file = this.chooseFile(RES.getString("cc.create.title"), RES.getString("cc.create.action"), null);
        if (file == null) {
            return;
        }
        if (!file.getName().endsWith(".ged")) {
            file = new File(file.getAbsolutePath() + ".ged");
        }
        if (file.exists() && (n = DialogHelper.openDialog(RES.getString("cc.create.title"), 2, RES.getString("cc.open.file_exists", file.getName()), (Action[])Action2.yesNo(), (Object)this)) != 0) {
            return;
        }
        if (!this.closeGedcom()) {
            return;
        }
        try {
            gedcom = new Gedcom(Origin.create(new URL("file:" + file.getAbsolutePath())));
            Submitter submitter = (Submitter)gedcom.createEntity("SUBM");
            submitter.setName(EnvironmentChecker.getProperty("user.name", "?", "user name used as submitter in new gedcom"));
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "unexpected exception creating new gedcom", throwable);
            return;
        }
        this.setGedcom(gedcom);
    }

    public boolean openGedcom() {
        File file = this.chooseFile(RES.getString("cc.open.title"), RES.getString("cc.open.action"), null);
        if (file == null) {
            return false;
        }
        REGISTRY.put("last.dir", file.getParentFile().getAbsolutePath());
        if (!this.closeGedcom()) {
            return false;
        }
        try {
            return this.openGedcom(new URL("file:" + file.getAbsolutePath()));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openGedcom(URL uRL) {
        GedcomReader gedcomReader;
        if (!this.closeGedcom()) {
            return false;
        }
        final Origin origin = Origin.create(uRL);
        final ArrayList arrayList = new ArrayList();
        try {
            gedcomReader = (GedcomReader)Spin.off((Object)GedcomReaderFactory.createReader(origin, (GedcomReaderContext)Spin.over((Object)new GedcomReaderContext(){

                public String getPassword() {
                    return DialogHelper.openDialog(origin.getName(), 3, RES.getString("cc.provide_password"), "", (Object)Workbench.this);
                }

                public void handleWarning(int n, String string, Context context) {
                    arrayList.add(new ViewContext(RES.getString("cc.open.warning", new Integer(n), string), context));
                }
            })));
        }
        catch (IOException iOException) {
            String string = RES.getString("cc.open.no_connect_to", origin) + "\n[" + iOException.getMessage() + "]";
            DialogHelper.openDialog(origin.getName(), 0, string, (Action[])Action2.okOnly(), (Object)this);
            return false;
        }
        try {
            for (WorkbenchListener workbenchListener : this.listeners) {
                workbenchListener.processStarted(this, gedcomReader);
            }
            this.setGedcom(gedcomReader.read());
            if (!arrayList.isEmpty()) {
                this.dockingPane.putDockable((Object)"warnings", (Dockable)new GedcomDockable(this, RES.getString("cc.open.warnings", this.context.getGedcom().getName()), IMG_OPEN, new JScrollPane(new ContextListWidget(arrayList))));
            }
        }
        catch (GedcomIOException gedcomIOException) {
            DialogHelper.openDialog(origin.getName(), 0, RES.getString("cc.open.read_error", "" + gedcomIOException.getLine()) + ":\n" + gedcomIOException.getMessage(), (Action[])Action2.okOnly(), (Object)this);
            boolean bl = false;
            return bl;
        }
        finally {
            for (WorkbenchListener workbenchListener : this.listeners) {
                workbenchListener.processStopped(this, gedcomReader);
            }
        }
        List<String> list = REGISTRY.get("history", new ArrayList<String>());
        list.remove(origin.toString());
        list.add(0, origin.toString());
        if (list.size() > 5) {
            list.remove(list.size() - 1);
        }
        REGISTRY.put("history", list);
        return true;
    }

    private void setGedcom(Gedcom gedcom) {
        if (this.context.getGedcom() != null) {
            throw new IllegalArgumentException("context.gedcom!=null");
        }
        try {
            this.context = Context.fromString(gedcom, REGISTRY.get(gedcom.getName() + ".context", gedcom.getName()));
        }
        catch (GedcomException gedcomException) {
            this.context = new Context(gedcom);
        }
        if (this.context.getEntity() == null) {
            Object object = null;
            if ("royal92.ged".equals(gedcom.getName())) {
                object = gedcom.getEntity("I65");
            }
            if (object == null) {
                object = gedcom.getFirstEntity("INDI");
            }
            this.context = new Context(gedcom, object != null ? Collections.singletonList(object) : null, null);
        }
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.gedcomOpened(this, gedcom);
        }
        this.fireSelection(this.context, true);
    }

    public boolean saveAsGedcom() {
        int n;
        if (this.context.getGedcom() == null) {
            return false;
        }
        this.fireCommit();
        Box box = new Box(1);
        box.add(new JLabel(RES.getString("save.options.encoding")));
        ChoiceWidget choiceWidget = new ChoiceWidget(Gedcom.ENCODINGS, "ANSEL");
        choiceWidget.setEditable(false);
        choiceWidget.setSelectedItem(this.context.getGedcom().getEncoding());
        box.add(choiceWidget);
        box.add(new JLabel(RES.getString("save.options.password")));
        File file = this.chooseFile(RES.getString("cc.save.title"), RES.getString("cc.save.action"), box);
        if (file == null) {
            return false;
        }
        if (file.exists() && (n = DialogHelper.openDialog(RES.getString("cc.save.title"), 2, RES.getString("cc.open.file_exists", file.getName()), (Action[])Action2.yesNo(), (Object)this)) != 0) {
            return false;
        }
        if (!file.getName().endsWith(".ged")) {
            file = new File(file.getAbsolutePath() + ".ged");
        }
        Gedcom gedcom = this.context.getGedcom();
        gedcom.setEncoding((String)choiceWidget.getSelectedItem());
        try {
            gedcom.setOrigin(Origin.create(new URL("file", "", file.getAbsolutePath())));
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINER, "Failed to create origin for file " + file, throwable);
            return false;
        }
        if (!this.saveGedcomImpl(gedcom)) {
            return false;
        }
        if (!this.closeGedcom()) {
            return false;
        }
        this.setGedcom(gedcom);
        return true;
    }

    public boolean saveGedcom() {
        if (this.context.getGedcom() == null) {
            return false;
        }
        this.fireCommit();
        return this.saveGedcomImpl(this.context.getGedcom());
    }

    private boolean saveGedcomImpl(Gedcom gedcom) {
        try {
            GedcomWriter gedcomWriter = null;
            File file = null;
            File file2 = null;
            try {
                file = gedcom.getOrigin().getFile().getCanonicalFile();
                file2 = File.createTempFile("genj", ".ged", file.getParentFile());
                gedcomWriter = new GedcomWriter(gedcom, new FileOutputStream(file2));
            }
            catch (GedcomEncodingException gedcomEncodingException) {
                DialogHelper.openDialog(gedcom.getName(), 0, RES.getString("cc.save.write_encoding_error", gedcomEncodingException.getMessage()), (Action[])Action2.okOnly(), (Object)this);
                return false;
            }
            catch (IOException iOException) {
                DialogHelper.openDialog(gedcom.getName(), 0, RES.getString("cc.save.open_error", gedcom.getOrigin().getFile().getAbsolutePath()), (Action[])Action2.okOnly(), (Object)this);
                return false;
            }
            gedcomWriter.write();
            if (file.exists()) {
                File file3 = new File(file.getAbsolutePath() + "~");
                if (file3.exists() && !file3.delete()) {
                    throw new GedcomIOException("Couldn't delete backup file " + file3.getName(), -1);
                }
                if (!file.renameTo(file3)) {
                    throw new GedcomIOException("Couldn't create backup for " + file.getName(), -1);
                }
            }
            if (!file2.renameTo(file)) {
                throw new GedcomIOException("Couldn't move temporary " + file2.getName() + " to " + file.getName(), -1);
            }
        }
        catch (GedcomIOException gedcomIOException) {
            DialogHelper.openDialog(gedcom.getName(), 0, RES.getString("cc.save.write_error", "" + gedcomIOException.getLine()) + ":\n" + gedcomIOException.getMessage(), (Action[])Action2.okOnly(), (Object)this);
            return false;
        }
        if (gedcom.hasChanged()) {
            gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    gedcom.setUnchanged();
                }
            });
        }
        return true;
    }

    public void exit() {
        if (this.context.getGedcom() != null) {
            REGISTRY.put("restore.url", this.context.getGedcom().getOrigin().toString());
        }
        if (!this.closeGedcom()) {
            return;
        }
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.workbenchClosing(this);
        }
        for (WorkbenchListener workbenchListener : this.dockingPane.getDockableKeys()) {
            this.dockingPane.removeDockable((Object)workbenchListener);
        }
        this.runOnExit.run();
    }

    public boolean closeGedcom() {
        if (this.context.getGedcom() == null) {
            return true;
        }
        this.fireCommit();
        if (this.context.getGedcom().hasChanged()) {
            int n = DialogHelper.openDialog(null, 2, RES.getString("cc.savechanges?", this.context.getGedcom().getName()), (Action[])Action2.yesNoCancel(), (Object)this);
            if (n == 2) {
                return false;
            }
            if (n == 0 && !this.saveGedcom()) {
                return false;
            }
        }
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.gedcomClosed(this, this.context.getGedcom());
        }
        REGISTRY.put(this.context.getGedcom().getName(), this.context.toString());
        this.context = new Context();
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.selectionChanged(this, this.context, true);
        }
        return true;
    }

    public void restoreGedcom() {
        String string = REGISTRY.get("restore.url", (String)null);
        try {
            if (string == null) {
                string = new File("gedcom/royal92.ged").toURL().toString();
            }
            if (string.length() > 0) {
                this.openGedcom(new URL(string));
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "unexpected error", throwable);
        }
    }

    public <T> List<T> getProviders(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.dockingPane.getDockableKeys()) {
            DefaultDockable defaultDockable;
            Dockable dockable = this.dockingPane.getDockable(object);
            if (!(dockable instanceof DefaultDockable) || !clazz.isAssignableFrom((defaultDockable = (DefaultDockable)dockable).getContent().getClass()) || arrayList.contains(defaultDockable.getContent())) continue;
            arrayList.add(defaultDockable.getContent());
        }
        for (Object object : this.plugins) {
            if (!clazz.isAssignableFrom(object.getClass()) || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        for (WorkbenchListener workbenchListener : this.listeners) {
            WorkbenchListener workbenchListener2 = SafeProxy.unwrap(workbenchListener);
            if (!clazz.isAssignableFrom(workbenchListener2.getClass()) || arrayList.contains(workbenchListener2)) continue;
            arrayList.add(workbenchListener2);
        }
        Collections.sort(arrayList, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                Priority priority = t.getClass().getAnnotation(Priority.class);
                Priority priority2 = t2.getClass().getAnnotation(Priority.class);
                int n = priority != null ? priority.priority() : 50;
                int n2 = priority2 != null ? priority2.priority() : 50;
                return n2 - n;
            }
        });
        return SafeProxy.harden(arrayList, LOG);
    }

    public void fireCommit() {
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.commitRequested(this);
        }
    }

    @Override
    public void fireSelection(Context context, boolean bl) {
        Object object;
        if (context.getGedcom() != this.context.getGedcom()) {
            LOG.log(Level.FINER, "context selection on unknown gedcom", new Throwable());
            return;
        }
        if (bl && context.getProperties().size() == 1 && (object = context.getProperty()) instanceof PropertyXRef) {
            context = new Context(((PropertyXRef)object).getTarget());
        }
        if (!bl && this.context.equals(context)) {
            return;
        }
        LOG.finer("fireSelection(" + context + "," + bl + ")");
        this.context = context;
        if (context.getGedcom() != null) {
            REGISTRY.put(context.getGedcom().getName() + ".context", context.toString());
        }
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.selectionChanged(this, context, bl);
        }
    }

    private void fireViewOpened(View view) {
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.viewOpened(this, view);
        }
    }

    private void fireViewClosed(View view) {
        for (WorkbenchListener workbenchListener : this.listeners) {
            workbenchListener.viewClosed(this, view);
        }
    }

    public void addWorkbenchListener(WorkbenchListener workbenchListener) {
        this.listeners.add(0, SafeProxy.harden(workbenchListener));
    }

    public void removeWorkbenchListener(WorkbenchListener workbenchListener) {
        this.listeners.remove(SafeProxy.harden(workbenchListener));
    }

    public List<? extends ViewFactory> getViewFactories() {
        return this.viewFactories;
    }

    public View getView(Class<? extends ViewFactory> clazz) {
        ViewDockable viewDockable = (ViewDockable)this.dockingPane.getDockable(clazz);
        return viewDockable != null ? viewDockable.getView() : null;
    }

    public void closeView(Class<? extends ViewFactory> clazz) {
        View view = this.getView(clazz);
        if (view == null) {
            return;
        }
        this.dockingPane.putDockable(clazz, null);
    }

    void closeDockable(Dockable dockable) {
        for (Object e : this.dockingPane.getDockableKeys()) {
            if (this.dockingPane.getDockable(e) != dockable) continue;
            this.dockingPane.putDockable(e, null);
        }
    }

    public View openView(Class<? extends ViewFactory> clazz) {
        return this.openView(clazz, this.context);
    }

    public View openView(Class<? extends ViewFactory> clazz, Context context) {
        for (ViewFactory viewFactory : this.viewFactories) {
            if (!viewFactory.getClass().equals(clazz)) continue;
            return this.openViewImpl(viewFactory, context);
        }
        throw new IllegalArgumentException("unknown factory");
    }

    private View openViewImpl(ViewFactory viewFactory, Context context) {
        ViewDockable viewDockable = (ViewDockable)this.dockingPane.getDockable(viewFactory.getClass());
        if (viewDockable != null) {
            this.dockingPane.putDockable(viewFactory.getClass(), (Dockable)viewDockable);
            return viewDockable.getView();
        }
        try {
            viewDockable = new ViewDockable(this, viewFactory);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "cannot open view for " + viewFactory.getClass().getName(), throwable);
            return null;
        }
        this.dockingPane.putDockable(viewFactory.getClass(), (Dockable)viewDockable);
        this.fireViewOpened(viewDockable.getView());
        return viewDockable.getView();
    }

    private File chooseFile(String string, String string2, JComponent jComponent) {
        FileChooser fileChooser = new FileChooser(this, string, string2, "ged", EnvironmentChecker.getProperty(new String[]{"genj.gedcom.dir", "user.home"}, ".", "choose gedcom file"));
        fileChooser.setCurrentDirectory(new File(REGISTRY.get("last.dir", "user.home")));
        if (jComponent != null) {
            fileChooser.setAccessory(jComponent);
        }
        if (0 != fileChooser.showDialog()) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        REGISTRY.put("last.dir", file.getParentFile().getAbsolutePath());
        return file;
    }

    private class WorkbenchPane
    extends DockingPane
    implements WorkbenchListener {
        private List<JDialog> dialogs = new ArrayList<JDialog>();

        public WorkbenchPane() {
            Workbench.this.addWorkbenchListener(this);
        }

        private void updateTitle(JDialog jDialog, String string) {
            jDialog.setTitle(string);
        }

        private void updateTitles(String string) {
            for (JDialog jDialog : this.dialogs) {
                this.updateTitle(jDialog, string);
            }
        }

        protected JDialog createDialog() {
            JDialog jDialog = super.createDialog();
            jDialog.setDefaultCloseOperation(2);
            if (Workbench.this.context.getGedcom() != null) {
                this.updateTitle(jDialog, Workbench.this.context.getGedcom() != null ? Workbench.this.context.getGedcom().getName() : "");
            }
            this.dialogs.add(jDialog);
            return jDialog;
        }

        protected void dismissDialog(JDialog jDialog) {
            super.dismissDialog(jDialog);
            this.dialogs.remove(jDialog);
        }

        public void commitRequested(Workbench workbench) {
        }

        protected Dockable createDockable(Object object) {
            for (ViewFactory viewFactory : Workbench.this.viewFactories) {
                if (!viewFactory.getClass().equals(object)) continue;
                ViewDockable viewDockable = new ViewDockable(Workbench.this, viewFactory);
                return viewDockable;
            }
            LOG.finer("can't find view factory for docking key" + object);
            return null;
        }

        protected void dismissDockable(Dockable dockable) {
            if (dockable instanceof ViewDockable) {
                ViewDockable viewDockable = (ViewDockable)dockable;
                viewDockable.dispose();
                Workbench.this.fireViewClosed(viewDockable.getView());
            }
        }

        public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
            this.updateTitles("");
        }

        public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
            this.updateTitles(gedcom.getName());
        }

        public void processStarted(Workbench workbench, Trackable trackable) {
        }

        public void processStopped(Workbench workbench, Trackable trackable) {
        }

        public void selectionChanged(Workbench workbench, Context context, boolean bl) {
        }

        public void viewClosed(Workbench workbench, View view) {
        }

        public void viewOpened(Workbench workbench, View view) {
        }

        public void workbenchClosing(Workbench workbench) {
        }
    }

    private class LayoutPersister
    extends XMLPersister {
        LayoutPersister(DockingPane dockingPane, Reader reader) {
            super(dockingPane, reader, "1");
        }

        LayoutPersister(DockingPane dockingPane, Writer writer) {
            super(dockingPane, writer, "1");
        }

        protected Object parseKey(String string) throws SAXParseException {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return string;
            }
        }

        protected String formatKey(Object object) throws SAXException {
            if (object instanceof String) {
                return (String)object;
            }
            return ((Class)object).getName();
        }

        public void load() {
            try {
                super.load();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "unable to load layout", exception);
            }
        }

        public void save() {
            try {
                super.save();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "unable to save layout", exception);
            }
        }
    }

    class ActionOpenView
    extends Action2 {
        private ViewFactory factory;

        ActionOpenView(ViewFactory viewFactory) {
            this.factory = viewFactory;
            this.setText(this.factory.getTitle());
            this.setTip(RES.getString("cc.tip.open_view", this.factory.getTitle()));
            this.setImage(this.factory.getImage());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Workbench.this.openViewImpl(this.factory, Workbench.this.context);
        }
    }

    private class ActionCloseView
    extends Action2 {
        public ActionCloseView() {
            this.install(Workbench.this, Workbench.ACC_CLOSE, 1);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogHelper.visitContainers(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), new DialogHelper.ComponentVisitor(){

                public Component visit(Component component, Component component2) {
                    if (component2 instanceof TabbedDock) {
                        ((ViewDockable)((TabbedDock)component2).getSelectedDockable()).close();
                        return component2;
                    }
                    if (component2 instanceof View) {
                        ViewDockable.getDockable((View)component2).close();
                        return component2;
                    }
                    return null;
                }
            });
        }
    }

    class ActionSave
    extends WorkbenchAction {
        private boolean saveAs;
        protected Gedcom gedcomBeingSaved;
        private GedcomWriter gedWriter;
        private Origin newOrigin;
        private Filter[] filters;
        private String progress;
        private GedcomIOException ioex;
        private File temp;
        private File file;
        private String password;

        ActionSave(boolean bl) {
            this.ioex = null;
            this.saveAs = bl;
            if (bl) {
                this.setText(RES.getString("cc.menu.saveas"));
            } else {
                this.setText(RES.getString("cc.menu.save"));
                this.install(Workbench.this, Workbench.ACC_SAVE, 2);
            }
            this.setTip(RES, "cc.tip.save_file");
            this.setImage(IMG_SAVE);
            this.setEnabled(Workbench.this.context.getGedcom() != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.saveAs) {
                Workbench.this.saveAsGedcom();
            } else {
                Workbench.this.saveGedcom();
            }
        }
    }

    class ActionOpen
    extends WorkbenchAction {
        private URL url;

        ActionOpen() {
            this.setTip(RES, "cc.tip.open_file");
            this.setText(RES, "cc.menu.open");
            this.setImage(IMG_OPEN);
            this.install(Workbench.this, Workbench.ACC_OPEN, 2);
        }

        protected ActionOpen(int n, URL uRL) {
            this.url = uRL;
            String string = (char)(49 + n) + " " + uRL.getFile();
            int n2 = string.indexOf(47);
            int n3 = string.lastIndexOf(47);
            if (n2 != n3) {
                string = string.substring(0, n2 + 1) + "..." + string.substring(n3);
            }
            this.setMnemonic(string.charAt(0));
            this.setText(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.url != null) {
                Workbench.this.openGedcom(this.url);
            } else {
                Workbench.this.openGedcom();
            }
        }
    }

    class ActionNew
    extends WorkbenchAction {
        ActionNew() {
            this.setText(RES, "cc.menu.new");
            this.setTip(RES, "cc.tip.create_file");
            this.setImage(IMG_NEW);
            this.install(Workbench.this, Workbench.ACC_NEW, 2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Workbench.this.newGedcom();
        }
    }

    class ActionClose
    extends WorkbenchAction {
        ActionClose() {
            this.setText(RES, "cc.menu.close");
            this.setImage(IMG_CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Workbench.this.closeGedcom();
        }
    }

    class ActionExit
    extends WorkbenchAction {
        ActionExit() {
            this.setText(RES, "cc.menu.exit");
            this.setImage(IMG_EXIT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Workbench.this.exit();
        }
    }

    private class WorkbenchAction
    extends Action2
    implements WorkbenchListener {
        private WorkbenchAction() {
        }

        public void commitRequested(Workbench workbench) {
        }

        public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
        }

        public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
        }

        public void selectionChanged(Workbench workbench, Context context, boolean bl) {
        }

        public void viewClosed(Workbench workbench, View view) {
        }

        public void viewOpened(Workbench workbench, View view) {
        }

        public void workbenchClosing(Workbench workbench) {
        }

        public void processStarted(Workbench workbench, Trackable trackable) {
            this.setEnabled(false);
        }

        public void processStopped(Workbench workbench, Trackable trackable) {
            this.setEnabled(true);
        }
    }
}

