/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.view.ContextProvider;
import genj.view.SelectionSink;
import genj.view.ViewContext;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextListWidget
extends JList
implements ContextProvider {
    private Gedcom gedcom;
    private Callback callback = new Callback();
    private List<? extends Context> contexts = new ArrayList<Context>();

    public ContextListWidget(List<? extends Context> list) {
        this.setModel(new Model(list));
        this.setSelectionMode(2);
        this.setCellRenderer(this.callback);
        this.addListSelectionListener(this.callback);
    }

    public List<? extends Context> getContexts() {
        return this.contexts;
    }

    @Override
    public ViewContext getContext() {
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length == 1 && objectArray[0] instanceof ViewContext) {
            return (ViewContext)objectArray[0];
        }
        ArrayList<? extends Property> arrayList = new ArrayList<Property>(16);
        ArrayList<? extends Entity> arrayList2 = new ArrayList<Entity>(16);
        for (int i = 0; i < objectArray.length; ++i) {
            Context context = (Context)objectArray[i];
            arrayList.addAll(context.getProperties());
            arrayList2.addAll(context.getEntities());
        }
        return new ViewContext(new Context(this.gedcom, arrayList2, arrayList));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.getModel()));
    }

    @Override
    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.getModel()));
        super.removeNotify();
    }

    private class Callback
    extends DefaultListCellRenderer
    implements ListSelectionListener {
        private Callback() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ViewContext viewContext = ContextListWidget.this.getContext();
            if (viewContext != null) {
                SelectionSink.Dispatcher.fireSelection(ContextListWidget.this, viewContext, false);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            if (object instanceof ViewContext) {
                ViewContext viewContext = (ViewContext)object;
                this.setIcon(viewContext.getImage());
                this.setText(viewContext.getText());
            } else {
                this.setIcon(Gedcom.getImage());
                this.setText(object.toString());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractListModel
    implements GedcomListener {
        private List<Context> list = new ArrayList<Context>();

        private Model(List<? extends Context> list) {
            for (Context context : list) {
                this.list.add(context);
                if (ContextListWidget.this.gedcom == null) {
                    ContextListWidget.this.gedcom = context.getGedcom();
                    continue;
                }
                if (ContextListWidget.this.gedcom == context.getGedcom()) continue;
                throw new IllegalArgumentException(ContextListWidget.this.gedcom + "!=" + context.getGedcom());
            }
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        @Override
        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        @Override
        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            ListIterator<Context> listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                Context context = listIterator.next();
                if (!context.getEntities().contains(entity)) continue;
                listIterator.set(new Context(context.getGedcom()));
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }

        @Override
        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
        }

        @Override
        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.fireContentsChanged(this, 0, this.list.size());
        }

        @Override
        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            ListIterator<Context> listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                Context context = listIterator.next();
                if (!context.getProperties().contains(property)) continue;
                if (context instanceof ViewContext) {
                    listIterator.set(new ViewContext(((ViewContext)context).getText(), ((ViewContext)context).getImage(), new Context(context.getGedcom())));
                    continue;
                }
                listIterator.set(new Context(context.getGedcom()));
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }
    }
}

