/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.app.Priority;
import genj.app.Workbench;
import genj.app.WorkbenchAdapter;
import genj.common.SelectEntityWidget;
import genj.edit.BeanPanel;
import genj.edit.EditViewFactory;
import genj.edit.actions.AbstractChange;
import genj.edit.actions.CreateAlias;
import genj.edit.actions.CreateAssociation;
import genj.edit.actions.CreateChild;
import genj.edit.actions.CreateEntity;
import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateSibling;
import genj.edit.actions.CreateSpouse;
import genj.edit.actions.CreateXReference;
import genj.edit.actions.DelEntity;
import genj.edit.actions.DelProperty;
import genj.edit.actions.OpenForEdit;
import genj.edit.actions.Redo;
import genj.edit.actions.RunExternal;
import genj.edit.actions.SetPlaceHierarchy;
import genj.edit.actions.SetSubmitter;
import genj.edit.actions.SwapSpouses;
import genj.edit.actions.Undo;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertySubmitter;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.NestedBlockLayout;
import genj.view.ActionProvider;
import genj.view.SelectionSink;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Priority(priority=90)
public class EditPlugin
extends WorkbenchAdapter
implements ActionProvider {
    private static final Resources RESOURCES = Resources.get(EditPlugin.class);
    private static final Logger LOG = Logger.getLogger("genj.edit");
    private String ACC_UNDO = "ctrl Z";
    private String ACC_REDO = "ctrl Y";
    private Workbench workbench;
    private Indi adamOrEve;

    EditPlugin(Workbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(this);
        PropertyBean.getAvailableBeans();
    }

    @Override
    public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
        if (!gedcom.getEntities("INDI").isEmpty()) {
            return;
        }
        try {
            this.wizardFirst(workbench, gedcom);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "problem in wizard", throwable);
        }
    }

    private void wizardFirst(Workbench workbench, Gedcom gedcom) throws GedcomException {
        gedcom.doUnitOfWork(new UnitOfWork(){

            public void perform(Gedcom gedcom) throws GedcomException {
                EditPlugin.this.adamOrEve = (Indi)gedcom.createEntity("INDI");
                EditPlugin.this.adamOrEve.setSex(1);
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        final BeanPanel beanPanel = new BeanPanel();
        beanPanel.setRoot(this.adamOrEve);
        for (Action action : beanPanel.getActions()) {
            jToolBar.add(action);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", beanPanel);
        jPanel.add("North", jToolBar);
        if (0 != DialogHelper.openDialog(RESOURCES.getString("wizard.first", gedcom.getName()), 3, jPanel, (Action[])Action2.okCancel(), (Object)workbench)) {
            while (gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
            return;
        }
        gedcom.doMuteUnitOfWork(new UnitOfWork(){

            public void perform(Gedcom gedcom) throws GedcomException {
                beanPanel.commit();
            }
        });
        SelectionSink.Dispatcher.fireSelection(workbench, new Context(gedcom.getFirstEntity("INDI")), true);
    }

    private void createActions(List<? extends Property> list, Action2.Group group) {
        group.add(new DelProperty(list));
    }

    private void createActions(Property property, Action2.Group group) {
        if (property instanceof PropertyFile) {
            this.createActions(group, (PropertyFile)property);
        }
        if (property instanceof PropertyPlace) {
            group.add(new SetPlaceHierarchy((PropertyPlace)property));
        }
        MetaProperty[] metaPropertyArray = property.getNestedMetaProperties(0);
        for (int i = 0; i < metaPropertyArray.length; ++i) {
            Class<? extends Property> clazz = metaPropertyArray[i].getType();
            if (clazz != PropertyNote.class && clazz != PropertyRepository.class && clazz != PropertySource.class && clazz != PropertySubmitter.class && clazz != PropertyFamilyChild.class && clazz != PropertyMedia.class) continue;
            group.add(new CreateXReference(property, metaPropertyArray[i].getTag()));
        }
        if (property instanceof PropertyEvent && (property.getEntity() instanceof Indi || property.getGedcom().getGrammar().getMeta(new TagPath("INDI:ASSO")).allows("TYPE"))) {
            group.add(new CreateAssociation(property));
        }
        if (!property.isTransient()) {
            group.add(new DelProperty(property));
        }
    }

    @Override
    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        Action2.uninstall(this.workbench, this.ACC_REDO);
        Action2.uninstall(this.workbench, this.ACC_UNDO);
        if (context.getGedcom() == null) {
            return;
        }
        switch (purpose) {
            case MENU: {
                ActionProvider.EditActionGroup editActionGroup = new ActionProvider.EditActionGroup();
                if (context.getEntity() == null) {
                    this.createActions(context.getGedcom(), (Action2.Group)editActionGroup);
                } else if (context.getEntities().size() == 1) {
                    this.createActions(context.getEntity(), (Action2.Group)editActionGroup);
                }
                group.add(editActionGroup);
                editActionGroup.add(new ActionProvider.SeparatorAction());
                editActionGroup.add(new Undo(context.getGedcom()).install(this.workbench, this.ACC_UNDO));
                editActionGroup.add(new Redo(context.getGedcom()).install(this.workbench, this.ACC_REDO));
                break;
            }
            case CONTEXT: {
                Object object;
                Object object2;
                if (context.getProperties().size() > 1) {
                    object2 = new ActionProvider.PropertiesActionGroup(context.getProperties());
                    this.createActions(context.getProperties(), (Action2.Group)object2);
                    if (((Action2.Group)object2).size() > 0) {
                        group.add((Action2)object2);
                    }
                } else if (context.getProperties().size() == 1) {
                    object2 = context.getProperty();
                    while (!(object2 instanceof Entity)) {
                        object = new ActionProvider.PropertyActionGroup((Property)object2);
                        this.createActions((Property)object2, (Action2.Group)object);
                        if (((Action2.Group)object).size() > 0) {
                            group.add((Action2)object);
                        }
                        object2 = ((Property)object2).getParent();
                    }
                }
                if (context.getEntities().size() > 1) {
                    object2 = new ArrayList();
                    for (Entity entity : context.getEntities()) {
                        if (!(entity instanceof Fam) || ((Fam)entity).getNoOfSpouses() == 0) continue;
                        object2.add((Fam)entity);
                    }
                    if (!object2.isEmpty()) {
                        object = new ActionProvider.EntitiesActionGroup(context.getEntities());
                        ((Action2.Group)object).add(new SwapSpouses((List<Fam>)object2));
                        group.add((Action2)object);
                    }
                }
                if (context.getEntities().size() == 1) {
                    object2 = new ActionProvider.EntityActionGroup(context.getEntity());
                    this.createActions(context.getEntity(), (Action2.Group)object2);
                    if (((Action2.Group)object2).size() > 0) {
                        group.add((Action2)object2);
                    }
                    if (null == this.workbench.getView(EditViewFactory.class)) {
                        group.add(new OpenForEdit(this.workbench, context));
                    }
                }
                object2 = new ActionProvider.GedcomActionGroup(context.getGedcom());
                this.createActions(context.getGedcom(), (Action2.Group)object2);
                if (((Action2.Group)object2).size() > 0) {
                    group.add((Action2)object2);
                }
                group.add(new ActionProvider.SeparatorAction());
                group.add(new Undo(context.getGedcom()));
                group.add(new Redo(context.getGedcom()));
                break;
            }
            case TOOLBAR: {
                group.add(new Undo(context.getGedcom()));
                group.add(new Redo(context.getGedcom()));
                group.add(new ActionProvider.SeparatorAction());
            }
        }
    }

    private void createActions(Entity entity, Action2.Group group) {
        if (entity instanceof Indi) {
            this.createActions((Indi)entity, group);
        }
        if (entity instanceof Fam) {
            this.createActions(group, (Fam)entity);
        }
        if (entity instanceof Submitter) {
            this.createActions(group, (Submitter)entity);
        }
        group.add(new ActionProvider.SeparatorAction());
        MetaProperty[] metaPropertyArray = entity.getNestedMetaProperties(0);
        for (int i = 0; i < metaPropertyArray.length; ++i) {
            Class<? extends Property> clazz = metaPropertyArray[i].getType();
            if (clazz != PropertyNote.class && clazz != PropertyRepository.class && clazz != PropertySource.class && clazz != PropertySubmitter.class && clazz != PropertyMedia.class) continue;
            group.add(new CreateXReference(entity, metaPropertyArray[i].getTag()));
        }
        group.add(new ActionProvider.SeparatorAction());
        if (entity != entity.getGedcom().getSubmitter()) {
            group.add(new DelEntity(entity));
        }
    }

    private void createActions(Gedcom gedcom, Action2.Group group) {
        group.add(new CreateEntity(gedcom, "INDI"));
        group.add(new CreateEntity(gedcom, "FAM"));
        group.add(new CreateEntity(gedcom, "NOTE"));
        group.add(new CreateEntity(gedcom, "OBJE"));
        group.add(new CreateEntity(gedcom, "REPO"));
        group.add(new CreateEntity(gedcom, "SOUR"));
        group.add(new CreateEntity(gedcom, "SUBM"));
    }

    private void createActions(Indi indi, Action2.Group group) {
        Action2.Group group2 = new Action2.Group(Resources.get(this).getString("add.more"));
        if (indi.getParents().size() < 2) {
            group.add(new CreateParent(indi));
        } else {
            group2.add(new CreateParent(indi));
        }
        if (indi.getPartners().length == 0) {
            group.add(new CreateSpouse(indi));
        } else {
            group2.add(new CreateSpouse(indi));
        }
        group.add(new CreateChild(indi, true));
        group.add(new CreateChild(indi, false));
        group.add(new CreateSibling(indi, true));
        group.add(new CreateSibling(indi, false));
        group2.add(new CreateAlias(indi));
        group.add(group2);
    }

    private void createActions(Action2.Group group, Fam fam) {
        group.add(new CreateChild(fam, true));
        group.add(new CreateChild(fam, false));
        if (fam.getNoOfSpouses() < 2) {
            group.add(new CreateParent(fam));
        }
        if (fam.getNoOfSpouses() != 0) {
            group.add(new SwapSpouses(fam));
        }
    }

    private void createActions(Action2.Group group, Submitter submitter) {
        group.add(new SetSubmitter(submitter));
    }

    private void createActions(Action2.Group group, PropertyFile propertyFile) {
        if (propertyFile.getFile() != null) {
            group.add(new RunExternal(propertyFile.getFile()));
        }
    }

    private static class CopyIndividual
    extends AbstractChange {
        private Gedcom source;
        private Indi existing;

        public CopyIndividual(Gedcom gedcom, Gedcom gedcom2) {
            super(gedcom, Gedcom.getEntityImage("INDI"), "Copy individual from " + gedcom2);
            this.source = gedcom2;
        }

        protected JPanel getDialogContent() {
            JPanel jPanel = new JPanel(new NestedBlockLayout("<col><row><select wx=\"1\"/></row><row><text wx=\"1\" wy=\"1\"/></row><row><check/><text/></row></col>"));
            final SelectEntityWidget selectEntityWidget = new SelectEntityWidget(this.source, "INDI", null);
            jPanel.add(selectEntityWidget);
            jPanel.add(this.getConfirmComponent());
            selectEntityWidget.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CopyIndividual.this.existing = (Indi)selectEntityWidget.getSelection();
                    CopyIndividual.this.refresh();
                }
            });
            this.existing = (Indi)selectEntityWidget.getSelection();
            this.refresh();
            return jPanel;
        }

        private boolean dupe() {
            return this.gedcom.getEntity(this.existing.getId()) != null;
        }

        protected String getConfirmMessage() {
            if (this.existing == null) {
                return "Please select an individual";
            }
            String string = "Copying individual " + this.existing + " from " + this.source.getName() + " to " + this.gedcom.getName();
            if (this.dupe()) {
                string = string + "\n\nNote: Duplicate ID - a new ID will be assigned";
            }
            return string;
        }

        protected Context execute(Gedcom gedcom, ActionEvent actionEvent) throws GedcomException {
            Entity entity = gedcom.createEntity("INDI", this.dupe() ? null : this.existing.getId());
            entity.copyProperties(this.existing.getProperties(), true);
            return new Context(entity);
        }
    }
}

