/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateXReference
extends CreateRelationship {
    private Property source;
    private String sourceTag;
    private PropertyXRef xref;

    public CreateXReference(Property property, String string) {
        super(CreateXReference.getName(property, string), property.getGedcom(), CreateXReference.getTargetType(property, string));
        this.source = property;
        this.sourceTag = string;
    }

    private static String getTargetType(Property property, String string) {
        try {
            PropertyXRef propertyXRef = (PropertyXRef)property.getMetaProperty().getNested(string, false).create("@@");
            return propertyXRef.getTargetType();
        }
        catch (GedcomException gedcomException) {
            Logger.getLogger("genj.edit.actions").log(Level.SEVERE, "couldn't determine target type", gedcomException);
            throw new RuntimeException("Couldn't determine target type for source tag " + string);
        }
    }

    private static String getName(Property property, String string) {
        String string2 = CreateXReference.getTargetType(property, string);
        if (string2.equals(string)) {
            return Gedcom.getName(string2);
        }
        return Gedcom.getName(string2) + " (" + Gedcom.getName(string) + ")";
    }

    public String getDescription() {
        return resources.getString("create.xref.desc", Gedcom.getName(this.targetType), this.source.getEntity().toString());
    }

    protected Property change(Entity entity, boolean bl) throws GedcomException {
        this.xref = (PropertyXRef)this.source.addProperty(this.sourceTag, '@' + entity.getId() + '@');
        try {
            this.xref.link();
            this.xref.addDefaultProperties();
        }
        catch (GedcomException gedcomException) {
            this.source.delProperty(this.xref);
            this.xref = null;
            throw gedcomException;
        }
        return bl ? this.xref.getTarget() : this.xref;
    }

    public PropertyXRef getReference() {
        return this.xref;
    }
}

