/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.EnvironmentChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar {
    private static final Logger LOG = Logger.getLogger("genj.gedcom");
    public static final Grammar V55 = new Grammar("contrib/LDS/gedcom-5-5.xml");
    public static final Grammar V551 = new Grammar("contrib/LDS/gedcom-5-5-1.xml");
    private String version;
    private Map<String, MetaProperty> tag2root = new HashMap<String, MetaProperty>();

    private Grammar(String string) {
        SAXParser sAXParser;
        try {
            sAXParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Throwable throwable) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't setup SAX parser", throwable);
            throw new Error(throwable);
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream != null) {
                LOG.info("Loading grammar through classloader");
            } else {
                try {
                    inputStream = new FileInputStream(new File(EnvironmentChecker.getProperty("user.dir", ".", "current directory for grammar"), string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = new FileInputStream(new File("../app/" + string));
                }
            }
            sAXParser.parse(new InputSource(new InputStreamReader(inputStream)), (DefaultHandler)new Parser());
        }
        catch (Throwable throwable) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't parse grammar", throwable);
            throw new Error(throwable);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public TagPath[] getAllPaths(String string, Class<? extends Property> clazz) {
        return this.getPathsRecursively(string, clazz);
    }

    private TagPath[] getPathsRecursively(String string, Class<? extends Property> clazz) {
        ArrayList<TagPath> arrayList = new ArrayList<TagPath>();
        for (MetaProperty metaProperty : this.tag2root.values()) {
            String string2 = metaProperty.getTag();
            if (string != null && !string2.equals(string)) continue;
            this.getPathsRecursively(metaProperty, clazz, new TagPath(string2), arrayList);
        }
        return TagPath.toArray(arrayList);
    }

    private void getPathsRecursively(MetaProperty metaProperty, Class<? extends Property> clazz, TagPath tagPath, Collection<TagPath> collection) {
        if (!metaProperty.isInstantiated) {
            return;
        }
        if (clazz.isAssignableFrom(metaProperty.getType())) {
            collection.add(tagPath);
        }
        for (MetaProperty metaProperty2 : metaProperty.nested) {
            this.getPathsRecursively(metaProperty2, clazz, new TagPath(tagPath, metaProperty2.getTag()), collection);
        }
    }

    public MetaProperty getMeta(TagPath tagPath) {
        return this.getMeta(tagPath, true);
    }

    public MetaProperty getMeta(TagPath tagPath, boolean bl) {
        return this.getMetaRecursively(tagPath, bl);
    }

    MetaProperty getMetaRecursively(TagPath tagPath, boolean bl) {
        String string = tagPath.get(0);
        MetaProperty metaProperty = this.tag2root.get(string);
        if (metaProperty == null) {
            metaProperty = new MetaProperty(this, string, new HashMap<String, String>(), false);
            this.tag2root.put(string, metaProperty);
        }
        return metaProperty.getNestedRecursively(tagPath, 1, bl);
    }

    public boolean isValid(TagPath tagPath) {
        String string = tagPath.get(0);
        MetaProperty metaProperty = this.tag2root.get(string);
        if (metaProperty == null) {
            return false;
        }
        for (int i = 1; i < tagPath.length(); ++i) {
            string = tagPath.get(i);
            if (!metaProperty.allows(string)) {
                return false;
            }
            metaProperty = metaProperty.getNested(string, false);
        }
        return true;
    }

    private class Parser
    extends DefaultHandler {
        private Stack<MetaProperty> stack = null;

        private Parser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            MetaProperty metaProperty;
            if (this.stack == null) {
                if (!"GEDCOM".equals(string3)) {
                    throw new RuntimeException("expected GEDCOM");
                }
                Grammar.this.version = attributes.getValue("version");
                if (Grammar.this.version == null) {
                    throw new RuntimeException("expected GEDCOM version");
                }
                this.stack = new Stack();
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                hashMap.put(attributes.getQName(i), attributes.getValue(i));
            }
            try {
                metaProperty = new MetaProperty(Grammar.this, string3, hashMap, true);
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Problem instantiating meta property for " + string3 + " with " + hashMap, throwable.getCause() != null ? throwable.getCause() : throwable);
                throw new Error("Can't parse Gedcom Grammar");
            }
            if (this.stack.isEmpty()) {
                metaProperty.isInstantiated = true;
                Grammar.this.tag2root.put(string3, metaProperty);
            } else {
                this.stack.peek().addNested(metaProperty);
            }
            this.stack.push(metaProperty);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("GEDCOM".equals(string3)) {
                this.stack = null;
            } else {
                this.stack.pop();
            }
        }
    }
}

